/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.utils;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.StringUtil;

public class Span
implements Comparable<Span> {
    private int start;
    private int end;
    private double prob;
    private String type;

    public Span(int s, int e, String type) {
        if (s < 0) {
            throw new IllegalArgumentException("start index must be zero or greater: " + s);
        }
        if (e < 0) {
            throw new IllegalArgumentException("end index must be zero or greater: " + e);
        }
        if (s > e) {
            throw new IllegalArgumentException("start index must not be larger than end index: start=" + s + ", end=" + e);
        }
        this.start = s;
        this.end = e;
        this.type = type;
        this.prob = 0.0;
    }

    public Span(int s, int e, String type, double prob) {
        if (s < 0) {
            throw new IllegalArgumentException("start index must be zero or greater: " + s);
        }
        if (e < 0) {
            throw new IllegalArgumentException("end index must be zero or greater: " + e);
        }
        if (s > e) {
            throw new IllegalArgumentException("start index must not be larger than end index: start=" + s + ", end=" + e);
        }
        this.start = s;
        this.end = e;
        this.prob = prob;
        this.type = type;
    }

    public Span(int s, int e) {
        this(s, e, null, 0.0);
    }

    public Span(int s, int e, double prob) {
        this(s, e, null, prob);
    }

    public Span(Span span, int offset) {
        this(span.start + offset, span.end + offset, span.getType(), span.getProb());
    }

    public Span(Span span, double prob) {
        this(span.start, span.end, span.getType(), prob);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public int length() {
        return this.end - this.start;
    }

    public double getProb() {
        return this.prob;
    }

    public boolean contains(Span s) {
        return this.start <= s.getStart() && s.getEnd() <= this.end;
    }

    public boolean contains(int index) {
        return this.start <= index && index < this.end;
    }

    public boolean startsWith(Span s) {
        return this.getStart() == s.getStart() && this.contains(s);
    }

    public boolean intersects(Span s) {
        int sstart = s.getStart();
        return this.contains(s) || s.contains(this) || this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd();
    }

    public boolean crosses(Span s) {
        int sstart = s.getStart();
        return !this.contains(s) && !s.contains(this) && (this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd());
    }

    public Span trim(CharSequence text) {
        int newStartOffset = this.getStart();
        for (int i = this.getStart(); i < this.getEnd() && StringUtil.isWhitespace((char)text.charAt(i)); ++i) {
            ++newStartOffset;
        }
        int newEndOffset = this.getEnd();
        for (int i = this.getEnd(); i > this.getStart() && StringUtil.isWhitespace((char)text.charAt(i - 1)); --i) {
            --newEndOffset;
        }
        if (newStartOffset == this.getStart() && newEndOffset == this.getEnd()) {
            return this;
        }
        if (newStartOffset > newEndOffset) {
            return new Span(this.getStart(), this.getStart(), this.getType());
        }
        return new Span(newStartOffset, newEndOffset, this.getType());
    }

    @Override
    public int compareTo(Span s) {
        if (this.getStart() < s.getStart()) {
            return -1;
        }
        if (this.getStart() == s.getStart()) {
            if (this.getEnd() > s.getEnd()) {
                return -1;
            }
            if (this.getEnd() < s.getEnd()) {
                return 1;
            }
            if (this.getType() == null && s.getType() == null) {
                return 0;
            }
            if (this.getType() != null && s.getType() != null) {
                return this.getType().compareTo(s.getType());
            }
            if (this.getType() != null) {
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public int hashCode() {
        int res = 23;
        res = res * 37 + this.getStart();
        res = res * 37 + this.getEnd();
        res = this.getType() == null ? (res *= 37) : res * 37 + this.getType().hashCode();
        return res;
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            result = true;
        } else if (o instanceof Span) {
            Span s = (Span)o;
            result = !(this.getStart() != s.getStart() || this.getEnd() != s.getEnd() || this.getType() != null && !this.type.equals(s.getType()) || s.getType() != null && !s.getType().equals(this.getType()));
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuilder toStringBuffer = new StringBuilder(15);
        toStringBuffer.append("[");
        toStringBuffer.append(this.getStart());
        toStringBuffer.append("..");
        toStringBuffer.append(this.getEnd());
        toStringBuffer.append(")");
        if (this.getType() != null) {
            toStringBuffer.append(" ");
            toStringBuffer.append(this.getType());
        }
        return toStringBuffer.toString();
    }

    public CharSequence getCoveredText(CharSequence text) {
        if (this.getEnd() > text.length()) {
            throw new IllegalArgumentException("The span " + this.toString() + " is outside the given text which has length " + text.length() + "!");
        }
        return text.subSequence(this.getStart(), this.getEnd());
    }

    public String getCoveredText(String[] tokens) {
        StringBuilder sb = new StringBuilder();
        for (int si = this.getStart(); si < this.getEnd(); ++si) {
            sb.append(tokens[si]).append(" ");
        }
        return sb.toString().trim();
    }

    public static String[] spansToStrings(Span[] spans, CharSequence s) {
        String[] tokens = new String[spans.length];
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            tokens[si] = spans[si].getCoveredText(s).toString();
        }
        return tokens;
    }

    public static String[] spansToStrings(Span[] spans, String[] tokens) {
        String[] chunks = new String[spans.length];
        StringBuilder cb = new StringBuilder();
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            cb.setLength(0);
            for (int ti = spans[si].getStart(); ti < spans[si].getEnd(); ++ti) {
                cb.append(tokens[ti]).append(" ");
            }
            chunks[si] = cb.substring(0, cb.length() - 1);
        }
        return chunks;
    }

    public static String[] getTypesFromSpans(Span[] spans, String[] tokens) {
        ArrayList<String> tagsList = new ArrayList<String>();
        for (Span span : spans) {
            tagsList.add(span.getType());
        }
        return tagsList.toArray(new String[tagsList.size()]);
    }

    public static final void postProcessDuplicatedSpans(List<Span> preList, Span[] postList) {
        ArrayList<Span> duplicatedSpans = new ArrayList<Span>();
        for (Span span1 : preList) {
            for (Span span2 : postList) {
                if (span1.contains(span2)) {
                    duplicatedSpans.add(span1);
                    continue;
                }
                if (!span2.contains(span1)) continue;
                duplicatedSpans.add(span1);
            }
        }
        preList.removeAll(duplicatedSpans);
    }

    public static final void concatenateSpans(List<Span> allSpans, Span[] neSpans) {
        for (Span span : neSpans) {
            allSpans.add(span);
        }
    }
}

