/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.resources.WordCluster;
import java.util.ArrayList;
import java.util.List;

public class BrownTokenClasses {
    public static final int[] pathLengths = new int[]{4, 6, 10, 20};

    public static List<String> getWordClasses(String token, WordCluster brownLexicon) {
        if (brownLexicon.lookupToken(token) == null) {
            return new ArrayList<String>(0);
        }
        String brownClass = brownLexicon.lookupToken(token);
        ArrayList<String> pathLengthsList = new ArrayList<String>();
        pathLengthsList.add(brownClass.substring(0, Math.min(brownClass.length(), pathLengths[0])));
        for (int i = 1; i < pathLengths.length; ++i) {
            if (pathLengths[i - 1] >= brownClass.length()) continue;
            pathLengthsList.add(brownClass.substring(0, Math.min(brownClass.length(), pathLengths[i])));
        }
        return pathLengthsList;
    }

    public static void printList(List<String> classList) {
        for (int i = 0; i < classList.size(); ++i) {
            System.out.print(" " + classList.get(i));
        }
        System.out.println("");
    }
}

