/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.lemma.DictionaryLemmatizer;
import eus.ixa.ixa.pipe.ml.resources.MFSResource;
import eus.ixa.ixa.pipe.ml.resources.SequenceModelResource;
import eus.ixa.ixa.pipe.ml.utils.Flags;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class MFSFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private SequenceModelResource posModelResource;
    private DictionaryLemmatizer lemmaDictResource;
    private MFSResource mfsDictResource;
    private String[] currentSentence;
    private Span[] currentTags;
    private List<String> currentLemmas;
    private List<String> currentMFSList;
    private boolean isPos;
    private boolean isPosClass;
    private boolean isLemma;
    private boolean isMFS;
    private boolean isMonosemic;
    private boolean isBio;

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentTags = this.posModelResource.seqToSpans(tokens);
            this.currentLemmas = this.lemmaDictResource.lemmatize(tokens, this.currentTags);
            this.currentMFSList = this.isBio ? this.mfsDictResource.getFirstSenseBio(this.currentLemmas, this.currentTags) : this.mfsDictResource.getFirstSenseBilou(this.currentLemmas, this.currentTags);
        }
        String posTag = this.currentTags[index].getType();
        if (this.isPos) {
            features.add("posTag=" + posTag);
        }
        if (this.isPosClass) {
            String posTagClass = posTag.substring(0, 1);
            features.add("posTagClass=" + posTagClass);
        }
        if (this.isLemma) {
            String lemma = this.currentLemmas.get(index);
            features.add("lemma=" + lemma);
        }
        if (this.isMFS) {
            String mfs = this.currentMFSList.get(index);
            features.add("mfs=" + mfs);
            features.add("mfs,lemma=" + mfs + "," + this.currentLemmas.get(index));
        }
        if (this.isMonosemic) {
            // empty if block
        }
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    @Override
    public void clearAdaptiveData() {
    }

    @Override
    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof SequenceModelResource)) {
            throw new InvalidFormatException("Not a POSModelResource for key: " + properties.get("model"));
        }
        this.posModelResource = (SequenceModelResource)posResource;
        Object lemmaResource = resourceProvider.getResource(properties.get("dict"));
        if (!(lemmaResource instanceof DictionaryLemmatizer)) {
            throw new InvalidFormatException("Not a LemmaResource for key: " + properties.get("dict"));
        }
        this.lemmaDictResource = (DictionaryLemmatizer)lemmaResource;
        Object mfsResource = resourceProvider.getResource(properties.get("mfs"));
        if (!(mfsResource instanceof MFSResource)) {
            throw new InvalidFormatException("Not a MFSResource for key: " + properties.get("mfs"));
        }
        this.mfsDictResource = (MFSResource)mfsResource;
        this.processRangeOptions(properties);
        this.isBio = !properties.get("seqCodec").equalsIgnoreCase("bilou");
    }

    private void processRangeOptions(Map<String, String> properties) {
        String featuresRange = properties.get("range");
        String[] rangeArray = Flags.processMFSFeaturesRange(featuresRange);
        if (rangeArray[0].equalsIgnoreCase("pos")) {
            this.isPos = true;
        }
        if (rangeArray[1].equalsIgnoreCase("posclass")) {
            this.isPosClass = true;
        }
        if (rangeArray[2].equalsIgnoreCase("lemma")) {
            this.isLemma = true;
        }
        if (rangeArray[3].equalsIgnoreCase("mfs")) {
            this.isMFS = true;
        }
        if (rangeArray[4].equalsIgnoreCase("monosemic")) {
            this.isMonosemic = true;
        }
    }

    @Override
    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, ArtifactSerializer<SequenceModelResource>> mapping = new HashMap<String, ArtifactSerializer<SequenceModelResource>>();
        mapping.put("posmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
        mapping.put("lemmadictserializer", new DictionaryLemmatizer.DictionaryLemmatizerSerializer());
        mapping.put("mfsdictserializer", new MFSResource.MFSResourceSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

