/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.formats;

import eus.ixa.ixa.pipe.ml.formats.CoNLL02Format;
import eus.ixa.ixa.pipe.ml.parse.Parse;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class ParseToCoNLL02Format
extends FilterObjectStream<Parse, SequenceLabelSample> {
    public ParseToCoNLL02Format(ObjectStream<Parse> in) {
        super(in);
    }

    @Override
    public SequenceLabelSample read() throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> seqTypes = new ArrayList<String>();
        Parse parse = (Parse)this.samples.read();
        boolean isClearAdaptiveData = false;
        if (parse != null) {
            isClearAdaptiveData = true;
            List<Parse> chunks = ParseToCoNLL02Format.getInitialChunks(parse);
            int cl = chunks.size();
            for (int ci = 0; ci < cl; ++ci) {
                Parse[] children;
                Parse c = chunks.get(ci);
                if (c.isPosTag()) {
                    tokens.add(c.getCoveredText());
                    seqTypes.add("O");
                    continue;
                }
                boolean start = true;
                String ctype = c.getType();
                for (Parse tok : children = c.getChildren()) {
                    tokens.add(tok.getCoveredText());
                    if (start) {
                        seqTypes.add("B-" + ctype);
                        start = false;
                        continue;
                    }
                    seqTypes.add("I-" + ctype);
                }
            }
        }
        if (tokens.size() > 0) {
            ArrayList<Span> sequences = new ArrayList<Span>();
            int beginIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < seqTypes.size(); ++i) {
                String seqTag = (String)seqTypes.get(i);
                if (seqTag.startsWith("B-")) {
                    if (beginIndex != -1) {
                        sequences.add(CoNLL02Format.extract(beginIndex, endIndex, (String)seqTypes.get(beginIndex)));
                        beginIndex = -1;
                        endIndex = -1;
                    }
                    beginIndex = i;
                    endIndex = i + 1;
                    continue;
                }
                if (seqTag.startsWith("I-")) {
                    ++endIndex;
                    continue;
                }
                if (seqTag.equals("O")) {
                    if (beginIndex == -1) continue;
                    sequences.add(CoNLL02Format.extract(beginIndex, endIndex, (String)seqTypes.get(beginIndex)));
                    beginIndex = -1;
                    endIndex = -1;
                    continue;
                }
                throw new IOException("Invalid tag: " + seqTag);
            }
            if (beginIndex != -1) {
                sequences.add(CoNLL02Format.extract(beginIndex, endIndex, (String)seqTypes.get(beginIndex)));
            }
            SequenceLabelSample sequenceSample = new SequenceLabelSample(tokens.toArray(new String[tokens.size()]), sequences.toArray(new Span[sequences.size()]), isClearAdaptiveData);
            return sequenceSample;
        }
        return null;
    }

    private static List<Parse> getInitialChunks(Parse p) {
        ArrayList<Parse> chunks = new ArrayList<Parse>();
        ParseToCoNLL02Format.getInitialChunks(p, chunks);
        return chunks;
    }

    private static void getInitialChunks(Parse p, List<Parse> ichunks) {
        if (p.isPosTag()) {
            ichunks.add(p);
        } else {
            Parse[] kids = p.getChildren();
            boolean allKidsAreTags = true;
            int cl = kids.length;
            for (int ci = 0; ci < cl; ++ci) {
                if (kids[ci].isPosTag()) continue;
                allKidsAreTags = false;
                break;
            }
            if (allKidsAreTags) {
                ichunks.add(p);
            } else {
                for (Parse kid : kids) {
                    ParseToCoNLL02Format.getInitialChunks(kid, ichunks);
                }
            }
        }
    }
}

