/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.parse;

import eus.ixa.ixa.pipe.ml.parse.HeadRules;
import eus.ixa.ixa.pipe.ml.parse.Parse;
import eus.ixa.ixa.pipe.ml.parse.ShiftReduceParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.Event;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;

public abstract class AbstractParserEventStream
extends AbstractEventStream<Parse> {
    protected HeadRules rules;
    protected Set<String> punctSet;
    protected ParserEventTypeEnum etype;
    protected boolean fixPossesives;
    protected Dictionary dict;

    public AbstractParserEventStream(ObjectStream<Parse> dataStream, HeadRules rules, ParserEventTypeEnum etype) {
        super(dataStream);
        this.rules = rules;
        this.punctSet = rules.getPunctuationTags();
        this.etype = etype;
        this.init();
    }

    @Override
    protected Iterator<Event> createEvents(Parse sample) {
        ArrayList<Event> newEvents = new ArrayList<Event>();
        Parse.pruneParse(sample);
        if (this.fixPossesives) {
            Parse.fixPossesives(sample);
        }
        sample.updateHeads(this.rules);
        Parse[] chunks = AbstractParserEventStream.getInitialChunks(sample);
        this.addParseEvents(newEvents, ShiftReduceParser.collapsePunctuation(chunks, this.punctSet));
        return newEvents.iterator();
    }

    protected void init() {
        this.fixPossesives = false;
    }

    public static Parse[] getInitialChunks(Parse p) {
        ArrayList<Parse> chunks = new ArrayList<Parse>();
        AbstractParserEventStream.getInitialChunks(p, chunks);
        return chunks.toArray(new Parse[chunks.size()]);
    }

    private static void getInitialChunks(Parse p, List<Parse> ichunks) {
        if (p.isPosTag()) {
            ichunks.add(p);
        } else {
            Parse[] kids = p.getChildren();
            boolean allKidsAreTags = true;
            int cl = kids.length;
            for (int ci = 0; ci < cl; ++ci) {
                if (kids[ci].isPosTag()) continue;
                allKidsAreTags = false;
                break;
            }
            if (allKidsAreTags) {
                ichunks.add(p);
            } else {
                for (Parse kid : kids) {
                    AbstractParserEventStream.getInitialChunks(kid, ichunks);
                }
            }
        }
    }

    protected abstract void addParseEvents(List<Event> var1, Parse[] var2);

    protected boolean lastChild(Parse child, Parse parent) {
        Parse[] kids = ShiftReduceParser.collapsePunctuation(parent.getChildren(), this.punctSet);
        return kids[kids.length - 1] == child;
    }
}

