/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.parse;

import eus.ixa.ixa.pipe.ml.parse.AncoraHeadRules;
import eus.ixa.ixa.pipe.ml.parse.HeadFinder;
import eus.ixa.ixa.pipe.ml.parse.HeadRules;
import eus.ixa.ixa.pipe.ml.parse.Parse;
import eus.ixa.ixa.pipe.ml.parse.PennTreebankHeadRules;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class CollinsHeadFinder
implements HeadFinder {
    private static Map<String, HeadRules> headRulesMap = new HashMap<String, HeadRules>();
    private final HeadRules headRules;
    private static boolean DEBUG = false;
    public static final String HEADMARK = "=H";

    public CollinsHeadFinder(Properties properties) {
        String lang = properties.getProperty("language");
        this.headRules = this.loadHeadRules(lang);
    }

    private HeadRules loadHeadRules(String lang) {
        try {
            if (headRulesMap.get("lang") == null) {
                InputStream is = this.getHeadRulesFile(lang);
                if (lang.equalsIgnoreCase("en")) {
                    headRulesMap.put(lang, new PennTreebankHeadRules(new InputStreamReader(is)));
                } else if (lang.equalsIgnoreCase("es")) {
                    headRulesMap.put(lang, new AncoraHeadRules(new InputStreamReader(is)));
                }
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return headRulesMap.get(lang);
    }

    private InputStream getHeadRulesFile(String lang) {
        InputStream headsFileInputStream = null;
        if (lang.equals("en")) {
            headsFileInputStream = this.getClass().getResourceAsStream("/parser/en-head-rules");
        } else if (lang.equals("es")) {
            headsFileInputStream = this.getClass().getResourceAsStream("/parser/es-head-rules");
        }
        return headsFileInputStream;
    }

    @Override
    public void printHeads(Parse parse) {
        if (parse == null || parse.getChildCount() == 0) {
            throw new IllegalArgumentException("Can't return head of null or leaf Parse.");
        }
        LinkedList<Parse> nodes = new LinkedList<Parse>();
        nodes.add(parse);
        while (!nodes.isEmpty()) {
            Parse currentNode = (Parse)nodes.removeFirst();
            String type = currentNode.getType().replace(HEADMARK, "");
            if (DEBUG) {
                System.err.println("-> Current Node: " + type + " " + currentNode.toString());
            }
            Parse[] children = currentNode.getChildren();
            Parse headChild = null;
            if (children.length > 0) {
                headChild = this.headRules.getHead(children, type);
            }
            for (Parse child : currentNode.getChildren()) {
                if (child == headChild) {
                    child.setType(child.getType() + HEADMARK);
                }
                nodes.addLast(child);
            }
        }
    }
}

