/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.parse;

import eus.ixa.ixa.pipe.ml.parse.BuildContextGenerator;
import eus.ixa.ixa.pipe.ml.parse.CheckContextGenerator;
import eus.ixa.ixa.pipe.ml.parse.HeadRules;
import eus.ixa.ixa.pipe.ml.parse.Parse;
import eus.ixa.ixa.pipe.ml.parse.ParserFactory;
import eus.ixa.ixa.pipe.ml.parse.ShiftReduceParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.tools.ml.model.Event;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;

public class ParserEventStream
extends AbstractEventStream<Parse> {
    private final HeadRules rules;
    private final Set<String> punctSet;
    private final ParserEventTypeEnum etype;
    private boolean fixPossesives;
    private BuildContextGenerator bcg;
    private CheckContextGenerator kcg;

    public ParserEventStream(ObjectStream<Parse> samples, HeadRules rules, ParserEventTypeEnum etype, ParserFactory factory) {
        super(samples);
        this.rules = rules;
        this.punctSet = rules.getPunctuationTags();
        this.etype = etype;
        this.init();
    }

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype) {
        this(d, rules, etype, null);
    }

    private void init() {
        if (this.etype == ParserEventTypeEnum.BUILD) {
            this.bcg = new BuildContextGenerator();
        } else if (this.etype == ParserEventTypeEnum.CHECK) {
            this.kcg = new CheckContextGenerator();
        }
        this.fixPossesives = false;
    }

    @Override
    protected Iterator<Event> createEvents(Parse sample) {
        ArrayList<Event> newEvents = new ArrayList<Event>();
        Parse.pruneParse(sample);
        if (this.fixPossesives) {
            Parse.fixPossesives(sample);
        }
        sample.updateHeads(this.rules);
        Parse[] chunks = ParserEventStream.getInitialChunks(sample);
        this.addParseEvents(newEvents, ShiftReduceParser.collapsePunctuation(chunks, this.punctSet));
        return newEvents.iterator();
    }

    private void addParseEvents(List<Event> parseEvents, Parse[] chunks) {
        for (int ci = 0; ci < chunks.length; ++ci) {
            int start;
            Parse c = chunks[ci];
            Parse parent = c.getParent();
            if (parent == null) continue;
            String type = parent.getType();
            String outcome = this.firstChild(c, parent) ? type + "-" + "start" : type + "-" + "cont";
            c.setLabel(outcome);
            if (this.etype == ParserEventTypeEnum.BUILD) {
                parseEvents.add(new Event(outcome, this.bcg.getContext(chunks, ci)));
            }
            for (start = ci - 1; start >= 0 && chunks[start].getParent() == parent; --start) {
            }
            if (this.lastChild(c, parent)) {
                int reduceStart;
                if (this.etype == ParserEventTypeEnum.CHECK) {
                    parseEvents.add(new Event("c", this.kcg.getContext(chunks, type, start + 1, ci)));
                }
                for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
                }
                chunks = ParserEventStream.reduceChunks(chunks, ci, parent);
                ci = ++reduceStart - 1;
                continue;
            }
            if (this.etype != ParserEventTypeEnum.CHECK) continue;
            parseEvents.add(new Event("i", this.kcg.getContext(chunks, type, start + 1, ci)));
        }
    }

    public static Parse[] getInitialChunks(Parse p) {
        ArrayList<Parse> chunks = new ArrayList<Parse>();
        ParserEventStream.getInitialChunks(p, chunks);
        return chunks.toArray(new Parse[chunks.size()]);
    }

    private static void getInitialChunks(Parse p, List<Parse> ichunks) {
        if (p.isPosTag()) {
            ichunks.add(p);
        } else {
            Parse[] kids = p.getChildren();
            boolean allKidsAreTags = true;
            int cl = kids.length;
            for (int ci = 0; ci < cl; ++ci) {
                if (kids[ci].isPosTag()) continue;
                allKidsAreTags = false;
                break;
            }
            if (allKidsAreTags) {
                ichunks.add(p);
            } else {
                for (Parse kid : kids) {
                    ParserEventStream.getInitialChunks(kid, ichunks);
                }
            }
        }
    }

    protected boolean firstChild(Parse child, Parse parent) {
        return ShiftReduceParser.collapsePunctuation(parent.getChildren(), this.punctSet)[0] == child;
    }

    public static Parse[] reduceChunks(Parse[] chunks, int ci, Parse parent) {
        Parse[] reducedChunks;
        int reduceStart;
        String type = parent.getType();
        int reduceEnd = ci;
        for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
        }
        ++reduceStart;
        if (!type.equals("TOP")) {
            int ri;
            reducedChunks = new Parse[chunks.length - (reduceEnd - reduceStart + 1) + 1];
            int rn = reduceStart;
            for (ri = 0; ri < rn; ++ri) {
                reducedChunks[ri] = chunks[ri];
            }
            reducedChunks[reduceStart] = parent;
            parent.setPrevPunctuation(chunks[reduceStart].getPreviousPunctuationSet());
            parent.setNextPunctuation(chunks[reduceEnd].getNextPunctuationSet());
            ri = reduceStart + 1;
            for (int rci = reduceEnd + 1; rci < chunks.length; ++rci) {
                reducedChunks[ri] = chunks[rci];
                ++ri;
            }
            ci = reduceStart - 1;
        } else {
            reducedChunks = new Parse[]{};
        }
        return reducedChunks;
    }

    protected boolean lastChild(Parse child, Parse parent) {
        Parse[] kids = ShiftReduceParser.collapsePunctuation(parent.getChildren(), this.punctSet);
        return kids[kids.length - 1] == child;
    }
}

