/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.parse;

import eus.ixa.ixa.pipe.ml.parse.BuildContextGenerator;
import eus.ixa.ixa.pipe.ml.parse.CheckContextGenerator;
import java.util.Map;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;

public class ParserFactory
extends BaseToolFactory {
    private static final String AUTO_DICTIONARY_ENTRY_NAME = "autodict";
    private Map<String, Object> resources;
    private Dictionary autoDict;

    public ParserFactory() {
    }

    public ParserFactory(Dictionary autoDict, Map<String, Object> resources) {
        this.init(autoDict, resources);
    }

    private void init(Dictionary autoDict, Map<String, Object> resources) {
        this.autoDict = autoDict;
        this.resources = resources;
    }

    public Dictionary getDictionary() {
        if (this.autoDict == null && this.artifactProvider != null) {
            this.autoDict = (Dictionary)this.artifactProvider.getArtifact(AUTO_DICTIONARY_ENTRY_NAME);
        }
        return this.autoDict;
    }

    public void setDictionary(Dictionary autoDict) {
        if (this.artifactProvider != null) {
            throw new IllegalStateException("Can not set ngram dictionary while using artifact provider.");
        }
        this.autoDict = autoDict;
    }

    protected Map<String, Object> getResources() {
        return this.resources;
    }

    public static ParserFactory create(String subclassName, Dictionary autoDict, Map<String, Object> resources) throws InvalidFormatException {
        if (subclassName == null) {
            return new ParserFactory();
        }
        try {
            ParserFactory theFactory = ExtensionLoader.instantiateExtension(ParserFactory.class, subclassName);
            theFactory.init(autoDict, resources);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    public BuildContextGenerator createBuildContextGenerator() {
        return new BuildContextGenerator(this.getDictionary(), this.getResources());
    }

    public CheckContextGenerator createCheckContextGenerator() {
        return new CheckContextGenerator(this.getResources());
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        if (this.autoDict != null) {
            artifactMap.put(AUTO_DICTIONARY_ENTRY_NAME, this.autoDict);
        }
        return artifactMap;
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        Object ngramDictEntry = this.artifactProvider.getArtifact(AUTO_DICTIONARY_ENTRY_NAME);
        if (ngramDictEntry != null && !(ngramDictEntry instanceof Dictionary)) {
            throw new InvalidFormatException("NGram dictionary has wrong type!");
        }
    }
}

