/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.resources;

import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerME;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import eus.ixa.ixa.pipe.ml.utils.Span;
import eus.ixa.ixa.pipe.ml.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class SequenceModelResource
implements SerializableArtifact {
    private final SequenceLabelerModel seqModel;
    private final SequenceLabelerME sequenceLabeler;

    public SequenceModelResource(InputStream in) throws IOException {
        this.seqModel = new SequenceLabelerModel(in);
        this.sequenceLabeler = new SequenceLabelerME(this.seqModel);
    }

    public Span[] seqToSpans(String[] tokens) {
        Span[] origSpans = this.sequenceLabeler.tag(tokens);
        Span[] seqSpans = SequenceLabelerME.dropOverlappingSpans(origSpans);
        return seqSpans;
    }

    public String[] lemmatize(String[] tokens) {
        Span[] origSpans = this.sequenceLabeler.tag(tokens);
        Span[] seqSpans = SequenceLabelerME.dropOverlappingSpans(origSpans);
        String[] decodedLemmas = StringUtils.decodeLemmas(tokens, seqSpans);
        return decodedLemmas;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        this.seqModel.serialize(out);
        ((Writer)writer).flush();
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return SequenceModelResourceSerializer.class;
    }

    public static class SequenceModelResourceSerializer
    implements ArtifactSerializer<SequenceModelResource> {
        @Override
        public SequenceModelResource create(InputStream in) throws IOException, InvalidFormatException {
            return new SequenceModelResource(in);
        }

        @Override
        public void serialize(SequenceModelResource artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

