/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.BilouSequenceValidator;
import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.util.SequenceValidator;

public class BilouCodec
implements SequenceLabelerCodec<String> {
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String LAST = "last";
    public static final String UNIT = "unit";
    public static final String OTHER = "other";

    @Override
    public Span[] decode(List<String> c) {
        int start = -1;
        int end = -1;
        ArrayList<Span> spans = new ArrayList<Span>(c.size());
        for (int li = 0; li < c.size(); ++li) {
            String chunkTag = c.get(li);
            if (chunkTag.endsWith(START)) {
                start = li;
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(CONTINUE)) {
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(LAST)) {
                if (start == -1) continue;
                spans.add(new Span(start, end + 1, BioCodec.extractSequenceType(c.get(li - 1))));
                start = -1;
                end = -1;
                continue;
            }
            if (chunkTag.endsWith(UNIT)) {
                spans.add(new Span(li, li + 1, BioCodec.extractSequenceType(c.get(li))));
                continue;
            }
            if (!chunkTag.endsWith(OTHER)) continue;
        }
        return spans.toArray(new Span[spans.size()]);
    }

    public String[] encode(Span[] sequences, int length) {
        Object[] outcomes = new String[length];
        Arrays.fill(outcomes, OTHER);
        for (Span name : sequences) {
            if (name.length() > 1) {
                outcomes[name.getStart()] = name.getType() == null ? "default-start" : name.getType() + "-" + START;
                for (int i = name.getStart() + 1; i < name.getEnd() - 1; ++i) {
                    outcomes[i] = name.getType() == null ? "default-cont" : name.getType() + "-" + CONTINUE;
                }
                if (name.getType() == null) {
                    outcomes[name.getEnd() - 1] = "default-last";
                    continue;
                }
                outcomes[name.getEnd() - 1] = name.getType() + "-" + LAST;
                continue;
            }
            outcomes[name.getEnd() - 1] = name.getType() == null ? "default-unit" : name.getType() + "-" + UNIT;
        }
        return outcomes;
    }

    @Override
    public SequenceValidator<String> createSequenceValidator() {
        return new BilouSequenceValidator();
    }

    @Override
    public boolean areOutcomesCompatible(String[] outcomes) {
        return true;
    }
}

