/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerSequenceValidator;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BioCodec
implements SequenceLabelerCodec<String> {
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String OTHER = "other";
    private static final Pattern typedOutcomePattern = Pattern.compile("(.+)-\\S+");

    public static final String extractSequenceType(String outcome) {
        Matcher matcher = typedOutcomePattern.matcher(outcome);
        if (matcher.matches()) {
            String seqType = matcher.group(1);
            return seqType;
        }
        return null;
    }

    @Override
    public Span[] decode(List<String> c) {
        int start = -1;
        int end = -1;
        ArrayList<Span> spans = new ArrayList<Span>(c.size());
        for (int li = 0; li < c.size(); ++li) {
            String chunkTag = c.get(li);
            if (chunkTag.endsWith(START)) {
                if (start != -1) {
                    spans.add(new Span(start, end, BioCodec.extractSequenceType(c.get(li - 1))));
                }
                start = li;
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(CONTINUE)) {
                end = li + 1;
                continue;
            }
            if (!chunkTag.endsWith(OTHER) || start == -1) continue;
            spans.add(new Span(start, end, BioCodec.extractSequenceType(c.get(li - 1))));
            start = -1;
            end = -1;
        }
        if (start != -1) {
            spans.add(new Span(start, end, BioCodec.extractSequenceType(c.get(c.size() - 1))));
        }
        return spans.toArray(new Span[spans.size()]);
    }

    public String[] encode(Span[] sequences, int length) {
        String[] outcomes = new String[length];
        for (int i = 0; i < outcomes.length; ++i) {
            outcomes[i] = OTHER;
        }
        for (Span sequence : sequences) {
            outcomes[sequence.getStart()] = sequence.getType() == null ? "default-start" : sequence.getType() + "-" + START;
            for (int i = sequence.getStart() + 1; i < sequence.getEnd(); ++i) {
                outcomes[i] = sequence.getType() == null ? "default-cont" : sequence.getType() + "-" + CONTINUE;
            }
        }
        return outcomes;
    }

    public SequenceLabelerSequenceValidator createSequenceValidator() {
        return new SequenceLabelerSequenceValidator();
    }

    @Override
    public boolean areOutcomesCompatible(String[] outcomes) {
        ArrayList<String> start = new ArrayList<String>();
        ArrayList<String> cont = new ArrayList<String>();
        for (String outcome : outcomes) {
            if (outcome.endsWith(START)) {
                start.add(outcome.substring(0, outcome.length() - START.length()));
                continue;
            }
            if (outcome.endsWith(CONTINUE)) {
                cont.add(outcome.substring(0, outcome.length() - CONTINUE.length()));
                continue;
            }
            if (outcome.equals(OTHER)) continue;
            return false;
        }
        if (start.size() == 0) {
            return false;
        }
        for (String contPreffix : cont) {
            if (start.contains(contPreffix)) continue;
            return false;
        }
        return true;
    }
}

