/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEvaluationMonitor;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEvaluator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerFactory;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerME;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import eus.ixa.ixa.pipe.ml.utils.Flags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;

public class SequenceLabelerCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private final SequenceLabelerEvaluationMonitor[] listeners;
    private final FMeasure fmeasure = new FMeasure();
    private SequenceLabelerFactory factory;

    public SequenceLabelerCrossValidator(String languageCode, TrainingParameters trainParams, byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceLabelerCodec<String> codec, SequenceLabelerEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = trainParams;
        this.listeners = listeners;
    }

    public SequenceLabelerCrossValidator(String languageCode, TrainingParameters trainParams, byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceLabelerEvaluationMonitor ... listeners) {
        this(languageCode, trainParams, featureGeneratorBytes, resources, new BioCodec(), listeners);
    }

    public SequenceLabelerCrossValidator(String languageCode, TrainingParameters trainParams, SequenceLabelerFactory factory, SequenceLabelerEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = trainParams;
        this.factory = factory;
        this.listeners = listeners;
    }

    public void evaluate(ObjectStream<SequenceLabelSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<DocumentSample> partitioner = new CrossValidationPartitioner<DocumentSample>(new NameToDocumentSampleStream(samples), nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<DocumentSample> trainingSampleStream = partitioner.next();
            SequenceLabelerModel model = null;
            if (this.factory != null) {
                model = SequenceLabelerME.train(this.languageCode, new DocumentToNameSampleStream(trainingSampleStream), this.params, this.factory);
            } else {
                System.err.println("You need to implement a SequenceLabelerFactory!");
                System.exit(1);
            }
            String corpusFormat = Flags.getCorpusFormat(this.params);
            SequenceLabelerEvaluator evaluator = new SequenceLabelerEvaluator(corpusFormat, new SequenceLabelerME(model), this.listeners);
            evaluator.evaluate(new DocumentToNameSampleStream(trainingSampleStream.getTestSampleStream()));
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }

    private class DocumentToNameSampleStream
    extends FilterObjectStream<DocumentSample, SequenceLabelSample> {
        private Iterator<SequenceLabelSample> documentSamples;

        protected DocumentToNameSampleStream(ObjectStream<DocumentSample> samples) {
            super(samples);
            this.documentSamples = Collections.emptyList().iterator();
        }

        @Override
        public SequenceLabelSample read() throws IOException {
            if (this.documentSamples.hasNext()) {
                return this.documentSamples.next();
            }
            DocumentSample docSample = (DocumentSample)this.samples.read();
            if (docSample != null) {
                this.documentSamples = Arrays.asList(docSample.getSamples()).iterator();
                return this.read();
            }
            return null;
        }
    }

    private class NameToDocumentSampleStream
    extends FilterObjectStream<SequenceLabelSample, DocumentSample> {
        private SequenceLabelSample beginSample;

        protected NameToDocumentSampleStream(ObjectStream<SequenceLabelSample> samples) {
            super(samples);
        }

        @Override
        public DocumentSample read() throws IOException {
            SequenceLabelSample sample;
            ArrayList<SequenceLabelSample> document = new ArrayList<SequenceLabelSample>();
            if (this.beginSample == null) {
                this.beginSample = (SequenceLabelSample)this.samples.read();
            }
            if (this.beginSample == null) {
                return null;
            }
            document.add(this.beginSample);
            while ((sample = (SequenceLabelSample)this.samples.read()) != null) {
                if (sample.isClearAdaptiveDataSet()) {
                    this.beginSample = sample;
                    break;
                }
                document.add(sample);
            }
            if (sample == null) {
                this.beginSample = null;
            }
            return new DocumentSample(document.toArray(new SequenceLabelSample[document.size()]));
        }

        @Override
        public void reset() throws IOException, UnsupportedOperationException {
            super.reset();
            this.beginSample = null;
        }
    }

    private class DocumentSample {
        private final SequenceLabelSample[] samples;

        DocumentSample(SequenceLabelSample[] samples) {
            this.samples = samples;
        }

        private SequenceLabelSample[] getSamples() {
            return this.samples;
        }
    }
}

