/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.eval;

import eus.ixa.ixa.pipe.ml.SequenceLabelerTrainer;
import eus.ixa.ixa.pipe.ml.features.XMLFeatureDescriptor;
import eus.ixa.ixa.pipe.ml.resources.LoadModelResources;
import eus.ixa.ixa.pipe.ml.sequence.BilouCodec;
import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSampleTypeFilter;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCrossValidator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerDetailedFMeasureListener;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEvaluationErrorListener;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEvaluationMonitor;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerFactory;
import eus.ixa.ixa.pipe.ml.utils.Flags;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.EvaluationMonitor;

public class CrossValidator {
    private final String lang;
    private final String trainData;
    private ObjectStream<SequenceLabelSample> trainSamples;
    private final int beamSize;
    private final int folds;
    private final SequenceLabelerCodec<String> sequenceCodec;
    private final String corpusFormat;
    private SequenceLabelerFactory nameClassifierFactory;
    private final List<EvaluationMonitor<SequenceLabelSample>> listeners = new LinkedList<EvaluationMonitor<SequenceLabelSample>>();
    SequenceLabelerDetailedFMeasureListener detailedFListener;

    public CrossValidator(TrainingParameters params) throws IOException {
        this.lang = Flags.getLanguage(params);
        String clearFeatures = Flags.getClearTrainingFeatures(params);
        this.corpusFormat = Flags.getCorpusFormat(params);
        this.trainData = (String)params.getSettings().get("TrainSet");
        this.trainSamples = SequenceLabelerTrainer.getSequenceStream(this.trainData, clearFeatures, this.corpusFormat);
        this.beamSize = Flags.getBeamsize(params);
        this.folds = Flags.getFolds(params);
        this.sequenceCodec = SequenceLabelerFactory.instantiateSequenceCodec(this.getSequenceCodec(Flags.getSequenceCodec(params)));
        if (params.getSettings().get("Types") != null) {
            String netypes = (String)params.getSettings().get("Types");
            String[] neTypes = netypes.split(",");
            this.trainSamples = new SequenceLabelSampleTypeFilter(neTypes, this.trainSamples);
        }
        this.createNameFactory(params);
        this.getEvalListeners(params);
    }

    private void createNameFactory(TrainingParameters params) throws IOException {
        String featureDescription = XMLFeatureDescriptor.createXMLFeatureDescriptor(params);
        System.err.println(featureDescription);
        byte[] featureGeneratorBytes = featureDescription.getBytes(Charset.forName("UTF-8"));
        Map<String, Object> resources = LoadModelResources.loadSequenceResources(params);
        this.nameClassifierFactory = SequenceLabelerFactory.create(SequenceLabelerFactory.class.getName(), featureGeneratorBytes, resources, this.sequenceCodec);
    }

    private void getEvalListeners(TrainingParameters params) {
        if (((String)params.getSettings().get("EvaluationType")).equalsIgnoreCase("error")) {
            this.listeners.add(new SequenceLabelerEvaluationErrorListener());
        }
        if (((String)params.getSettings().get("EvaluationType")).equalsIgnoreCase("detailed")) {
            this.detailedFListener = new SequenceLabelerDetailedFMeasureListener();
            this.listeners.add(this.detailedFListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void crossValidate(TrainingParameters params) {
        if (this.nameClassifierFactory == null) {
            throw new IllegalStateException("Classes derived from AbstractNameFinderTrainer must create and fill the AdaptiveFeatureGenerator features!");
        }
        SequenceLabelerCrossValidator validator = null;
        try {
            validator = new SequenceLabelerCrossValidator(this.lang, params, this.nameClassifierFactory, this.listeners.toArray(new SequenceLabelerEvaluationMonitor[this.listeners.size()]));
            validator.evaluate(this.trainSamples, this.folds);
        }
        catch (IOException e) {
            System.err.println("IO error while loading training set!");
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                this.trainSamples.close();
            }
            catch (IOException e) {
                System.err.println("IO error with the train samples!");
            }
        }
        if (this.detailedFListener == null) {
            System.out.println(validator.getFMeasure());
        } else {
            System.out.println(this.detailedFListener.toString());
        }
    }

    public final String getSequenceCodec(String seqCodecOption) {
        String seqCodec = null;
        if ("BIO".equals(seqCodecOption)) {
            seqCodec = BioCodec.class.getName();
        } else if ("BILOU".equals(seqCodecOption)) {
            seqCodec = BilouCodec.class.getName();
        }
        return seqCodec;
    }

    public final int getBeamSize() {
        return this.beamSize;
    }
}

