/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.eval;

import eus.ixa.ixa.pipe.ml.SequenceLabelerTrainer;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSampleTypeFilter;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabeler;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerDetailedFMeasureListener;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEvaluationErrorListener;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEvaluationMonitor;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEvaluator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerME;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import opennlp.tools.util.ObjectStream;

public class SequenceLabelerEvaluate {
    private ObjectStream<SequenceLabelSample> testSamples;
    private ObjectStream<SequenceLabelSample> trainSamples;
    private final String corpusFormat;
    private boolean unknownAccuracy = false;
    private final SequenceLabeler sequenceLabeler;
    private static ConcurrentHashMap<String, SequenceLabelerModel> seqModels = new ConcurrentHashMap();

    public SequenceLabelerEvaluate(Properties props) throws IOException {
        String lang = props.getProperty("language");
        String clearFeatures = props.getProperty("clearFeatures");
        String model = props.getProperty("model");
        String testSet = props.getProperty("testset");
        this.corpusFormat = props.getProperty("corpusFormat");
        String seqTypes = props.getProperty("types");
        String trainSet = props.getProperty("unknownAccuracy");
        this.testSamples = SequenceLabelerTrainer.getSequenceStream(testSet, clearFeatures, this.corpusFormat);
        if (!trainSet.equalsIgnoreCase("no")) {
            this.unknownAccuracy = true;
            this.trainSamples = SequenceLabelerTrainer.getSequenceStream(trainSet, clearFeatures, this.corpusFormat);
        }
        if (seqTypes != "off") {
            String[] neTypes = seqTypes.split(",");
            this.testSamples = new SequenceLabelSampleTypeFilter(neTypes, this.testSamples);
        }
        seqModels.putIfAbsent(lang, new SequenceLabelerModel(new FileInputStream(model)));
        this.sequenceLabeler = new SequenceLabelerME(seqModels.get(lang));
    }

    public final void evaluate() throws IOException {
        SequenceLabelerEvaluator evaluator = new SequenceLabelerEvaluator(this.corpusFormat, this.sequenceLabeler, new SequenceLabelerEvaluationMonitor[0]);
        evaluator.evaluate(this.testSamples);
        System.out.println(evaluator.getFMeasure());
    }

    public final void evaluateAccuracy() throws IOException {
        if (this.unknownAccuracy) {
            SequenceLabelerEvaluator evaluator = new SequenceLabelerEvaluator(this.trainSamples, this.corpusFormat, this.sequenceLabeler, new SequenceLabelerEvaluationMonitor[0]);
            evaluator.evaluate(this.testSamples);
            System.out.println();
            System.out.println("Word Accuracy: " + evaluator.getWordAccuracy());
            System.out.println("Sentence Accuracy: " + evaluator.getSentenceAccuracy());
            System.out.println("Unknown Word Accuracy: " + evaluator.getUnknownWordAccuracy());
            System.out.println("Known Word Accuracy: " + evaluator.getKnownAccuracy());
        } else {
            SequenceLabelerEvaluator evaluator = new SequenceLabelerEvaluator(this.corpusFormat, this.sequenceLabeler, new SequenceLabelerEvaluationMonitor[0]);
            evaluator.evaluate(this.testSamples);
            System.out.println();
            System.out.println("Word Accuracy: " + evaluator.getWordAccuracy());
            System.out.println("Sentence accuracy: " + evaluator.getSentenceAccuracy());
        }
    }

    public final void detailEvaluate() throws IOException {
        LinkedList<SequenceLabelerDetailedFMeasureListener> listeners = new LinkedList<SequenceLabelerDetailedFMeasureListener>();
        SequenceLabelerDetailedFMeasureListener detailedFListener = new SequenceLabelerDetailedFMeasureListener();
        listeners.add(detailedFListener);
        SequenceLabelerEvaluator evaluator = new SequenceLabelerEvaluator(this.corpusFormat, this.sequenceLabeler, listeners.toArray(new SequenceLabelerEvaluationMonitor[listeners.size()]));
        evaluator.evaluate(this.testSamples);
        System.out.println(detailedFListener.toString());
    }

    public final void evalError() throws IOException {
        LinkedList<SequenceLabelerEvaluationErrorListener> listeners = new LinkedList<SequenceLabelerEvaluationErrorListener>();
        listeners.add(new SequenceLabelerEvaluationErrorListener());
        SequenceLabelerEvaluator evaluator = new SequenceLabelerEvaluator(this.corpusFormat, this.sequenceLabeler, listeners.toArray(new SequenceLabelerEvaluationMonitor[listeners.size()]));
        evaluator.evaluate(this.testSamples);
        System.out.println(evaluator.getFMeasure());
    }
}

