/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.lemma.DictionaryLemmatizer;
import eus.ixa.ixa.pipe.ml.resources.SequenceModelResource;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class LemmaDictionaryFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private SequenceModelResource posModelResource;
    private DictionaryLemmatizer lemmaDictResource;
    private String[] currentSentence;
    private Span[] currentTags;
    private List<String> currentLemmas;

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentTags = this.posModelResource.seqToSpans(tokens);
            this.currentLemmas = this.lemmaDictResource.lemmatize(tokens, this.currentTags);
        }
        String lemma = this.currentLemmas.get(index);
        features.add("lemmaDict=" + lemma);
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof SequenceModelResource)) {
            throw new InvalidFormatException("Not a POSModelResource for key: " + properties.get("model"));
        }
        this.posModelResource = (SequenceModelResource)posResource;
        Object lemmaResource = resourceProvider.getResource(properties.get("dict"));
        if (!(lemmaResource instanceof DictionaryLemmatizer)) {
            throw new InvalidFormatException("Not a DictionaryLemmatizer for key: " + properties.get("dict"));
        }
        this.lemmaDictResource = (DictionaryLemmatizer)lemmaResource;
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
        mapping.put("lemmadictserializer", new DictionaryLemmatizer.DictionaryLemmatizerSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

