/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.resources.SequenceModelResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class LemmaModelFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private SequenceModelResource seqModelResource;
    private String[] currentSentence;
    private String[] currentLemmas;

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentLemmas = this.seqModelResource.lemmatize(tokens);
        }
        String lemma = this.currentLemmas[index];
        features.add("lemmaModel=" + lemma);
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof SequenceModelResource)) {
            throw new InvalidFormatException("Not a SequenceModelResource for key: " + properties.get("model"));
        }
        this.seqModelResource = (SequenceModelResource)posResource;
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, SequenceModelResource.SequenceModelResourceSerializer> mapping = new HashMap<String, SequenceModelResource.SequenceModelResourceSerializer>();
        mapping.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

