/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.features;

import eus.ixa.ixa.pipe.ml.features.WordShapeSuperSenseFeatureGenerator;
import eus.ixa.ixa.pipe.ml.lemma.DictionaryLemmatizer;
import eus.ixa.ixa.pipe.ml.resources.MFSResource;
import eus.ixa.ixa.pipe.ml.resources.SequenceModelResource;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class SuperSenseFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private SequenceModelResource posModelResource;
    private DictionaryLemmatizer lemmaDictResource;
    private MFSResource mfsDictResource;
    private String[] currentSentence;
    private Span[] currentTags;
    private List<String> currentLemmas;
    private List<String> currentMFSList;
    private final String startSymbol;
    private final String endSymbol;
    private Boolean isBio = true;

    public SuperSenseFeatureGenerator() {
        this.startSymbol = null;
        this.endSymbol = null;
    }

    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        String firstCharCurTok;
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentTags = this.posModelResource.seqToSpans(tokens);
            this.currentLemmas = this.lemmaDictResource.lemmatize(tokens, this.currentTags);
            this.currentMFSList = this.isBio != false ? this.mfsDictResource.getFirstSenseBio(this.currentLemmas, this.currentTags) : this.mfsDictResource.getFirstSenseBilou(this.currentLemmas, this.currentTags);
        }
        String curLemma = this.currentLemmas.get(index);
        String curTok = tokens[index];
        String curPOS = this.currentTags[index].getType();
        String curShape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index]);
        String firstSense = this.currentMFSList.get(index);
        String prevLabel = this.startSymbol;
        String prevShape = this.startSymbol;
        String prevPOS = this.startSymbol;
        String prevLemma = this.startSymbol;
        String nextShape = this.startSymbol;
        String nextPOS = this.endSymbol;
        String nextLemma = this.endSymbol;
        String prev2Shape = this.startSymbol;
        String prev2POS = this.startSymbol;
        String prev2Lemma = this.startSymbol;
        String next2Shape = this.startSymbol;
        String next2POS = this.endSymbol;
        String next2Lemma = this.endSymbol;
        if (index - 2 >= 0) {
            prev2Shape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index - 2]);
            prev2Lemma = this.currentLemmas.get(index - 2);
            prev2POS = this.currentTags[index - 2].getType();
        }
        if (index - 1 >= 0) {
            prevShape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index - 1]);
            prevLemma = this.currentLemmas.get(index - 1);
            prevPOS = this.currentTags[index - 1].getType();
            prevLabel = previousOutcomes[index - 1];
        }
        if (index + 1 < tokens.length) {
            nextShape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index + 1]);
            nextLemma = this.currentLemmas.get(index + 1);
            nextPOS = this.currentTags[index + 1].getType();
        }
        if (index + 2 < tokens.length) {
            next2Shape = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index + 2]);
            next2Lemma = this.currentLemmas.get(index + 2);
            next2POS = this.currentTags[index + 2].getType();
        }
        features.add("bias");
        if (firstSense == null) {
            firstSense = "O";
        }
        features.add("firstSense=" + firstSense);
        features.add("firstSense,curTok=" + firstSense + "," + curLemma);
        if (prevLabel != this.startSymbol) {
            features.add("prevLabel=" + prevLabel);
        }
        if (curPOS.equals("NN") || curPOS.equals("NNS")) {
            features.add("curPOS_common");
        }
        if (curPOS.equals("NNP") || curPOS.equals("NNPS")) {
            features.add("curPOS_proper");
        }
        features.add("curTok=" + curLemma);
        features.add("curPOS=" + curPOS);
        features.add("curPOS_0" + curPOS.charAt(0));
        if (prevPOS != this.startSymbol) {
            features.add("prevTok=" + prevLemma);
            features.add("prevPOS=" + prevPOS);
            features.add("prevPOS_0=" + prevPOS.charAt(0));
        }
        if (nextPOS != this.endSymbol) {
            features.add("nextTok=" + nextLemma);
            features.add("nextPOS=" + nextPOS);
            features.add("nextPOS_0" + nextPOS.charAt(0));
        }
        if (prev2POS != this.startSymbol) {
            features.add("prev2Tok=" + prev2Lemma);
            features.add("prev2POS=" + prev2POS);
            features.add("prev2POS_0=" + prev2POS.charAt(0));
        }
        if (next2POS != this.startSymbol) {
            features.add("next2Tok=" + next2Lemma);
            features.add("next2POS=" + next2POS);
            features.add("next2POS_0=" + next2POS.charAt(0));
        }
        features.add("curShape=" + curShape);
        if (prevPOS != this.startSymbol) {
            features.add("prevShape=" + prevShape);
        }
        if (nextPOS != this.endSymbol) {
            features.add("nextShape=" + nextShape);
        }
        if (prev2POS != this.startSymbol) {
            features.add("prev2Shape=" + prev2Shape);
        }
        if (next2POS != this.endSymbol) {
            features.add("next2Shape=" + next2Shape);
        }
        if ((firstCharCurTok = curTok.substring(0, 1)).toLowerCase().equals(firstCharCurTok)) {
            features.add("curTokLowercase");
        } else if (index == 0) {
            features.add("curTokUpperCaseFirstChar");
        } else {
            features.add("curTokUpperCaseOther");
        }
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    public void clearAdaptiveData() {
    }

    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object posResource = resourceProvider.getResource(properties.get("model"));
        if (!(posResource instanceof SequenceModelResource)) {
            throw new InvalidFormatException("Not a POSModelResource for key: " + properties.get("model"));
        }
        this.posModelResource = (SequenceModelResource)posResource;
        Object lemmaResource = resourceProvider.getResource(properties.get("dict"));
        if (!(lemmaResource instanceof DictionaryLemmatizer)) {
            throw new InvalidFormatException("Not a LemmaResource for key: " + properties.get("dict"));
        }
        this.lemmaDictResource = (DictionaryLemmatizer)lemmaResource;
        Object mfsResource = resourceProvider.getResource(properties.get("mfs"));
        if (!(mfsResource instanceof MFSResource)) {
            throw new InvalidFormatException("Not a MFSResource for key: " + properties.get("mfs"));
        }
        this.mfsDictResource = (MFSResource)mfsResource;
        this.isBio = properties.get("seqCodec").equalsIgnoreCase("bilou") ? Boolean.valueOf(false) : Boolean.valueOf(true);
    }

    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("posmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
        mapping.put("lemmadictserializer", new DictionaryLemmatizer.DictionaryLemmatizerSerializer());
        mapping.put("mfsdictserializer", new MFSResource.MFSResourceSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

