/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.formats;

import eus.ixa.ixa.pipe.ml.parse.Parse;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class ParseToTabulatedFormat
extends FilterObjectStream<Parse, SequenceLabelSample> {
    public ParseToTabulatedFormat(ObjectStream<Parse> in) {
        super(in);
    }

    public SequenceLabelSample read() throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> seqTypes = new ArrayList<String>();
        boolean isClearAdaptiveData = false;
        Parse parse = (Parse)this.samples.read();
        if (parse != null) {
            Parse[] nodes;
            for (Parse tok : nodes = parse.getTagNodes()) {
                tokens.add(tok.getCoveredText());
                seqTypes.add(tok.getType());
            }
        }
        if (tokens.size() > 0) {
            ArrayList<Span> sequences = new ArrayList<Span>();
            int beginIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < seqTypes.size(); ++i) {
                if (beginIndex != -1) {
                    sequences.add(new Span(beginIndex, endIndex, (String)seqTypes.get(beginIndex)));
                    beginIndex = -1;
                    endIndex = -1;
                }
                beginIndex = i;
                endIndex = i + 1;
            }
            if (beginIndex != -1) {
                sequences.add(new Span(beginIndex, endIndex, (String)seqTypes.get(beginIndex)));
            }
            SequenceLabelSample sequenceSample = new SequenceLabelSample(tokens.toArray(new String[tokens.size()]), sequences.toArray(new Span[sequences.size()]), false);
            return sequenceSample;
        }
        return null;
    }
}

