/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.formats;

import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.StringUtil;

public class TabulatedFormat
implements ObjectStream<SequenceLabelSample> {
    private final ObjectStream<String> lineStream;
    private final String clearFeatures;

    public TabulatedFormat(String clearFeatures, ObjectStream<String> lineStream) {
        this.clearFeatures = clearFeatures;
        this.lineStream = lineStream;
    }

    public TabulatedFormat(String clearFeatures, InputStreamFactory in) throws IOException {
        this.clearFeatures = clearFeatures;
        try {
            this.lineStream = new PlainTextByLineStream(in, "UTF-8");
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public SequenceLabelSample read() throws IOException {
        String line;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> seqTypes = new ArrayList<String>();
        boolean isClearAdaptiveData = false;
        while ((line = (String)this.lineStream.read()) != null && !StringUtil.isEmpty((CharSequence)line)) {
            if (this.clearFeatures.equalsIgnoreCase("docstart") && line.startsWith("-DOCSTART-")) {
                isClearAdaptiveData = true;
                String emptyLine = (String)this.lineStream.read();
                if (StringUtil.isEmpty((CharSequence)emptyLine)) continue;
                throw new IOException("Empty line after -DOCSTART- not empty: '" + emptyLine + "'!");
            }
            String[] fields = line.split("\t");
            if (fields.length != 2) {
                System.err.println("Skipping corrupt line: " + line);
                continue;
            }
            tokens.add(fields[0]);
            seqTypes.add(fields[1]);
        }
        if (this.clearFeatures.equalsIgnoreCase("yes")) {
            isClearAdaptiveData = true;
        }
        if (tokens.size() > 0) {
            ArrayList<Span> sequences = new ArrayList<Span>();
            int beginIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < seqTypes.size(); ++i) {
                if (beginIndex != -1) {
                    sequences.add(new Span(beginIndex, endIndex, (String)seqTypes.get(beginIndex)));
                    beginIndex = -1;
                    endIndex = -1;
                }
                beginIndex = i;
                endIndex = i + 1;
            }
            if (beginIndex != -1) {
                sequences.add(new Span(beginIndex, endIndex, (String)seqTypes.get(beginIndex)));
            }
            return new SequenceLabelSample(tokens.toArray(new String[tokens.size()]), sequences.toArray(new Span[sequences.size()]), isClearAdaptiveData);
        }
        if (line != null) {
            return this.read();
        }
        return null;
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    public void close() throws IOException {
        this.lineStream.close();
    }
}

