/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.nerc;

import eus.ixa.ixa.pipe.ml.resources.Dictionaries;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabel;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelFactory;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerME;
import eus.ixa.ixa.pipe.ml.utils.Span;
import eus.ixa.ixa.pipe.ml.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DictionariesNERTagger {
    private SequenceLabelFactory nameFactory;
    private final Dictionaries dictionaries;
    private final boolean debug = false;

    public DictionariesNERTagger(Dictionaries aDictionaries) {
        this.dictionaries = aDictionaries;
    }

    public DictionariesNERTagger(Dictionaries aDictionaries, SequenceLabelFactory aNameFactory) {
        this.dictionaries = aDictionaries;
        this.nameFactory = aNameFactory;
    }

    public final List<SequenceLabel> getNames(String[] tokens) {
        Span[] origSpans = this.nercToSpans(tokens);
        Span[] neSpans = SequenceLabelerME.dropOverlappingSpans(origSpans);
        List<SequenceLabel> names = this.getNamesFromSpans(neSpans, tokens);
        return names;
    }

    public final Span[] nercToSpans(String[] tokens) {
        ArrayList<Span> neSpans = new ArrayList<Span>();
        for (Map<String, String> neDict : this.dictionaries.getIgnoreCaseDictionaries()) {
            for (Map.Entry<String, String> neEntry : neDict.entrySet()) {
                String neForm = neEntry.getKey();
                String neType = neEntry.getValue();
                List<Integer> neIds = StringUtils.exactTokenFinderIgnoreCase(neForm, tokens);
                if (neIds.isEmpty()) continue;
                for (int i = 0; i < neIds.size(); i += 2) {
                    Span neSpan = new Span((int)neIds.get(i), (int)neIds.get(i + 1), neType);
                    neSpans.add(neSpan);
                    this.getClass();
                }
            }
        }
        return neSpans.toArray(new Span[neSpans.size()]);
    }

    public final Span[] nercToSpansExact(String[] tokens) {
        ArrayList<Span> neSpans = new ArrayList<Span>();
        for (Map<String, String> neDict : this.dictionaries.getDictionaries()) {
            for (Map.Entry<String, String> neEntry : neDict.entrySet()) {
                String neForm = neEntry.getKey();
                String neType = neEntry.getValue();
                List<Integer> neIds = StringUtils.exactTokenFinder(neForm, tokens);
                if (neIds.isEmpty()) continue;
                for (int i = 0; i < neIds.size(); i += 2) {
                    Span neSpan = new Span((int)neIds.get(i), (int)neIds.get(i + 1), neType);
                    neSpans.add(neSpan);
                    this.getClass();
                }
            }
        }
        return neSpans.toArray(new Span[neSpans.size()]);
    }

    public final List<SequenceLabel> getNamesFromSpans(Span[] neSpans, String[] tokens) {
        ArrayList<SequenceLabel> names = new ArrayList<SequenceLabel>();
        for (Span neSpan : neSpans) {
            String nameString = neSpan.getCoveredText(tokens);
            String neType = neSpan.getType();
            SequenceLabel name = this.nameFactory.createSequence(nameString, neType, neSpan);
            names.add(name);
        }
        return names;
    }

    public void clearAdaptiveData() {
    }
}

