/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.nerc;

import eus.ixa.ixa.pipe.ml.lexer.NumericNameLexer;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabel;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelFactory;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerME;
import eus.ixa.ixa.pipe.ml.utils.Span;
import eus.ixa.ixa.pipe.ml.utils.StringUtils;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;

public class NumericNERTagger {
    private final NumericNameLexer numericLexer;
    private final SequenceLabelFactory nameFactory;

    public NumericNERTagger(BufferedReader breader, SequenceLabelFactory aNameFactory) {
        this.nameFactory = aNameFactory;
        this.numericLexer = new NumericNameLexer(breader, aNameFactory);
    }

    public List<SequenceLabel> getNames(String[] tokens) {
        Span[] origSpans = this.nercToSpans(tokens);
        Span[] neSpans = SequenceLabelerME.dropOverlappingSpans(origSpans);
        List<SequenceLabel> names = this.getNamesFromSpans(neSpans, tokens);
        return names;
    }

    public Span[] nercToSpans(String[] tokens) {
        ArrayList<Span> neSpans = new ArrayList<Span>();
        List<SequenceLabel> flexNameList = this.numericLexer.getNumericNames();
        for (SequenceLabel name : flexNameList) {
            List<Integer> neIds = StringUtils.exactTokenFinderIgnoreCase(name.getString(), tokens);
            for (int i = 0; i < neIds.size(); i += 2) {
                Span neSpan = new Span((int)neIds.get(i), (int)neIds.get(i + 1), name.getType());
                neSpans.add(neSpan);
            }
        }
        return neSpans.toArray(new Span[neSpans.size()]);
    }

    public List<SequenceLabel> getNamesFromSpans(Span[] neSpans, String[] tokens) {
        ArrayList<SequenceLabel> names = new ArrayList<SequenceLabel>();
        for (Span neSpan : neSpans) {
            String nameString = neSpan.getCoveredText(tokens);
            String neType = neSpan.getType();
            SequenceLabel name = this.nameFactory.createSequence(nameString, neType, neSpan);
            names.add(name);
        }
        return names;
    }

    public void clearAdaptiveData() {
    }
}

