/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.parse;

import eus.ixa.ixa.pipe.ml.parse.Constituent;
import eus.ixa.ixa.pipe.ml.parse.GapLabeler;
import eus.ixa.ixa.pipe.ml.parse.HeadRule;
import eus.ixa.ixa.pipe.ml.parse.HeadRules;
import eus.ixa.ixa.pipe.ml.parse.Parse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class PennTreebankHeadRules
implements HeadRules,
GapLabeler,
SerializableArtifact {
    private Map<String, HeadRule> headRules;
    private final Set<String> punctSet;

    public PennTreebankHeadRules(Reader rulesReader) throws IOException {
        BufferedReader in = new BufferedReader(rulesReader);
        this.readHeadRules(in);
        this.punctSet = new HashSet<String>();
        this.punctSet.add(".");
        this.punctSet.add(",");
        this.punctSet.add("``");
        this.punctSet.add("''");
    }

    private void readHeadRules(BufferedReader str) throws IOException {
        String line;
        this.headRules = new HashMap<String, HeadRule>(30);
        while ((line = str.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            String num = st.nextToken();
            String type = st.nextToken();
            String dir = st.nextToken();
            String[] tags = new String[Integer.parseInt(num) - 2];
            int ti = 0;
            while (st.hasMoreTokens()) {
                tags[ti] = st.nextToken();
                ++ti;
            }
            this.headRules.put(type, new HeadRule(dir.equals("1"), tags));
        }
    }

    @Override
    public Set<String> getPunctuationTags() {
        return this.punctSet;
    }

    @Override
    public Parse getHead(Parse[] constituents, String type) {
        if (constituents[0].getType() == "TK") {
            return null;
        }
        if (type.equals("NP") || type.equals("NX")) {
            int ci;
            String[] tags1 = new String[]{"NN", "NNP", "NNPS", "NNS", "NX", "JJR", "POS"};
            for (int ci2 = constituents.length - 1; ci2 >= 0; --ci2) {
                for (int ti = tags1.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci2].getType().equals(tags1[ti])) continue;
                    return constituents[ci2];
                }
            }
            for (Parse constituent : constituents) {
                if (!constituent.getType().equals("NP")) continue;
                return constituent;
            }
            String[] tags2 = new String[]{"$", "ADJP", "PRN"};
            for (ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags2.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().equals(tags2[ti])) continue;
                    return constituents[ci];
                }
            }
            for (ci = constituents.length - 1; ci >= 0; --ci) {
                if (!constituents[ci].getType().equals("CD")) continue;
                return constituents[ci];
            }
            String[] tags3 = new String[]{"JJ", "JJS", "RB", "QP"};
            for (int ci3 = constituents.length - 1; ci3 >= 0; --ci3) {
                for (int ti = tags3.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci3].getType().equals(tags3[ti])) continue;
                    return constituents[ci3];
                }
            }
            return constituents[constituents.length - 1];
        }
        HeadRule hr = this.headRules.get(type);
        if (hr != null) {
            String[] tags = hr.getTags();
            int cl = constituents.length;
            int tl = tags.length;
            if (hr.isLeftToRight()) {
                for (int ti = 0; ti < tl; ++ti) {
                    for (int ci = 0; ci < cl; ++ci) {
                        if (!constituents[ci].getType().equals(tags[ti])) continue;
                        return constituents[ci];
                    }
                }
                return constituents[0];
            }
            for (int ti = 0; ti < tl; ++ti) {
                for (int ci = cl - 1; ci >= 0; --ci) {
                    if (!constituents[ci].getType().equals(tags[ti])) continue;
                    return constituents[ci];
                }
            }
            return constituents[cl - 1];
        }
        return constituents[constituents.length - 1];
    }

    @Override
    public void labelGaps(Stack<Constituent> stack) {
        if (stack.size() > 4) {
            Constituent con1 = (Constituent)stack.get(stack.size() - 2);
            Constituent con2 = (Constituent)stack.get(stack.size() - 3);
            Constituent con3 = (Constituent)stack.get(stack.size() - 4);
            Constituent con4 = (Constituent)stack.get(stack.size() - 5);
            if (con1.getLabel().equals("NP") && con2.getLabel().equals("S") && con3.getLabel().equals("SBAR")) {
                con1.setLabel(con1.getLabel() + "-G");
                con2.setLabel(con2.getLabel() + "-G");
                con3.setLabel(con3.getLabel() + "-G");
            } else if (con1.getLabel().equals("NP") && con2.getLabel().equals("VP") && con3.getLabel().equals("S") && con4.getLabel().equals("SBAR")) {
                con1.setLabel(con1.getLabel() + "-G");
                con2.setLabel(con2.getLabel() + "-G");
                con3.setLabel(con3.getLabel() + "-G");
                con4.setLabel(con4.getLabel() + "-G");
            }
        }
    }

    public void serialize(Writer writer) throws IOException {
        for (String type : this.headRules.keySet()) {
            HeadRule headRule = this.headRules.get(type);
            writer.write(Integer.toString(headRule.getTags().length + 2));
            writer.write(32);
            writer.write(type);
            writer.write(32);
            if (headRule.isLeftToRight()) {
                writer.write("1");
            } else {
                writer.write("0");
            }
            for (String tag : headRule.getTags()) {
                writer.write(32);
                writer.write(tag);
            }
            writer.write(10);
        }
        writer.flush();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PennTreebankHeadRules) {
            PennTreebankHeadRules rules = (PennTreebankHeadRules)obj;
            return rules.headRules.equals(this.headRules) && rules.punctSet.equals(this.punctSet);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public Class<?> getArtifactSerializerClass() {
        return PennTreebankHeadRulesSerializer.class;
    }

    public static class PennTreebankHeadRulesSerializer
    implements ArtifactSerializer<PennTreebankHeadRules> {
        public PennTreebankHeadRules create(InputStream in) throws IOException, InvalidFormatException {
            return new PennTreebankHeadRules(new BufferedReader(new InputStreamReader(in, "UTF-8")));
        }

        public void serialize(PennTreebankHeadRules artifact, OutputStream out) throws IOException {
            artifact.serialize(new OutputStreamWriter(out, "UTF-8"));
        }
    }
}

