/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.parse;

import eus.ixa.ixa.pipe.ml.formats.ParseToCoNLL02Format;
import eus.ixa.ixa.pipe.ml.formats.ParseToTabulatedFormat;
import eus.ixa.ixa.pipe.ml.parse.BuildContextGenerator;
import eus.ixa.ixa.pipe.ml.parse.CheckContextGenerator;
import eus.ixa.ixa.pipe.ml.parse.HeadRules;
import eus.ixa.ixa.pipe.ml.parse.Parse;
import eus.ixa.ixa.pipe.ml.parse.ParserEventStream;
import eus.ixa.ixa.pipe.ml.parse.ParserFactory;
import eus.ixa.ixa.pipe.ml.parse.ParserModel;
import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerFactory;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerME;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.util.Heap;
import opennlp.tools.util.ListHeap;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.StringList;
import opennlp.tools.util.TrainingParameters;

public class ShiftReduceParser {
    private static Pattern untokenizedParenPattern1 = Pattern.compile("([^ ])([({)}])");
    private static Pattern untokenizedParenPattern2 = Pattern.compile("([({)}])([^ ])");
    private final int M;
    private final int K;
    private final double Q;
    public static final int DEFAULT_BEAMSIZE = 20;
    public static final double defaultAdvancePercentage = 0.95;
    private final Heap<Parse> completeParses;
    private Heap<Parse> odh;
    private Heap<Parse> ndh;
    private final HeadRules headRules;
    private final Set<String> punctSet;
    public static final String TOP_NODE = "TOP";
    public static final String INC_NODE = "INC";
    public static final String TOK_NODE = "TK";
    public static final Integer ZERO = 0;
    public static final String COMPLETE = "c";
    public static final String INCOMPLETE = "i";
    private boolean reportFailedParse;
    private final boolean createDerivationString = false;
    private final SequenceLabelerME tagger;
    private final SequenceLabelerME chunker;
    private final MaxentModel buildModel;
    private final MaxentModel checkModel;
    private final BuildContextGenerator buildContextGenerator;
    private final CheckContextGenerator checkContextGenerator;
    private final double[] bprobs;
    private final double[] cprobs;
    private static final String TOP_START = "TOP-start";
    private final int topStartIndex;
    private final Map<String, String> startTypeMap;
    private final Map<String, String> contTypeMap;
    private final int completeIndex;
    private final int incompleteIndex;
    protected boolean debugOn = false;

    public ShiftReduceParser(ParserModel model) {
        this(model, model.getBeamSize(), 0.95);
    }

    public ShiftReduceParser(ParserModel model, int beamSize, double advancePercentage) {
        this(model.getBuildModel(), model.getCheckModel(), new SequenceLabelerME(model.getParserTaggerModel()), new SequenceLabelerME(model.getParserChunkerModel()), model.getHeadRules(), beamSize, advancePercentage);
    }

    public ShiftReduceParser(MaxentModel buildModel, MaxentModel checkModel, SequenceLabelerME tagger, SequenceLabelerME chunker, HeadRules headRules, int beamSize, double advancePercentage) {
        this.tagger = tagger;
        this.chunker = chunker;
        this.buildModel = buildModel;
        this.checkModel = checkModel;
        this.M = beamSize;
        this.K = beamSize;
        this.Q = advancePercentage;
        this.headRules = headRules;
        this.punctSet = headRules.getPunctuationTags();
        this.odh = new ListHeap(this.K);
        this.ndh = new ListHeap(this.K);
        this.completeParses = new ListHeap(this.K);
        this.bprobs = new double[buildModel.getNumOutcomes()];
        this.cprobs = new double[checkModel.getNumOutcomes()];
        this.buildContextGenerator = new BuildContextGenerator();
        this.checkContextGenerator = new CheckContextGenerator();
        this.startTypeMap = new HashMap<String, String>();
        this.contTypeMap = new HashMap<String, String>();
        int bon = buildModel.getNumOutcomes();
        for (int boi = 0; boi < bon; ++boi) {
            String outcome = buildModel.getOutcome(boi);
            if (outcome.endsWith("start")) {
                this.startTypeMap.put(outcome, BioCodec.extractSequenceType(outcome));
                continue;
            }
            if (!outcome.endsWith("cont")) continue;
            this.contTypeMap.put(outcome, BioCodec.extractSequenceType(outcome));
        }
        this.topStartIndex = buildModel.getIndex(TOP_START);
        this.completeIndex = checkModel.getIndex(COMPLETE);
        this.incompleteIndex = checkModel.getIndex(INCOMPLETE);
    }

    private void advanceTop(Parse p) {
        this.buildModel.eval(this.buildContextGenerator.getContext(p.getChildren(), 0), this.bprobs);
        p.addProb(Math.log(this.bprobs[this.topStartIndex]));
        this.checkModel.eval(this.checkContextGenerator.getContext(p.getChildren(), TOP_NODE, 0, 0), this.cprobs);
        p.addProb(Math.log(this.cprobs[this.completeIndex]));
        p.setType(TOP_NODE);
    }

    private Parse[] advanceParses(Parse p, double probMass) {
        int advanceNodeIndex;
        double q = 1.0 - probMass;
        Parse lastStartNode = null;
        int lastStartIndex = -1;
        String lastStartType = null;
        Parse advanceNode = null;
        Parse[] originalChildren = p.getChildren();
        Parse[] children = ShiftReduceParser.collapsePunctuation(originalChildren, this.punctSet);
        int numNodes = children.length;
        if (numNodes == 0) {
            return null;
        }
        for (advanceNodeIndex = 0; advanceNodeIndex < numNodes && (advanceNode = children[advanceNodeIndex]).getLabel() != null; ++advanceNodeIndex) {
            if (!this.startTypeMap.containsKey(advanceNode.getLabel())) continue;
            lastStartType = this.startTypeMap.get(advanceNode.getLabel());
            lastStartNode = advanceNode;
            lastStartIndex = advanceNodeIndex;
        }
        int originalAdvanceIndex = this.mapParseIndex(advanceNodeIndex, children, originalChildren);
        ArrayList<Parse> newParsesList = new ArrayList<Parse>(this.buildModel.getNumOutcomes());
        this.buildModel.eval(this.buildContextGenerator.getContext(children, advanceNodeIndex), this.bprobs);
        double bprobSum = 0.0;
        while (bprobSum < probMass) {
            int max = 0;
            for (int pi = 1; pi < this.bprobs.length; ++pi) {
                if (!(this.bprobs[pi] > this.bprobs[max])) continue;
                max = pi;
            }
            if (this.bprobs[max] == 0.0) break;
            double bprob = this.bprobs[max];
            this.bprobs[max] = 0.0;
            bprobSum += bprob;
            String tag = this.buildModel.getOutcome(max);
            if (max == this.topStartIndex) continue;
            if (this.startTypeMap.containsKey(tag)) {
                lastStartIndex = advanceNodeIndex;
                lastStartNode = advanceNode;
                lastStartType = this.startTypeMap.get(tag);
            } else if (this.contTypeMap.containsKey(tag) && (lastStartNode == null || !lastStartType.equals(this.contTypeMap.get(tag)))) continue;
            Parse newParse1 = (Parse)p.clone();
            this.getClass();
            newParse1.setChild(originalAdvanceIndex, tag);
            newParse1.addProb(Math.log(bprob));
            this.checkModel.eval(this.checkContextGenerator.getContext(ShiftReduceParser.collapsePunctuation(newParse1.getChildren(), this.punctSet), lastStartType, lastStartIndex, advanceNodeIndex), this.cprobs);
            Parse newParse2 = newParse1;
            if (this.cprobs[this.completeIndex] > q) {
                newParse2 = (Parse)newParse1.clone();
                this.getClass();
                newParse2.addProb(Math.log(this.cprobs[this.completeIndex]));
                Parse[] cons = new Parse[advanceNodeIndex - lastStartIndex + 1];
                boolean flat = true;
                cons[0] = lastStartNode;
                flat &= cons[0].isPosTag();
                cons[advanceNodeIndex - lastStartIndex] = advanceNode;
                flat &= cons[advanceNodeIndex - lastStartIndex].isPosTag();
                for (int ci = 1; ci < advanceNodeIndex - lastStartIndex; ++ci) {
                    cons[ci] = children[ci + lastStartIndex];
                    flat &= cons[ci].isPosTag();
                }
                if (!flat) {
                    if (lastStartIndex == 0 && advanceNodeIndex == numNodes - 1) {
                        newParse2.insert(new Parse(p.getText(), p.getSpan(), lastStartType, this.cprobs[1], this.headRules.getHead(cons, lastStartType)));
                    } else {
                        newParse2.insert(new Parse(p.getText(), new Span(lastStartNode.getSpan().getStart(), advanceNode.getSpan().getEnd()), lastStartType, this.cprobs[1], this.headRules.getHead(cons, lastStartType)));
                    }
                    newParsesList.add(newParse2);
                }
            }
            if (!(this.cprobs[this.incompleteIndex] > q)) continue;
            this.getClass();
            if (advanceNodeIndex == numNodes - 1) continue;
            newParse1.addProb(Math.log(this.cprobs[this.incompleteIndex]));
            newParsesList.add(newParse1);
        }
        Parse[] newParses = new Parse[newParsesList.size()];
        newParsesList.toArray(newParses);
        return newParses;
    }

    public static Parse[] parseLine(String line, ShiftReduceParser parser, int numParses) {
        line = untokenizedParenPattern1.matcher(line).replaceAll("$1 $2");
        line = untokenizedParenPattern2.matcher(line).replaceAll("$1 $2");
        StringTokenizer str = new StringTokenizer(line);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        while (str.hasMoreTokens()) {
            String tok = str.nextToken();
            tokens.add(tok);
            sb.append(tok).append(" ");
        }
        String text = sb.substring(0, sb.length() - 1);
        Parse p = new Parse(text, new Span(0, text.length()), INC_NODE, 0.0, 0);
        int start = 0;
        int i = 0;
        for (String tok : tokens) {
            p.insert(new Parse(text, new Span(start, start + tok.length()), TOK_NODE, 0.0, i));
            start += tok.length() + 1;
            ++i;
        }
        Parse[] parses = numParses == 1 ? new Parse[]{parser.parse(p)} : parser.parse(p, numParses);
        return parses;
    }

    public Parse[] parse(Parse tokens, int numParses) {
        this.getClass();
        this.odh.clear();
        this.ndh.clear();
        this.completeParses.clear();
        int maxDerivationLength = 2 * tokens.getChildCount() + 3;
        this.odh.add((Object)tokens);
        Parse guess = null;
        double minComplete = 2.0;
        double bestComplete = -100000.0;
        for (int derivationStage = 0; this.odh.size() > 0 && (this.completeParses.size() < this.M || ((Parse)this.odh.first()).getProb() < minComplete) && derivationStage < maxDerivationLength; ++derivationStage) {
            this.ndh = new ListHeap(this.K);
            Iterator pi = this.odh.iterator();
            for (int derivationRank = 0; pi.hasNext() && derivationRank < this.K; ++derivationRank) {
                Parse tp = (Parse)pi.next();
                if (guess == null && derivationStage == 2) {
                    guess = tp;
                }
                if (this.debugOn) {
                    System.out.print(derivationStage + " " + derivationRank + " " + tp.getProb());
                    tp.show();
                    System.out.println();
                }
                Parse[] nd = 0 == derivationStage ? this.advanceTags(tp) : (1 == derivationStage ? (this.ndh.size() < this.K ? this.advanceChunks(tp, bestComplete) : this.advanceChunks(tp, ((Parse)this.ndh.last()).getProb())) : this.advanceParses(tp, this.Q));
                if (nd != null) {
                    for (Parse element : nd) {
                        if (element.complete()) {
                            this.advanceTop(element);
                            if (element.getProb() > bestComplete) {
                                bestComplete = element.getProb();
                            }
                            if (element.getProb() < minComplete) {
                                minComplete = element.getProb();
                            }
                            this.completeParses.add((Object)element);
                            continue;
                        }
                        this.ndh.add((Object)element);
                    }
                    continue;
                }
                if (this.reportFailedParse) {
                    System.err.println("Couldn't advance parse " + derivationStage + " stage " + derivationRank + "!\n");
                }
                this.advanceTop(tp);
                this.completeParses.add((Object)tp);
            }
            this.odh = this.ndh;
        }
        if (this.completeParses.size() == 0) {
            if (this.reportFailedParse) {
                System.err.println("Couldn't find parse for: " + tokens);
            }
            return new Parse[]{guess};
        }
        if (numParses == 1) {
            return new Parse[]{(Parse)this.completeParses.first()};
        }
        ArrayList<Parse> topParses = new ArrayList<Parse>(numParses);
        while (!this.completeParses.isEmpty() && topParses.size() < numParses) {
            Parse tp = (Parse)this.completeParses.extract();
            topParses.add(tp);
        }
        return topParses.toArray(new Parse[topParses.size()]);
    }

    public Parse parse(Parse tokens) {
        if (tokens.getChildCount() > 0) {
            Parse p = this.parse(tokens, 1)[0];
            ShiftReduceParser.setParents(p);
            return p;
        }
        return tokens;
    }

    public static void setParents(Parse p) {
        Parse[] children;
        for (Parse element : children = p.getChildren()) {
            element.setParent(p);
            ShiftReduceParser.setParents(element);
        }
    }

    protected Parse[] advanceTags(Parse p) {
        Parse[] children = p.getChildren();
        String[] words = new String[children.length];
        double[] probs = new double[words.length];
        int il = children.length;
        for (int i = 0; i < il; ++i) {
            words[i] = children[i].getCoveredText();
        }
        Sequence[] ts = this.tagger.topKSequences(words);
        if (ts.length == 0) {
            System.err.println("no tag sequence");
        }
        Parse[] newParses = new Parse[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            String[] tags = ts[i].getOutcomes().toArray(new String[words.length]);
            ts[i].getProbs(probs);
            newParses[i] = (Parse)p.clone();
            for (int j = this.createDerivationString; j < words.length; ++j) {
                Parse word = children[j];
                double prob = probs[j];
                newParses[i].insert(new Parse(word.getText(), word.getSpan(), tags[j].replaceAll("-start", ""), prob, j));
                newParses[i].addProb(Math.log(prob));
            }
        }
        return newParses;
    }

    protected Parse[] advanceChunks(Parse p, double minChunkScore) {
        Parse[] children = p.getChildren();
        String[] words = new String[children.length];
        String[] ptags = new String[words.length];
        double[] probs = new double[words.length];
        Parse sp2 = null;
        for (Parse sp2 : children) {
            words[i] = sp2.getHead().getCoveredText();
            ptags[i] = sp2.getType();
        }
        Sequence[] cs = this.chunker.topKSequences(words, ptags, minChunkScore - p.getProb());
        Parse[] newParses = new Parse[cs.length];
        int sl = cs.length;
        for (int si = 0; si < sl; ++si) {
            newParses[si] = (Parse)p.clone();
            this.getClass();
            String[] tags = cs[si].getOutcomes().toArray(new String[words.length]);
            cs[si].getProbs(probs);
            int start = -1;
            int end = 0;
            String type = null;
            for (int j = 0; j <= tags.length; ++j) {
                if (j != tags.length) {
                    newParses[si].addProb(Math.log(probs[j]));
                }
                if (j != tags.length && tags[j].endsWith("cont")) {
                    end = j;
                    continue;
                }
                if (type != null) {
                    Parse p1 = p.getChildren()[start];
                    Parse p2 = p.getChildren()[end];
                    Parse[] cons = new Parse[end - start + 1];
                    cons[0] = p1;
                    if (end - start != 0) {
                        cons[end - start] = p2;
                        for (int ci = 1; ci < end - start; ++ci) {
                            cons[ci] = p.getChildren()[ci + start];
                        }
                    }
                    Parse chunk = new Parse(p1.getText(), new Span(p1.getSpan().getStart(), p2.getSpan().getEnd()), type, 1.0, this.headRules.getHead(cons, type));
                    chunk.isChunk(true);
                    newParses[si].insert(chunk);
                }
                if (j == tags.length) continue;
                if (tags[j].endsWith("start")) {
                    type = tags[j].replaceAll("-start", "");
                    start = j;
                    end = j;
                    continue;
                }
                type = null;
            }
        }
        return newParses;
    }

    public static ParserModel train(String languageCode, ObjectStream<Parse> parseSamples, HeadRules rules, TrainingParameters trainParams, ParserFactory parserFactory, TrainingParameters taggerParams, SequenceLabelerFactory taggerFactory, TrainingParameters chunkerParams, SequenceLabelerFactory chunkerFactory) throws IOException {
        String beamSizeString = (String)trainParams.getSettings().get("BeamSize");
        int beamSize = 20;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        parseSamples.reset();
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        System.err.println("Training POS tagger...");
        SequenceLabelerModel posModel = SequenceLabelerME.train(languageCode, (ObjectStream<SequenceLabelSample>)new ParseToTabulatedFormat(parseSamples), taggerParams, taggerFactory);
        parseSamples.reset();
        System.err.println("Training chunker...");
        SequenceLabelerModel chunkModel = SequenceLabelerME.train(languageCode, (ObjectStream<SequenceLabelSample>)new ParseToCoNLL02Format(parseSamples), chunkerParams, chunkerFactory);
        parseSamples.reset();
        System.err.println("Training builder...");
        ParserEventStream bes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.BUILD, parserFactory);
        HashMap<String, String> buildReportMap = new HashMap<String, String>();
        EventTrainer trainer = TrainerFactory.getEventTrainer((Map)trainParams.getSettings("build"), buildReportMap);
        MaxentModel buildModel = trainer.train((ObjectStream)bes);
        ShiftReduceParser.mergeReportIntoManifest(manifestInfoEntries, buildReportMap, "build");
        parseSamples.reset();
        System.err.println("Training checker...");
        ParserEventStream kes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.CHECK);
        HashMap<String, String> checkReportMap = new HashMap<String, String>();
        EventTrainer checkTrainer = TrainerFactory.getEventTrainer((Map)trainParams.getSettings("check"), checkReportMap);
        MaxentModel checkModel = checkTrainer.train((ObjectStream)kes);
        ShiftReduceParser.mergeReportIntoManifest(manifestInfoEntries, checkReportMap, "check");
        return new ParserModel(languageCode, buildModel, checkModel, posModel, chunkModel, beamSize, rules, manifestInfoEntries);
    }

    public static ParserModel train(String languageCode, ObjectStream<Parse> parseSamples, HeadRules rules, TrainingParameters trainParams, ParserFactory parserFactory, SequenceLabelerModel posModel, TrainingParameters chunkerParams, SequenceLabelerFactory chunkerFactory) throws IOException {
        String beamSizeString = (String)trainParams.getSettings().get("BeamSize");
        int beamSize = 20;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        parseSamples.reset();
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        System.err.println("Training chunker...");
        SequenceLabelerModel chunkModel = SequenceLabelerME.train(languageCode, (ObjectStream<SequenceLabelSample>)new ParseToCoNLL02Format(parseSamples), chunkerParams, chunkerFactory);
        parseSamples.reset();
        System.err.println("Training builder...");
        ParserEventStream bes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.BUILD, parserFactory);
        HashMap<String, String> buildReportMap = new HashMap<String, String>();
        EventTrainer trainer = TrainerFactory.getEventTrainer((Map)trainParams.getSettings("build"), buildReportMap);
        MaxentModel buildModel = trainer.train((ObjectStream)bes);
        ShiftReduceParser.mergeReportIntoManifest(manifestInfoEntries, buildReportMap, "build");
        parseSamples.reset();
        System.err.println("Training checker...");
        ParserEventStream kes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.CHECK);
        HashMap<String, String> checkReportMap = new HashMap<String, String>();
        EventTrainer checkTrainer = TrainerFactory.getEventTrainer((Map)trainParams.getSettings("check"), checkReportMap);
        MaxentModel checkModel = checkTrainer.train((ObjectStream)kes);
        ShiftReduceParser.mergeReportIntoManifest(manifestInfoEntries, checkReportMap, "check");
        return new ParserModel(languageCode, buildModel, checkModel, posModel, chunkModel, beamSize, rules, manifestInfoEntries);
    }

    public static void mergeReportIntoManifest(Map<String, String> manifest, Map<String, String> report, String namespace) {
        for (Map.Entry<String, String> entry : report.entrySet()) {
            manifest.put(namespace + "." + entry.getKey(), entry.getValue());
        }
    }

    public static Parse[] collapsePunctuation(Parse[] chunks, Set<String> punctSet) {
        ArrayList<Parse> collapsedParses = new ArrayList<Parse>(chunks.length);
        int lastNonPunct = -1;
        int nextNonPunct = -1;
        int cn = chunks.length;
        for (int ci = 0; ci < cn; ++ci) {
            if (punctSet.contains(chunks[ci].getType())) {
                if (lastNonPunct >= 0) {
                    chunks[lastNonPunct].addNextPunctuation(chunks[ci]);
                }
                for (nextNonPunct = ci + 1; nextNonPunct < cn && punctSet.contains(chunks[nextNonPunct].getType()); ++nextNonPunct) {
                }
                if (nextNonPunct >= cn) continue;
                chunks[nextNonPunct].addPreviousPunctuation(chunks[ci]);
                continue;
            }
            collapsedParses.add(chunks[ci]);
            lastNonPunct = ci;
        }
        if (collapsedParses.size() == chunks.length) {
            return chunks;
        }
        return collapsedParses.toArray(new Parse[collapsedParses.size()]);
    }

    private int mapParseIndex(int index, Parse[] nonPunctParses, Parse[] parses) {
        int parseIndex = index;
        while (parses[parseIndex] != nonPunctParses[index]) {
            ++parseIndex;
        }
        return parseIndex;
    }

    public static Dictionary buildDictionary(ObjectStream<Parse> data, HeadRules rules, int cutoff) throws IOException {
        TrainingParameters params = new TrainingParameters();
        params.put("dict", "Cutoff", Integer.toString(cutoff));
        return ShiftReduceParser.buildDictionary(data, rules, params);
    }

    public static Dictionary buildDictionary(ObjectStream<Parse> data, HeadRules rules, TrainingParameters params) throws IOException {
        Parse p;
        System.err.println("Building automatic ngram dictionary...");
        int cutoff = 5;
        String cutoffString = (String)params.getSettings("dict").get("Cutoff");
        if (cutoffString != null) {
            cutoff = Integer.parseInt(cutoffString);
        }
        NGramModel mdict = new NGramModel();
        while ((p = (Parse)data.read()) != null) {
            p.updateHeads(rules);
            Parse[] pwords = p.getTagNodes();
            String[] words = new String[pwords.length];
            for (int wi = 0; wi < words.length; ++wi) {
                words[wi] = pwords[wi].getCoveredText();
            }
            mdict.add(new StringList(words), 1, 1);
            Parse[] chunks = ShiftReduceParser.collapsePunctuation(ParserEventStream.getInitialChunks(p), rules.getPunctuationTags());
            String[] cwords = new String[chunks.length];
            for (int wi = 0; wi < cwords.length; ++wi) {
                cwords[wi] = chunks[wi].getHead().getCoveredText();
            }
            mdict.add(new StringList(cwords), 2, 3);
            for (int ci = 0; ci < chunks.length; ++ci) {
                int reduceStart;
                if (chunks[ci].getParent() == null) {
                    chunks[ci].show();
                }
                if (!ShiftReduceParser.lastChild(chunks[ci], chunks[ci].getParent(), rules.getPunctuationTags())) continue;
                for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == chunks[ci].getParent(); --reduceStart) {
                }
                chunks = ParserEventStream.reduceChunks(chunks, ci, chunks[ci].getParent());
                ci = ++reduceStart;
                if (chunks.length != 0) {
                    String[] window = new String[5];
                    int wi = 0;
                    if (ci - 2 >= 0) {
                        window[wi++] = chunks[ci - 2].getHead().getCoveredText();
                    }
                    if (ci - 1 >= 0) {
                        window[wi++] = chunks[ci - 1].getHead().getCoveredText();
                    }
                    window[wi++] = chunks[ci].getHead().getCoveredText();
                    if (ci + 1 < chunks.length) {
                        window[wi++] = chunks[ci + 1].getHead().getCoveredText();
                    }
                    if (ci + 2 < chunks.length) {
                        window[wi++] = chunks[ci + 2].getHead().getCoveredText();
                    }
                    if (wi < 5) {
                        String[] subWindow = new String[wi];
                        for (int swi = 0; swi < wi; ++swi) {
                            subWindow[swi] = window[swi];
                        }
                        window = subWindow;
                    }
                    if (window.length >= 3) {
                        mdict.add(new StringList(window), 2, 3);
                    } else if (window.length == 2) {
                        mdict.add(new StringList(window), 2, 2);
                    }
                }
                ci = reduceStart - 1;
            }
        }
        mdict.cutoff(cutoff, Integer.MAX_VALUE);
        System.err.println("Automatic dictionary created!");
        return mdict.toDictionary(true);
    }

    private static boolean lastChild(Parse child, Parse parent, Set<String> punctSet) {
        if (parent == null) {
            return false;
        }
        Parse[] kids = ShiftReduceParser.collapsePunctuation(parent.getChildren(), punctSet);
        return kids[kids.length - 1] == child;
    }
}

