/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.resources;

import eus.ixa.ixa.pipe.ml.lemma.DictionaryLemmatizer;
import eus.ixa.ixa.pipe.ml.resources.Dictionary;
import eus.ixa.ixa.pipe.ml.resources.MFSResource;
import eus.ixa.ixa.pipe.ml.resources.POSDictionary;
import eus.ixa.ixa.pipe.ml.resources.PredicateContext;
import eus.ixa.ixa.pipe.ml.resources.SequenceModelResource;
import eus.ixa.ixa.pipe.ml.resources.WordCluster;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import eus.ixa.ixa.pipe.ml.utils.Flags;
import eus.ixa.ixa.pipe.ml.utils.IOUtils;
import eus.ixa.ixa.pipe.ml.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ArtifactSerializer;

public class LoadModelResources {
    private LoadModelResources() {
    }

    public static Map<String, Object> loadSequenceResources(TrainingParameters params) throws IOException {
        String mfsSerializerId;
        String lemmaSerializerId;
        String[] mfsResources;
        String mfsResourcesPath;
        String posSerializerId;
        String posSerializerId2;
        List<File> ClusterLexiconFiles;
        String serializerId;
        String ClusterLexiconPath;
        HashMap<String, Object> resources = new HashMap<String, Object>();
        Map<String, ArtifactSerializer> artifactSerializers = SequenceLabelerModel.createArtifactSerializers();
        if (Flags.isBrownFeatures(params)) {
            ClusterLexiconPath = Flags.getBrownFeatures(params);
            serializerId = "brownserializer";
            ClusterLexiconFiles = Flags.getClusterLexiconFiles(ClusterLexiconPath);
            for (File ClusterLexiconFile : ClusterLexiconFiles) {
                String brownFilePath = ClusterLexiconFile.getCanonicalPath();
                artifactSerializers.put("brownserializer", new WordCluster.WordClusterSerializer());
                LoadModelResources.loadResource("brownserializer", artifactSerializers, brownFilePath, resources);
            }
        }
        if (Flags.isClarkFeatures(params)) {
            String clarkClusterPath = Flags.getClarkFeatures(params);
            serializerId = "clarkserializer";
            List<File> clarkClusterFiles = Flags.getClusterLexiconFiles(clarkClusterPath);
            for (File clarkClusterFile : clarkClusterFiles) {
                String clarkFilePath = clarkClusterFile.getCanonicalPath();
                artifactSerializers.put("clarkserializer", new WordCluster.WordClusterSerializer());
                LoadModelResources.loadResource("clarkserializer", artifactSerializers, clarkFilePath, resources);
            }
        }
        if (Flags.isWord2VecClusterFeatures(params)) {
            ClusterLexiconPath = Flags.getWord2VecClusterFeatures(params);
            serializerId = "word2vecserializer";
            ClusterLexiconFiles = Flags.getClusterLexiconFiles(ClusterLexiconPath);
            for (File ClusterLexiconFile : ClusterLexiconFiles) {
                String word2vecFilePath = ClusterLexiconFile.getCanonicalPath();
                artifactSerializers.put("word2vecserializer", new WordCluster.WordClusterSerializer());
                LoadModelResources.loadResource("word2vecserializer", artifactSerializers, word2vecFilePath, resources);
            }
        }
        if (Flags.isDictionaryFeatures(params)) {
            String dictDir = Flags.getDictionaryFeatures(params);
            serializerId = "dictionaryserializer";
            List<File> fileList = StringUtils.getFilesInDir(new File(dictDir));
            for (File dictFile : fileList) {
                String dictionaryPath = dictFile.getCanonicalPath();
                artifactSerializers.put("dictionaryserializer", new Dictionary.DictionarySerializer());
                LoadModelResources.loadResource("dictionaryserializer", artifactSerializers, dictionaryPath, resources);
            }
        }
        if (Flags.isPOSTagModelFeatures(params)) {
            String morphoResourcesPath = Flags.getPOSTagModelFeatures(params);
            posSerializerId2 = "seqmodelserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, morphoResourcesPath, resources);
        }
        if (Flags.isPOSDictionaryFeatures(params)) {
            String posDictPath = Flags.getPOSDictionaryFeatures(params);
            posSerializerId2 = "posdictserializer";
            artifactSerializers.put("posdictserializer", new POSDictionary.POSDictionarySerializer());
            LoadModelResources.loadResource("posdictserializer", artifactSerializers, posDictPath, resources);
        }
        if (Flags.isLemmaModelFeatures(params)) {
            String lemmaModelPath = Flags.getLemmaModelFeatures(params);
            String lemmaSerializerId2 = "seqmodelserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, lemmaModelPath, resources);
        }
        if (Flags.isLemmaDictionaryFeatures(params)) {
            String lemmaDictPath = Flags.getLemmaDictionaryFeatures(params);
            String[] lemmaDictResources = Flags.getLemmaDictionaryResources(lemmaDictPath);
            posSerializerId = "seqmodelserializer";
            String lemmaDictSerializerId = "lemmadictserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, lemmaDictResources[0], resources);
            artifactSerializers.put("lemmadictserializer", new DictionaryLemmatizer.DictionaryLemmatizerSerializer());
            LoadModelResources.loadResource("lemmadictserializer", artifactSerializers, lemmaDictResources[1], resources);
        }
        if (Flags.isSuperSenseFeatures(params)) {
            mfsResourcesPath = Flags.getSuperSenseFeatures(params);
            mfsResources = Flags.getSuperSenseResources(mfsResourcesPath);
            posSerializerId = "seqmodelserializer";
            lemmaSerializerId = "lemmadictserializer";
            mfsSerializerId = "mfsserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, mfsResources[0], resources);
            artifactSerializers.put("lemmadictserializer", new DictionaryLemmatizer.DictionaryLemmatizerSerializer());
            LoadModelResources.loadResource("lemmadictserializer", artifactSerializers, mfsResources[1], resources);
            artifactSerializers.put("mfsserializer", new MFSResource.MFSResourceSerializer());
            LoadModelResources.loadResource("mfsserializer", artifactSerializers, mfsResources[2], resources);
        }
        if (Flags.isMFSFeatures(params)) {
            mfsResourcesPath = Flags.getMFSFeatures(params);
            mfsResources = Flags.getMFSResources(mfsResourcesPath);
            posSerializerId = "seqmodelserializer";
            lemmaSerializerId = "lemmadictserializer";
            mfsSerializerId = "mfsserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, mfsResources[0], resources);
            artifactSerializers.put("lemmadictserializer", new DictionaryLemmatizer.DictionaryLemmatizerSerializer());
            LoadModelResources.loadResource("lemmadictserializer", artifactSerializers, mfsResources[1], resources);
            artifactSerializers.put("mfsserializer", new MFSResource.MFSResourceSerializer());
            LoadModelResources.loadResource("mfsserializer", artifactSerializers, mfsResources[2], resources);
        }
        if (Flags.isLemmaBaselineFeatures(params)) {
            String lemmaBaselineFeatures = Flags.getLemmaBaselineFeatures(params);
            posSerializerId2 = "seqmodelserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, lemmaBaselineFeatures, resources);
        }
        if (Flags.isChunkBaselineFeatures(params)) {
            String chunkBaselineFeatures = Flags.getChunkBaselineFeatures(params);
            posSerializerId2 = "seqmodelserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, chunkBaselineFeatures, resources);
        }
        if (Flags.isPredicateContextFeatures(params)) {
            String predicateContextFeatures = Flags.getPredicateContextFeatures(params);
            posSerializerId2 = "predicatecontextserializer";
            artifactSerializers.put("predicatecontextserializer", new PredicateContext.PredicateContextSerializer());
            LoadModelResources.loadResource("predicatecontextserializer", artifactSerializers, predicateContextFeatures, resources);
        }
        return resources;
    }

    public static Map<String, Object> loadParseResources(TrainingParameters params) throws IOException {
        List<File> ClusterLexiconFiles;
        String serializerId;
        String ClusterLexiconPath;
        HashMap<String, Object> resources = new HashMap<String, Object>();
        Map<String, ArtifactSerializer> artifactSerializers = SequenceLabelerModel.createArtifactSerializers();
        if (Flags.isBrownFeatures(params)) {
            ClusterLexiconPath = Flags.getBrownFeatures(params);
            serializerId = "brownserializer";
            ClusterLexiconFiles = Flags.getClusterLexiconFiles(ClusterLexiconPath);
            for (File ClusterLexiconFile : ClusterLexiconFiles) {
                String brownFilePath = ClusterLexiconFile.getCanonicalPath();
                artifactSerializers.put("brownserializer", new WordCluster.WordClusterSerializer());
                LoadModelResources.loadResource("brownserializer", artifactSerializers, brownFilePath, resources);
            }
        }
        if (Flags.isClarkFeatures(params)) {
            String clarkClusterPath = Flags.getClarkFeatures(params);
            serializerId = "clarkserializer";
            List<File> clarkClusterFiles = Flags.getClusterLexiconFiles(clarkClusterPath);
            for (File clarkClusterFile : clarkClusterFiles) {
                String clarkFilePath = clarkClusterFile.getCanonicalPath();
                artifactSerializers.put("clarkserializer", new WordCluster.WordClusterSerializer());
                LoadModelResources.loadResource("clarkserializer", artifactSerializers, clarkFilePath, resources);
            }
        }
        if (Flags.isWord2VecClusterFeatures(params)) {
            ClusterLexiconPath = Flags.getWord2VecClusterFeatures(params);
            serializerId = "word2vecserializer";
            ClusterLexiconFiles = Flags.getClusterLexiconFiles(ClusterLexiconPath);
            for (File ClusterLexiconFile : ClusterLexiconFiles) {
                String word2vecFilePath = ClusterLexiconFile.getCanonicalPath();
                artifactSerializers.put("word2vecserializer", new WordCluster.WordClusterSerializer());
                LoadModelResources.loadResource("word2vecserializer", artifactSerializers, word2vecFilePath, resources);
            }
        }
        if (Flags.isPOSTagModelFeatures(params)) {
            String morphoResourcesPath = Flags.getPOSTagModelFeatures(params);
            String posSerializerId = "seqmodelserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, morphoResourcesPath, resources);
        }
        if (Flags.isLemmaModelFeatures(params)) {
            String lemmaModelPath = Flags.getLemmaModelFeatures(params);
            String lemmaSerializerId = "seqmodelserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, lemmaModelPath, resources);
        }
        if (Flags.isLemmaDictionaryFeatures(params)) {
            String lemmaDictPath = Flags.getLemmaDictionaryFeatures(params);
            String[] lemmaDictResources = Flags.getLemmaDictionaryResources(lemmaDictPath);
            String posSerializerId = "seqmodelserializer";
            String lemmaDictSerializerId = "lemmadictserializer";
            artifactSerializers.put("seqmodelserializer", new SequenceModelResource.SequenceModelResourceSerializer());
            LoadModelResources.loadResource("seqmodelserializer", artifactSerializers, lemmaDictResources[0], resources);
            artifactSerializers.put("lemmadictserializer", new DictionaryLemmatizer.DictionaryLemmatizerSerializer());
            LoadModelResources.loadResource("lemmadictserializer", artifactSerializers, lemmaDictResources[1], resources);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadResource(String serializerId, Map<String, ArtifactSerializer> artifactSerializers, String resourcePath, Map<String, Object> resources) {
        File resourceFile = new File(resourcePath);
        if (resourceFile != null) {
            String resourceId = IOUtils.normalizeLexiconName(resourceFile.getName());
            ArtifactSerializer serializer = artifactSerializers.get(serializerId);
            InputStream resourceIn = IOUtils.openFromFile(resourceFile);
            try {
                resources.put(resourceId, serializer.create(resourceIn));
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    resourceIn.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

