/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.resources;

import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.featuregen.StringPattern;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class POSDictionary
implements SerializableArtifact {
    private static final Pattern tabDelimiter = Pattern.compile("\t");
    private static final Pattern valueDelimiter = Pattern.compile("=\\p{Digit}+,");
    private static final Pattern splitValues = Pattern.compile(",\\s");
    private final Map<String, Map<String, AtomicInteger>> newEntries = new HashMap<String, Map<String, AtomicInteger>>();

    public POSDictionary(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            String[] lineArray = tabDelimiter.split(line);
            this.populatePOSMap(lineArray);
        }
    }

    private void populatePOSMap(String[] lineArray) {
        if (lineArray.length == 2) {
            if (lineArray[1].startsWith("{") && lineArray[1].endsWith("}")) {
                String valuesString = lineArray[1].substring(1, lineArray[1].length() - 1);
                if (valueDelimiter.matcher(valuesString) != null) {
                    String[] valuesArray = splitValues.split(valuesString);
                    HashMap<String, AtomicInteger> valuesMap = new HashMap<String, AtomicInteger>();
                    for (String value : valuesArray) {
                        String[] valueArray = value.split("=");
                        valuesMap.put(valueArray[0], new AtomicInteger(Integer.parseInt(valueArray[1])));
                    }
                    this.newEntries.put(lineArray[0], valuesMap);
                } else {
                    String[] valueStringArray = valuesString.split("=");
                    HashMap<String, AtomicInteger> valueMap = new HashMap<String, AtomicInteger>();
                    valueMap.put(valueStringArray[0], new AtomicInteger(Integer.parseInt(valueStringArray[1])));
                    this.newEntries.put(lineArray[0], valueMap);
                }
            }
            if (!StringPattern.recognize((String)lineArray[0]).containsDigit()) {
                String word = StringUtil.toLowerCase((CharSequence)lineArray[0]);
                if (!this.newEntries.containsKey(word)) {
                    this.newEntries.put(word, new HashMap());
                }
                if (!this.newEntries.get(word).containsKey(lineArray[1])) {
                    this.newEntries.get(word).put(lineArray[1], new AtomicInteger(1));
                } else {
                    this.newEntries.get(word).get(lineArray[1]).incrementAndGet();
                }
            }
        }
    }

    public String getMostFrequentTag(String word) {
        TreeMultimap<Integer, String> mfTagMap = this.getOrderedMap(word);
        String mfTag = null;
        if (!mfTagMap.isEmpty()) {
            NavigableSet mfTagSet = mfTagMap.get(mfTagMap.keySet().first());
            mfTag = (String)mfTagSet.first();
        } else {
            mfTag = "O";
        }
        return mfTag;
    }

    public String getAmbiguityClass(String word) {
        TreeMultimap<Integer, String> mfTagMap = this.getOrderedMap(word);
        String ambiguityClass = null;
        if (!mfTagMap.isEmpty()) {
            StringJoiner sb = new StringJoiner("-");
            for (Map.Entry entry : mfTagMap.entries()) {
                sb.add((CharSequence)entry.getValue());
            }
            ambiguityClass = sb.toString();
        } else {
            ambiguityClass = "O";
        }
        return ambiguityClass;
    }

    public TreeMultimap<Integer, String> getOrderedMap(String word) {
        Map<String, AtomicInteger> tagFreqsMap = this.newEntries.get(word);
        TreeMultimap mfTagMap = TreeMultimap.create((Comparator)Ordering.natural().reverse(), (Comparator)Ordering.natural());
        if (tagFreqsMap != null) {
            this.getOrderedTags(tagFreqsMap, (TreeMultimap<Integer, String>)mfTagMap);
        }
        return mfTagMap;
    }

    private void getOrderedTags(Map<String, AtomicInteger> tagFreqsMap, TreeMultimap<Integer, String> mfTagMap) {
        if (!tagFreqsMap.isEmpty() || tagFreqsMap != null) {
            for (Map.Entry<String, AtomicInteger> entry : tagFreqsMap.entrySet()) {
                mfTagMap.put((Object)entry.getValue().intValue(), (Object)entry.getKey());
            }
        }
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<String, Map<String, AtomicInteger>> entry : this.newEntries.entrySet()) {
            writer.write(entry.getKey() + "\t" + entry.getValue().toString() + "\n");
        }
        ((Writer)writer).flush();
    }

    public Class<?> getArtifactSerializerClass() {
        return POSDictionarySerializer.class;
    }

    public static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        public POSDictionary create(InputStream in) throws IOException, InvalidFormatException {
            return new POSDictionary(in);
        }

        public void serialize(POSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

