/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelSample;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabeler;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerEvaluationMonitor;
import eus.ixa.ixa.pipe.ml.utils.Span;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.EvaluationMonitor;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.eval.Mean;

public class SequenceLabelerEvaluator
extends Evaluator<SequenceLabelSample> {
    private final FMeasure fmeasure = new FMeasure();
    private final Mean wordAccuracy = new Mean();
    private final Mean sentenceAccuracy = new Mean();
    private final Mean unknownAccuracy = new Mean();
    private final Mean knownAccuracy = new Mean();
    private final Set<String> knownWords = new HashSet<String>();
    private final SequenceLabeler sequenceLabeler;
    private String corpusFormat = "conll02";

    public SequenceLabelerEvaluator(String aCorpusFormat, SequenceLabeler seqLabeler, SequenceLabelerEvaluationMonitor ... listeners) {
        super((EvaluationMonitor[])listeners);
        this.corpusFormat = aCorpusFormat;
        this.sequenceLabeler = seqLabeler;
    }

    public SequenceLabelerEvaluator(ObjectStream<SequenceLabelSample> trainSamples, String aCorpusFormat, SequenceLabeler seqLabeler, SequenceLabelerEvaluationMonitor ... listeners) {
        super((EvaluationMonitor[])listeners);
        this.corpusFormat = aCorpusFormat;
        this.sequenceLabeler = seqLabeler;
        if (trainSamples != null) {
            this.getKnownWords(trainSamples);
        }
    }

    protected SequenceLabelSample processSample(SequenceLabelSample reference) {
        if (reference.isClearAdaptiveDataSet()) {
            this.sequenceLabeler.clearAdaptiveData();
        }
        String[] referenceTokens = reference.getTokens();
        Object[] predictedNames = this.sequenceLabeler.tag(referenceTokens);
        Object[] references = reference.getSequences();
        for (int i = 0; i < references.length; ++i) {
            if (references[i].getType() != null) continue;
            references[i] = new Span(((Span)references[i]).getStart(), ((Span)references[i]).getEnd(), "default");
        }
        if (this.corpusFormat.equalsIgnoreCase("lemmatizer") || this.corpusFormat.equalsIgnoreCase("tabulated")) {
            this.updateAccuracyScores(referenceTokens, references, predictedNames);
        }
        this.fmeasure.updateScores(references, predictedNames);
        return new SequenceLabelSample(referenceTokens, (Span[])predictedNames, reference.isClearAdaptiveDataSet());
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }

    public double getWordAccuracy() {
        return this.wordAccuracy.mean();
    }

    public double getSentenceAccuracy() {
        return this.sentenceAccuracy.mean();
    }

    public double getUnknownWordAccuracy() {
        return this.unknownAccuracy.mean();
    }

    public double getKnownAccuracy() {
        return this.knownAccuracy.mean();
    }

    public long getWordCount() {
        return this.wordAccuracy.count();
    }

    public void updateAccuracyScores(String[] referenceTokens, Object[] references, Object[] predictions) {
        int fails = 0;
        for (int i = 0; i < references.length; ++i) {
            boolean isKnown = this.checkWordInSeenData(referenceTokens[i]);
            if (references[i].equals(predictions[i])) {
                this.wordAccuracy.add(1.0);
                if (isKnown) {
                    this.knownAccuracy.add(1.0);
                    continue;
                }
                this.unknownAccuracy.add(1.0);
                continue;
            }
            this.wordAccuracy.add(0.0);
            ++fails;
            if (isKnown) {
                this.knownAccuracy.add(0.0);
                continue;
            }
            this.unknownAccuracy.add(0.0);
        }
        if (fails > 0) {
            this.sentenceAccuracy.add(0.0);
        } else {
            this.sentenceAccuracy.add(1.0);
        }
    }

    private boolean checkWordInSeenData(String referenceToken) {
        boolean isKnown = false;
        if (!this.knownWords.isEmpty()) {
            isKnown = this.knownWords.contains(referenceToken);
        }
        return isKnown;
    }

    private void getKnownWords(ObjectStream<SequenceLabelSample> trainSamples) {
        try {
            SequenceLabelSample sample;
            while ((sample = (SequenceLabelSample)trainSamples.read()) != null) {
                for (String token : sample.getTokens()) {
                    this.knownWords.add(token);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

