/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.DefaultSequenceLabelerContextGenerator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerContextGenerator;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.GeneratorFactory;

public class SequenceLabelerFactory
extends BaseToolFactory {
    private byte[] featureGeneratorBytes;
    private Map<String, Object> resources;
    private SequenceLabelerCodec<String> seqCodec;

    public SequenceLabelerFactory() {
        this.seqCodec = new BioCodec();
    }

    public SequenceLabelerFactory(byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceLabelerCodec<String> seqCodec) {
        this.init(featureGeneratorBytes, resources, seqCodec);
    }

    void init(byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceLabelerCodec<String> seqCodec) {
        this.featureGeneratorBytes = featureGeneratorBytes;
        this.resources = resources;
        this.seqCodec = seqCodec;
    }

    private static byte[] loadDefaultFeatureGeneratorBytes() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (InputStream in = SequenceLabelerFactory.class.getResourceAsStream("/sequenceLabeler/default-feature-descriptor.xml");){
            int len;
            if (in == null) {
                throw new IllegalStateException("Classpath must contain default-feature-descriptor.xml file!");
            }
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                bytes.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed reading from default-feature-descriptor.xml file on classpath!");
        }
        return bytes.toByteArray();
    }

    protected SequenceLabelerCodec<String> getSequenceCodec() {
        return this.seqCodec;
    }

    protected Map<String, Object> getResources() {
        return this.resources;
    }

    protected byte[] getFeatureGenerator() {
        return this.featureGeneratorBytes;
    }

    public static SequenceLabelerFactory create(String subclassName, byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceLabelerCodec<String> seqCodec) throws InvalidFormatException {
        SequenceLabelerFactory theFactory;
        if (subclassName == null) {
            theFactory = new SequenceLabelerFactory();
        } else {
            try {
                theFactory = (SequenceLabelerFactory)((Object)ExtensionLoader.instantiateExtension(SequenceLabelerFactory.class, (String)subclassName));
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
                System.err.println(msg);
                e.printStackTrace();
                throw new InvalidFormatException(msg, (Throwable)e);
            }
        }
        theFactory.init(featureGeneratorBytes, resources, seqCodec);
        return theFactory;
    }

    public void validateArtifactMap() throws InvalidFormatException {
    }

    public SequenceLabelerCodec<String> createSequenceCodec() {
        if (this.artifactProvider != null) {
            String sequeceCodecImplName = this.artifactProvider.getManifestProperty("sequenceCodecImplName");
            return SequenceLabelerFactory.instantiateSequenceCodec(sequeceCodecImplName);
        }
        return this.seqCodec;
    }

    public SequenceLabelerContextGenerator createContextGenerator() {
        AdaptiveFeatureGenerator featureGenerator = this.createFeatureGenerators();
        if (featureGenerator == null) {
            throw new NullPointerException("featureGenerator must not be null");
        }
        return new DefaultSequenceLabelerContextGenerator(featureGenerator);
    }

    public AdaptiveFeatureGenerator createFeatureGenerators() {
        if (this.featureGeneratorBytes == null && this.artifactProvider != null) {
            this.featureGeneratorBytes = (byte[])this.artifactProvider.getArtifact("generator.featuregen");
        }
        if (this.featureGeneratorBytes == null) {
            System.err.println("WARNING: loading the default feature generator descriptor!!");
            this.featureGeneratorBytes = SequenceLabelerFactory.loadDefaultFeatureGeneratorBytes();
        }
        ByteArrayInputStream descriptorIn = new ByteArrayInputStream(this.featureGeneratorBytes);
        AdaptiveFeatureGenerator generator = null;
        try {
            generator = GeneratorFactory.create((InputStream)descriptorIn, (FeatureGeneratorResourceProvider)new FeatureGeneratorResourceProvider(){

                public Object getResource(String key) {
                    if (SequenceLabelerFactory.this.artifactProvider != null) {
                        return SequenceLabelerFactory.this.artifactProvider.getArtifact(key);
                    }
                    return SequenceLabelerFactory.this.resources.get(key);
                }
            });
        }
        catch (InvalidFormatException e) {
            throw new SequenceLabelerModel.FeatureGeneratorCreationError(e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading from mem cannot result in an I/O error", e);
        }
        return generator;
    }

    public static SequenceLabelerCodec<String> instantiateSequenceCodec(String sequenceCodecImplName) {
        if (sequenceCodecImplName != null) {
            return (SequenceLabelerCodec)ExtensionLoader.instantiateExtension(SequenceLabelerCodec.class, (String)sequenceCodecImplName);
        }
        return new BioCodec();
    }
}

