/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.sequence;

import eus.ixa.ixa.pipe.ml.sequence.BioCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerCodec;
import eus.ixa.ixa.pipe.ml.sequence.SequenceLabelerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public class SequenceLabelerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "SequenceLabelerME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "sequenceLabeler.model";
    static final String GENERATOR_DESCRIPTOR_ENTRY_NAME = "generator.featuregen";
    static final String SEQUENCE_CODEC_CLASS_NAME_PARAMETER = "sequenceCodecImplName";

    public SequenceLabelerModel(String languageCode, SequenceClassificationModel<String> nameFinderModel, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries, SequenceLabelerCodec<String> seqCodec, SequenceLabelerFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, (BaseToolFactory)factory);
        this.init(nameFinderModel, generatorDescriptor, resources, manifestInfoEntries, seqCodec);
        if (!seqCodec.areOutcomesCompatible(nameFinderModel.getOutcomes())) {
            throw new IllegalArgumentException("Model not compatible with name finder!");
        }
    }

    public SequenceLabelerModel(String languageCode, MaxentModel nameFinderModel, int beamSize, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries, SequenceLabelerCodec<String> seqCodec, SequenceLabelerFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, (BaseToolFactory)factory);
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.put("BeamSize", Integer.toString(beamSize));
        this.init(nameFinderModel, generatorDescriptor, resources, manifestInfoEntries, seqCodec);
        if (!this.isModelValid(nameFinderModel)) {
            throw new IllegalArgumentException("Model not compatible with name finder!");
        }
    }

    public SequenceLabelerModel(String languageCode, MaxentModel nameFinderModel, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries) {
        this(languageCode, nameFinderModel, 3, generatorDescriptor, resources, manifestInfoEntries, new BioCodec(), new SequenceLabelerFactory());
    }

    public SequenceLabelerModel(String languageCode, MaxentModel nameFinderModel, Map<String, Object> resources, Map<String, String> manifestInfoEntries) {
        this(languageCode, nameFinderModel, null, resources, manifestInfoEntries);
    }

    public SequenceLabelerModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public SequenceLabelerModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public SequenceLabelerModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    private void init(Object nameFinderModel, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries, SequenceLabelerCodec<String> seqCodec) {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.put(SEQUENCE_CODEC_CLASS_NAME_PARAMETER, seqCodec.getClass().getName());
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, nameFinderModel);
        if (generatorDescriptor != null && generatorDescriptor.length > 0) {
            this.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, generatorDescriptor);
        }
        if (resources != null) {
            if (resources.containsKey(MAXENT_MODEL_ENTRY_NAME) || resources.containsKey(GENERATOR_DESCRIPTOR_ENTRY_NAME)) {
                throw new IllegalArgumentException();
            }
            this.artifactMap.putAll(resources);
        }
        this.checkArtifactMap();
    }

    public SequenceClassificationModel<String> getSequenceLabelerModel() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        if (this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            String beamSizeString = manifest.getProperty("BeamSize");
            int beamSize = 3;
            if (beamSizeString != null) {
                beamSize = Integer.parseInt(beamSizeString);
            }
            return new BeamSearch(beamSize, (MaxentModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME));
        }
        if (this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel) {
            return (SequenceClassificationModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
        }
        return null;
    }

    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return SequenceLabelerFactory.class;
    }

    public SequenceLabelerFactory getFactory() {
        return (SequenceLabelerFactory)this.toolFactory;
    }

    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
        serializers.put("featuregen", new ByteArraySerializer());
    }

    public static Map<String, ArtifactSerializer> createArtifactSerializers() {
        Map serializers = BaseModel.createArtifactSerializers();
        serializers.put("featuregen", new ByteArraySerializer());
        return serializers;
    }

    boolean isModelValid(MaxentModel model) {
        String[] outcomes = new String[model.getNumOutcomes()];
        for (int i = 0; i < model.getNumOutcomes(); ++i) {
            outcomes[i] = model.getOutcome(i);
        }
        return this.getFactory().createSequenceCodec().areOutcomesCompatible(outcomes);
    }

    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof MaxentModel) && !(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel)) {
            throw new InvalidFormatException("Token Name Finder model is incomplete!");
        }
    }

    private static class ByteArraySerializer
    implements ArtifactSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public byte[] create(InputStream in) throws IOException, InvalidFormatException {
            return ModelUtil.read((InputStream)in);
        }

        public void serialize(byte[] artifact, OutputStream out) throws IOException {
            out.write(artifact);
        }
    }

    public static class FeatureGeneratorCreationError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        FeatureGeneratorCreationError(Throwable t) {
            super(t);
        }
    }
}

