/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.ml.utils;

import com.google.common.collect.ListMultimap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;

public final class IOUtils {
    public static final int BUFFER_SIZE = 65536;
    public static final String SPACE_DELIMITER = " ";
    public static final String TAB_DELIMITER = "\t";

    private IOUtils() {
    }

    public static final String normalizeLexiconName(String resource) {
        resource = resource.replaceAll("\\p{P}", "");
        return resource;
    }

    public static final InputStream getDictionaryResource(String resource) {
        Path resourcePath = Paths.get(resource, new String[0]);
        String normalizedPath = resourcePath.toString();
        InputStream dictInputStream = IOUtils.getStreamFromClassPath(normalizedPath);
        if (dictInputStream == null) {
            try {
                dictInputStream = new FileInputStream(normalizedPath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return new BufferedInputStream(dictInputStream);
    }

    private static InputStream getStreamFromClassPath(String normalizedPath) {
        InputStream dictInputStream = null;
        String[] dictPaths = normalizedPath.split("src/main/resources");
        if (dictPaths.length == 2) {
            dictInputStream = IOUtils.class.getClassLoader().getResourceAsStream(dictPaths[1]);
        } else {
            String[] windowsPaths = normalizedPath.split("src\\\\main\\\\resources\\\\");
            if (windowsPaths.length == 2) {
                dictInputStream = IOUtils.class.getClassLoader().getResourceAsStream(windowsPaths[1]);
            }
        }
        return dictInputStream;
    }

    private static void checkInputFile(String name, File inFile) {
        String isFailure = null;
        if (inFile.isDirectory()) {
            isFailure = "The " + name + " file is a directory!";
        } else if (!inFile.exists()) {
            isFailure = "The " + name + " file does not exist!";
        } else if (!inFile.canRead()) {
            isFailure = "No permissions to read the " + name + " file!";
        }
        if (null != isFailure) {
            throw new TerminateToolException(-1, isFailure + " Path: " + inFile.getAbsolutePath());
        }
    }

    public static TrainingParameters loadTrainingParameters(String paramFile) {
        return IOUtils.loadTrainingParameters(paramFile, false);
    }

    private static TrainingParameters loadTrainingParameters(String paramFile, boolean supportSequenceTraining) {
        TrainingParameters params = null;
        if (paramFile != null) {
            IOUtils.checkInputFile("Training Parameter", new File(paramFile));
            InputStream paramsIn = null;
            try {
                paramsIn = new FileInputStream(new File(paramFile));
                params = new TrainingParameters(paramsIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Error during parameters loading: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (paramsIn != null) {
                        paramsIn.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("Error closing the input stream");
                }
            }
            if (!TrainerFactory.isValid((Map)params.getSettings())) {
                throw new TerminateToolException(1, "Training parameters file '" + paramFile + "' is invalid!");
            }
        }
        return params;
    }

    public static ObjectStream<String> readFileIntoMarkableStreamFactory(String infile) {
        MarkableFileInputStreamFactory inputStreamFactory = null;
        try {
            inputStreamFactory = new MarkableFileInputStreamFactory(new File(infile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, "UTF-8");
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError((IOException)e);
        }
        return lineStream;
    }

    public static <K, V> File writeClusterToFile(Map<K, V> tokenToClusterMap, String fileName, String delimiter) throws IOException {
        File outFile = new File(fileName);
        OutputStream outputStream = new FileOutputStream(outFile);
        if (fileName.endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        for (Map.Entry<K, V> entry : tokenToClusterMap.entrySet()) {
            writer.write(entry.getKey() + delimiter + entry.getValue() + "\n");
        }
        ((Writer)writer).close();
        return outFile;
    }

    public static <K, V> File writeMultimapToFile(ListMultimap<K, V> tokenToClusterMap, String fileName, String delimiter) throws IOException {
        File outFile = new File(fileName);
        OutputStream outputStream = new FileOutputStream(outFile);
        if (fileName.endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        for (Map.Entry entry : tokenToClusterMap.entries()) {
            writer.write(entry.getKey() + delimiter + entry.getValue() + "\n");
        }
        ((Writer)writer).close();
        return outFile;
    }

    public static File writeDictionaryLemmatizerToFile(Map<List<String>, String> dictMap, String fileName, String delimiter) throws IOException {
        File outFile = new File(fileName);
        OutputStream out = new FileOutputStream(outFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        if (fileName.endsWith(".gz")) {
            out = new GZIPOutputStream(out);
        }
        for (Map.Entry<List<String>, String> entry : dictMap.entrySet()) {
            writer.write(entry.getKey().get(0) + delimiter + entry.getKey().get(1) + delimiter + entry.getValue() + "\n");
        }
        ((Writer)writer).close();
        return outFile;
    }

    public static File writeObjectToFile(Object o, String fileName) throws IOException {
        File outFile = new File(fileName);
        OutputStream outputStream = new FileOutputStream(outFile);
        if (fileName.endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        outputStream = new BufferedOutputStream(outputStream);
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(o);
        oos.close();
        return outFile;
    }

    public static void writeGzipObjectToStream(Object o, OutputStream out) {
        out = new BufferedOutputStream(out);
        try {
            out = new GZIPOutputStream(out, true);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(o);
            oos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeObjectToStream(Object o, OutputStream out) {
        out = new BufferedOutputStream(out);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(o);
            oos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static InputStream openFromFile(File file) {
        try {
            FilterInputStream is = new BufferedInputStream(new FileInputStream(file), 65536);
            if (file.getName().endsWith(".gz") || file.getName().endsWith("gz")) {
                is = new GZIPInputStream((InputStream)is, 65536);
            }
            return is;
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "File '" + file + "' cannot be found", (Throwable)e);
        }
    }

    public static <T> T readObjectFromInputStream(InputStream is) throws IOException, ClassNotFoundException {
        is = new BufferedInputStream(is, 65536);
        ObjectInputStream ois = new ObjectInputStream(is);
        Object readObject = ois.readObject();
        return (T)readObject;
    }

    public static <T> T readGzipObjectFromInputStream(InputStream is) throws IOException, ClassNotFoundException {
        is = new BufferedInputStream(is, 65536);
        GZIPInputStream zis = new GZIPInputStream(is, 65536);
        ObjectInputStream ois = new ObjectInputStream(zis);
        Object readObject = ois.readObject();
        return (T)readObject;
    }
}

