/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.dict;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class POSModelResource
implements SerializableArtifact {
    private POSModel posModel;
    private POSTaggerME posTagger;

    public POSModelResource(InputStream in) throws IOException {
        this.posModel = new POSModel(in);
        this.posTagger = new POSTaggerME(this.posModel);
    }

    public String[] posTag(String[] tokens) {
        String[] posTags = this.posTagger.tag(tokens);
        return posTags;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        this.posModel.serialize(out);
        ((Writer)writer).flush();
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return POSModelResourceSerializer.class;
    }

    public static class POSModelResourceSerializer
    implements ArtifactSerializer<POSModelResource> {
        @Override
        public POSModelResource create(InputStream in) throws IOException, InvalidFormatException {
            return new POSModelResource(in);
        }

        @Override
        public void serialize(POSModelResource artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

