/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.dict;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class Word2VecCluster
implements SerializableArtifact {
    private static final Pattern spacePattern = Pattern.compile(" ");
    private Map<String, String> tokenToClusterMap = new HashMap<String, String>();

    public Word2VecCluster(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            String[] lineArray = spacePattern.split(line);
            if (lineArray.length != 2) continue;
            this.tokenToClusterMap.put(lineArray[0].toLowerCase(), lineArray[1]);
        }
    }

    public String lookupToken(String string) {
        return this.tokenToClusterMap.get(string);
    }

    public Map<String, String> getMap() {
        return this.tokenToClusterMap;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<String, String> entry : this.tokenToClusterMap.entrySet()) {
            writer.write(entry.getKey() + " " + entry.getValue() + "\n");
        }
        ((Writer)writer).flush();
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return Word2VecClusterSerializer.class;
    }

    public static class Word2VecClusterSerializer
    implements ArtifactSerializer<Word2VecCluster> {
        @Override
        public Word2VecCluster create(InputStream in) throws IOException, InvalidFormatException {
            return new Word2VecCluster(in);
        }

        @Override
        public void serialize(Word2VecCluster artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

