/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.AnnotationContainer;
import ixa.kaflib.CLink;
import ixa.kaflib.Chunk;
import ixa.kaflib.Comment;
import ixa.kaflib.Coref;
import ixa.kaflib.Dep;
import ixa.kaflib.Entity;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.Factuality;
import ixa.kaflib.Feature;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.KAFNotValidException;
import ixa.kaflib.LinkedEntity;
import ixa.kaflib.Mark;
import ixa.kaflib.NonTerminal;
import ixa.kaflib.Opinion;
import ixa.kaflib.Predicate;
import ixa.kaflib.Relation;
import ixa.kaflib.Relational;
import ixa.kaflib.Span;
import ixa.kaflib.TLink;
import ixa.kaflib.TLinkReferable;
import ixa.kaflib.Term;
import ixa.kaflib.Terminal;
import ixa.kaflib.Timex3;
import ixa.kaflib.Tree;
import ixa.kaflib.TreeNode;
import ixa.kaflib.WF;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.CDATA;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;

class ReadWriteManager {
    ReadWriteManager() {
    }

    static KAFDocument load(File file) throws IOException, JDOMException, KAFNotValidException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        Element rootElem = document.getRootElement();
        return ReadWriteManager.DOMToKAF(document);
    }

    static KAFDocument load(Reader stream) throws IOException, JDOMException, KAFNotValidException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(stream);
        Element rootElem = document.getRootElement();
        return ReadWriteManager.DOMToKAF(document);
    }

    static void save(KAFDocument kaf, String filename) {
        try {
            File file = new File(filename);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            out.write(ReadWriteManager.kafToStr(kaf));
            ((Writer)out).flush();
        }
        catch (Exception e) {
            System.out.println("Error writing to file");
        }
    }

    static void print(KAFDocument kaf) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
            out.write(ReadWriteManager.kafToStr(kaf));
            ((Writer)out).flush();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static String kafToStr(KAFDocument kaf) {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat().setLineSeparator(LineSeparator.UNIX));
        Document jdom = ReadWriteManager.KAFToDOM(kaf);
        return out.outputString(jdom);
    }

    private static KAFDocument DOMToKAF(Document dom) throws KAFNotValidException {
        HashMap<String, WF> wfIndex = new HashMap<String, WF>();
        HashMap<String, Term> termIndex = new HashMap<String, Term>();
        HashMap<String, Relational> relationalIndex = new HashMap<String, Relational>();
        HashMap<String, Predicate> predicateIndex = new HashMap<String, Predicate>();
        HashMap<String, Timex3> timexIndex = new HashMap<String, Timex3>();
        Element rootElem = dom.getRootElement();
        String lang = ReadWriteManager.getAttribute("lang", rootElem, Namespace.XML_NAMESPACE);
        String kafVersion = ReadWriteManager.getAttribute("version", rootElem);
        KAFDocument kaf = new KAFDocument(lang, kafVersion);
        List<Element> rootChildrenElems = rootElem.getChildren();
        for (Element elem : rootChildrenElems) {
            String id;
            String toId;
            String fromId;
            boolean isHead;
            List<Element> targetElems;
            Term targetTerm;
            Span<Term> span;
            if (elem.getName().equals("nafHeader")) {
                String uri;
                Element publicElem;
                List<Element> lpsElems = elem.getChildren("linguisticProcessors");
                for (Element lpsElem : lpsElems) {
                    String layer = ReadWriteManager.getAttribute("layer", lpsElem);
                    List<Element> lpElems = lpsElem.getChildren();
                    for (Element lpElem : lpElems) {
                        String hostname;
                        String version;
                        String endTimestamp;
                        String beginTimestamp;
                        String name = ReadWriteManager.getAttribute("name", lpElem);
                        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor(layer, name);
                        String string = ReadWriteManager.getOptAttribute("timestamp", lpElem);
                        if (string != null) {
                            newLp.setTimestamp(string);
                        }
                        if ((beginTimestamp = ReadWriteManager.getOptAttribute("beginTimestamp", lpElem)) != null) {
                            newLp.beginTimestamp = beginTimestamp;
                        }
                        if ((endTimestamp = ReadWriteManager.getOptAttribute("endTimestamp", lpElem)) != null) {
                            newLp.setEndTimestamp(endTimestamp);
                        }
                        if ((version = ReadWriteManager.getOptAttribute("version", lpElem)) != null) {
                            newLp.setVersion(version);
                        }
                        if ((hostname = ReadWriteManager.getOptAttribute("hostname", lpElem)) == null) continue;
                        newLp.setHostname(hostname);
                    }
                }
                Element fileDescElem = elem.getChild("fileDesc");
                if (fileDescElem != null) {
                    String creationtime;
                    String pages;
                    String filetype;
                    String filename;
                    String title;
                    KAFDocument.FileDesc fd = kaf.createFileDesc();
                    String author = ReadWriteManager.getOptAttribute("author", fileDescElem);
                    if (author != null) {
                        fd.author = author;
                    }
                    if ((title = ReadWriteManager.getOptAttribute("title", fileDescElem)) != null) {
                        fd.title = title;
                    }
                    if ((filename = ReadWriteManager.getOptAttribute("filename", fileDescElem)) != null) {
                        fd.filename = filename;
                    }
                    if ((filetype = ReadWriteManager.getOptAttribute("filetype", fileDescElem)) != null) {
                        fd.filetype = filetype;
                    }
                    if ((pages = ReadWriteManager.getOptAttribute("pages", fileDescElem)) != null) {
                        fd.pages = Integer.parseInt(pages);
                    }
                    if ((creationtime = ReadWriteManager.getOptAttribute("creationtime", fileDescElem)) != null) {
                        fd.creationtime = creationtime;
                    }
                }
                if ((publicElem = elem.getChild("public")) == null) continue;
                KAFDocument.Public pub = kaf.createPublic();
                String publicId = ReadWriteManager.getOptAttribute("publicId", publicElem);
                if (publicId != null) {
                    pub.publicId = publicId;
                }
                if ((uri = ReadWriteManager.getOptAttribute("uri", publicElem)) == null) continue;
                pub.uri = uri;
                continue;
            }
            if (elem.getName().equals("raw")) {
                kaf.setRawText(elem.getText());
                continue;
            }
            if (elem.getName().equals("text")) {
                List<Element> wfElems = elem.getChildren();
                for (Element wfElem : wfElems) {
                    String wXpath;
                    String wLength;
                    String string;
                    String wPage;
                    String wid = ReadWriteManager.getAttribute("id", wfElem);
                    String wForm = wfElem.getText();
                    String wSent = ReadWriteManager.getAttribute("sent", wfElem);
                    WF newWf = kaf.newWF(wid, wForm, (int)Integer.valueOf(wSent));
                    String wPara = ReadWriteManager.getOptAttribute("para", wfElem);
                    if (wPara != null) {
                        newWf.setPara(Integer.valueOf(wPara));
                    }
                    if ((wPage = ReadWriteManager.getOptAttribute("page", wfElem)) != null) {
                        newWf.setPage(Integer.valueOf(wPage));
                    }
                    if ((string = ReadWriteManager.getOptAttribute("offset", wfElem)) != null) {
                        newWf.setOffset(Integer.valueOf(string));
                    }
                    if ((wLength = ReadWriteManager.getOptAttribute("length", wfElem)) != null) {
                        newWf.setLength(Integer.valueOf(wLength));
                    }
                    if ((wXpath = ReadWriteManager.getOptAttribute("xpath", wfElem)) != null) {
                        newWf.setXpath(wXpath);
                    }
                    wfIndex.put(newWf.getId(), newWf);
                }
                continue;
            }
            if (elem.getName().equals("terms")) {
                List<Element> termElems = elem.getChildren();
                for (Element termElem : termElems) {
                    ReadWriteManager.DOMToTerm(termElem, kaf, false, wfIndex, termIndex, null);
                }
                continue;
            }
            if (elem.getName().equals("markables")) {
                String source = ReadWriteManager.getAttribute("source", elem);
                List<Element> markElems = elem.getChildren();
                for (Element markElem : markElems) {
                    List<Element> externalReferencesElems;
                    String markcase;
                    String tMorphofeat;
                    String pos;
                    String lemma;
                    String sid = ReadWriteManager.getAttribute("id", markElem);
                    Element spanElem2 = markElem.getChild("span");
                    if (spanElem2 == null) {
                        throw new IllegalStateException("Every mark must contain a span element");
                    }
                    List<Element> marksWfElems = spanElem2.getChildren("target");
                    Span<WF> span2 = kaf.newWFSpan();
                    for (Element element : marksWfElems) {
                        String wfId = ReadWriteManager.getAttribute("id", element);
                        boolean isHead2 = ReadWriteManager.isHead(element);
                        WF wf = wfIndex.get(wfId);
                        if (wf == null) {
                            throw new KAFNotValidException("WF " + wfId + " not found when loading mark " + sid);
                        }
                        span2.addTarget(wf, isHead2);
                    }
                    Mark newMark = kaf.newMark(sid, source, span2);
                    String string = ReadWriteManager.getOptAttribute("type", markElem);
                    if (string != null) {
                        newMark.setType(string);
                    }
                    if ((lemma = ReadWriteManager.getOptAttribute("lemma", markElem)) != null) {
                        newMark.setLemma(lemma);
                    }
                    if ((pos = ReadWriteManager.getOptAttribute("pos", markElem)) != null) {
                        newMark.setPos(pos);
                    }
                    if ((tMorphofeat = ReadWriteManager.getOptAttribute("morphofeat", markElem)) != null) {
                        newMark.setMorphofeat(tMorphofeat);
                    }
                    if ((markcase = ReadWriteManager.getOptAttribute("case", markElem)) != null) {
                        newMark.setCase(markcase);
                    }
                    if ((externalReferencesElems = markElem.getChildren("externalReferences")).size() <= 0) continue;
                    List<ExternalRef> externalRefs = ReadWriteManager.getExternalReferences(externalReferencesElems.get(0), kaf);
                    newMark.addExternalRefs(externalRefs);
                }
                continue;
            }
            if (elem.getName().equals("deps")) {
                List<Element> depElems = elem.getChildren();
                for (Element depElem : depElems) {
                    String fromId2 = ReadWriteManager.getAttribute("from", depElem);
                    String toId2 = ReadWriteManager.getAttribute("to", depElem);
                    Term from = termIndex.get(fromId2);
                    if (from == null) {
                        throw new KAFNotValidException("Term " + fromId2 + " not found when loading Dep (" + fromId2 + ", " + toId2 + ")");
                    }
                    Term to = termIndex.get(toId2);
                    if (to == null) {
                        throw new KAFNotValidException("Term " + toId2 + " not found when loading Dep (" + fromId2 + ", " + toId2 + ")");
                    }
                    String rfunc = ReadWriteManager.getAttribute("rfunc", depElem);
                    Dep newDep = kaf.newDep(from, to, rfunc);
                    String string = ReadWriteManager.getOptAttribute("case", depElem);
                    if (string == null) continue;
                    newDep.setCase(string);
                }
                continue;
            }
            if (elem.getName().equals("chunks")) {
                List<Element> chunkElems = elem.getChildren();
                for (Element chunkElem : chunkElems) {
                    String chunkCase;
                    String chunkId = ReadWriteManager.getAttribute("id", chunkElem);
                    String headId = ReadWriteManager.getAttribute("head", chunkElem);
                    Term chunkHead = termIndex.get(headId);
                    if (chunkHead == null) {
                        throw new KAFNotValidException("Term " + headId + " not found when loading chunk " + chunkId);
                    }
                    Element spanElem3 = chunkElem.getChild("span");
                    if (spanElem3 == null) {
                        throw new IllegalStateException("Every chunk must contain a span element");
                    }
                    List<Element> chunksTermElems = spanElem3.getChildren("target");
                    span = kaf.newTermSpan();
                    for (Element chunksTermElem : chunksTermElems) {
                        String termId = ReadWriteManager.getAttribute("id", chunksTermElem);
                        boolean isHead3 = ReadWriteManager.isHead(chunksTermElem);
                        targetTerm = termIndex.get(termId);
                        if (targetTerm == null) {
                            throw new KAFNotValidException("Term " + termId + " not found when loading chunk " + chunkId);
                        }
                        span.addTarget(targetTerm, targetTerm == chunkHead || isHead3);
                    }
                    if (!span.hasTarget(chunkHead)) {
                        throw new KAFNotValidException("The head of the chunk is not in it's span.");
                    }
                    Chunk chunk = kaf.newChunk(chunkId, span);
                    String chunkPhrase = ReadWriteManager.getOptAttribute("phrase", chunkElem);
                    if (chunkPhrase != null) {
                        chunk.setPhrase(chunkPhrase);
                    }
                    if ((chunkCase = ReadWriteManager.getOptAttribute("case", chunkElem)) == null) continue;
                    chunk.setCase(chunkCase);
                }
                continue;
            }
            if (elem.getName().equals("entities")) {
                List<Element> entityElems = elem.getChildren();
                for (Element entityElem : entityElems) {
                    List<Element> list;
                    String entId = ReadWriteManager.getAttribute("id", entityElem);
                    List<Element> referencesElem = entityElem.getChildren("references");
                    if (referencesElem.size() < 1) {
                        throw new IllegalStateException("Every entity must contain a 'references' element");
                    }
                    List<Element> spanElems = referencesElem.get(0).getChildren();
                    if (spanElems.size() < 1) {
                        throw new IllegalStateException("Every entity must contain a 'span' element inside 'references'");
                    }
                    ArrayList<Span<Term>> references = new ArrayList<Span<Term>>();
                    for (Element spanElem4 : spanElems) {
                        Span<Term> span2 = kaf.newTermSpan();
                        targetElems = spanElem4.getChildren();
                        if (targetElems.size() < 1) {
                            throw new IllegalStateException("Every span in an entity must contain at least one target inside");
                        }
                        for (Element targetElem : targetElems) {
                            String targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                            Term targetTerm2 = termIndex.get(targetTermId);
                            if (targetTerm2 == null) {
                                throw new KAFNotValidException("Term " + targetTermId + " not found when loading entity " + entId);
                            }
                            boolean isHead4 = ReadWriteManager.isHead(targetElem);
                            span2.addTarget(targetTerm2, isHead4);
                        }
                        references.add(span2);
                    }
                    Entity newEntity = kaf.newEntity(entId, references);
                    String entType = ReadWriteManager.getOptAttribute("type", entityElem);
                    if (entType != null) {
                        newEntity.setType(entType);
                    }
                    if ((list = entityElem.getChildren("externalReferences")).size() > 0) {
                        List<ExternalRef> externalRefs = ReadWriteManager.getExternalReferences(list.get(0), kaf);
                        newEntity.addExternalRefs(externalRefs);
                    }
                    relationalIndex.put(newEntity.getId(), newEntity);
                }
                continue;
            }
            if (elem.getName().equals("coreferences")) {
                List<Element> corefElems = elem.getChildren();
                for (Element corefElem : corefElems) {
                    List<Element> externalReferencesElems;
                    String coId = ReadWriteManager.getAttribute("id", corefElem);
                    List<Element> spanElems = corefElem.getChildren("span");
                    if (spanElems.size() < 1) {
                        throw new IllegalStateException("Every coref must contain a 'span' element inside 'references'");
                    }
                    ArrayList<Span<Term>> mentions = new ArrayList<Span<Term>>();
                    for (Element spanElem5 : spanElems) {
                        span = kaf.newTermSpan();
                        List<Element> list = spanElem5.getChildren();
                        if (list.size() < 1) {
                            throw new IllegalStateException("Every span in an entity must contain at least one target inside");
                        }
                        for (Element targetElem : list) {
                            String targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                            targetTerm = termIndex.get(targetTermId);
                            if (targetTerm == null) {
                                throw new KAFNotValidException("Term " + targetTermId + " not found when loading coref " + coId);
                            }
                            boolean isHead5 = ReadWriteManager.isHead(targetElem);
                            span.addTarget(targetTerm, isHead5);
                        }
                        mentions.add(span);
                    }
                    Coref newCoref = kaf.newCoref(coId, mentions);
                    String corefType = ReadWriteManager.getOptAttribute("type", corefElem);
                    if (corefType != null) {
                        newCoref.setType(corefType);
                    }
                    if ((externalReferencesElems = corefElem.getChildren("externalReferences")).size() <= 0) continue;
                    List<ExternalRef> list = ReadWriteManager.getExternalReferences(externalReferencesElems.get(0), kaf);
                    newCoref.addExternalRefs(list);
                }
                continue;
            }
            if (elem.getName().equals("timeExpressions")) {
                List<Element> timex3Elems = elem.getChildren();
                for (Element timex3Elem : timex3Elems) {
                    Element spanElem6;
                    String timex3Comment;
                    String timex3AnchorTimeId;
                    String timex3Mod;
                    String timex3ValueFromFunction;
                    String timex3Value;
                    String timex3TempFunc;
                    String timex3FuncInDoc;
                    String string;
                    String timex3Quant;
                    String timex3EndPointId;
                    String timex3Id = ReadWriteManager.getAttribute("id", timex3Elem);
                    String timex3Type = ReadWriteManager.getAttribute("type", timex3Elem);
                    Timex3 timex3 = kaf.newTimex3(timex3Id, timex3Type);
                    String timex3BeginPointId = ReadWriteManager.getOptAttribute("beginPoint", timex3Elem);
                    if (timex3BeginPointId != null) {
                        Term beginPoint = termIndex.get(timex3BeginPointId);
                        timex3.setBeginPoint(beginPoint);
                    }
                    if ((timex3EndPointId = ReadWriteManager.getOptAttribute("endPoint", timex3Elem)) != null) {
                        Term endPoint = termIndex.get(timex3EndPointId);
                        timex3.setEndPoint(endPoint);
                    }
                    if ((timex3Quant = ReadWriteManager.getOptAttribute("quant", timex3Elem)) != null) {
                        timex3.setQuant(timex3Quant);
                    }
                    if ((string = ReadWriteManager.getOptAttribute("freq", timex3Elem)) != null) {
                        timex3.setFreq(string);
                    }
                    if ((timex3FuncInDoc = ReadWriteManager.getOptAttribute("functionInDocument", timex3Elem)) != null) {
                        timex3.setFunctionInDocument(timex3FuncInDoc);
                    }
                    if ((timex3TempFunc = ReadWriteManager.getOptAttribute("temporalFunction", timex3Elem)) != null) {
                        Boolean tempFunc = timex3TempFunc.equals("true");
                        timex3.setTemporalFunction(tempFunc);
                    }
                    if ((timex3Value = ReadWriteManager.getOptAttribute("value", timex3Elem)) != null) {
                        timex3.setValue(timex3Value);
                    }
                    if ((timex3ValueFromFunction = ReadWriteManager.getOptAttribute("valueFromFunction", timex3Elem)) != null) {
                        timex3.setValueFromFunction(timex3ValueFromFunction);
                    }
                    if ((timex3Mod = ReadWriteManager.getOptAttribute("mod", timex3Elem)) != null) {
                        timex3.setMod(timex3Mod);
                    }
                    if ((timex3AnchorTimeId = ReadWriteManager.getOptAttribute("anchorTimeId", timex3Elem)) != null) {
                        timex3.setAnchorTimeId(timex3AnchorTimeId);
                    }
                    if ((timex3Comment = ReadWriteManager.getOptAttribute("comment", timex3Elem)) != null) {
                        timex3.setComment(timex3Comment);
                    }
                    if ((spanElem6 = timex3Elem.getChild("span")) != null) {
                        Span<WF> timex3Span = kaf.newWFSpan();
                        for (Element targetElem : spanElem6.getChildren("target")) {
                            String targetId = ReadWriteManager.getAttribute("id", targetElem);
                            WF wf = wfIndex.get(targetId);
                            if (wf == null) {
                                throw new KAFNotValidException("Word form " + targetId + " not found when loading timex3 " + timex3Id);
                            }
                            isHead = ReadWriteManager.isHead(targetElem);
                            timex3Span.addTarget(wf, isHead);
                        }
                        timex3.setSpan(timex3Span);
                    }
                    timexIndex.put(timex3.getId(), timex3);
                }
                continue;
            }
            if (elem.getName().equals("temporalRelations")) {
                List<Element> tLinkElems = elem.getChildren("tlink");
                for (Element tLinkElem : tLinkElems) {
                    String tlid = ReadWriteManager.getAttribute("id", tLinkElem);
                    fromId = ReadWriteManager.getAttribute("from", tLinkElem);
                    toId = ReadWriteManager.getAttribute("to", tLinkElem);
                    String fromType = ReadWriteManager.getAttribute("fromType", tLinkElem);
                    String toType = ReadWriteManager.getAttribute("toType", tLinkElem);
                    String relType = ReadWriteManager.getAttribute("relType", tLinkElem);
                    TLinkReferable tLinkReferable = (TLinkReferable)((Object)(fromType.equals("event") ? (Serializable)predicateIndex.get(fromId) : (Serializable)timexIndex.get(fromId)));
                    TLinkReferable to = (TLinkReferable)((Object)(toType.equals("event") ? (Serializable)predicateIndex.get(toId) : (Serializable)timexIndex.get(toId)));
                    TLink tLink = kaf.newTLink(tlid, tLinkReferable, to, relType);
                }
                continue;
            }
            if (elem.getName().equals("causalRelations")) {
                List<Element> clinkElems = elem.getChildren("clink");
                for (Element clinkElem : clinkElems) {
                    String clid = ReadWriteManager.getAttribute("id", clinkElem);
                    fromId = ReadWriteManager.getAttribute("from", clinkElem);
                    toId = ReadWriteManager.getAttribute("to", clinkElem);
                    String relType = ReadWriteManager.getOptAttribute("relType", clinkElem);
                    Predicate from = (Predicate)predicateIndex.get(fromId);
                    Predicate to = (Predicate)predicateIndex.get(toId);
                    CLink cLink = kaf.newCLink(clid, from, to);
                    if (relType == null) continue;
                    cLink.setRelType(relType);
                }
                continue;
            }
            if (elem.getName().equals("features")) {
                List<ExternalRef> externalRefs;
                List<Element> externalReferencesElems;
                String targetTermId;
                List<Element> spanElems;
                String lemma;
                Element propertiesElem = elem.getChild("properties");
                Element categoriesElem = elem.getChild("categories");
                if (propertiesElem != null) {
                    List<Element> propertyElems = propertiesElem.getChildren("property");
                    for (Element propertyElem : propertyElems) {
                        String pid = ReadWriteManager.getAttribute("id", propertyElem);
                        lemma = ReadWriteManager.getAttribute("lemma", propertyElem);
                        Element referencesElem = propertyElem.getChild("references");
                        if (referencesElem == null) {
                            throw new IllegalStateException("Every property must contain a 'references' element");
                        }
                        spanElems = referencesElem.getChildren("span");
                        if (spanElems.size() < 1) {
                            throw new IllegalStateException("Every property must contain a 'span' element inside 'references'");
                        }
                        ArrayList<Span<Term>> arrayList = new ArrayList<Span<Term>>();
                        for (Element spanElem7 : spanElems) {
                            Span<Term> span4 = kaf.newTermSpan();
                            List<Element> targetElems3 = spanElem7.getChildren();
                            if (targetElems3.size() < 1) {
                                throw new IllegalStateException("Every span in a property must contain at least one target inside");
                            }
                            for (Element targetElem : targetElems3) {
                                targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                                Term targetTerm3 = termIndex.get(targetTermId);
                                if (targetTerm3 == null) {
                                    throw new KAFNotValidException("Term " + targetTermId + " not found when loading property " + pid);
                                }
                                boolean isHead6 = ReadWriteManager.isHead(targetElem);
                                span4.addTarget(targetTerm3, isHead6);
                            }
                            arrayList.add(span4);
                        }
                        Feature newProperty = kaf.newProperty(pid, lemma, arrayList);
                        externalReferencesElems = propertyElem.getChildren("externalReferences");
                        if (externalReferencesElems.size() > 0) {
                            externalRefs = ReadWriteManager.getExternalReferences(externalReferencesElems.get(0), kaf);
                            newProperty.addExternalRefs(externalRefs);
                        }
                        relationalIndex.put(newProperty.getId(), newProperty);
                    }
                }
                if (categoriesElem == null) continue;
                List<Element> categoryElems = categoriesElem.getChildren("category");
                for (Element categoryElem : categoryElems) {
                    String cid = ReadWriteManager.getAttribute("id", categoryElem);
                    lemma = ReadWriteManager.getAttribute("lemma", categoryElem);
                    Element referencesElem = categoryElem.getChild("references");
                    if (referencesElem == null) {
                        throw new IllegalStateException("Every category must contain a 'references' element");
                    }
                    spanElems = referencesElem.getChildren("span");
                    if (spanElems.size() < 1) {
                        throw new IllegalStateException("Every category must contain a 'span' element inside 'references'");
                    }
                    ArrayList<Span<Term>> arrayList = new ArrayList<Span<Term>>();
                    for (Element spanElem : spanElems) {
                        Span<Term> span3 = kaf.newTermSpan();
                        List<Element> targetElems2 = spanElem.getChildren();
                        if (targetElems2.size() < 1) {
                            throw new IllegalStateException("Every span in a property must contain at least one target inside");
                        }
                        for (Element targetElem : targetElems2) {
                            targetTermId = ReadWriteManager.getAttribute("id", targetElem);
                            Term targetTerm2 = termIndex.get(targetTermId);
                            if (targetTerm2 == null) {
                                throw new KAFNotValidException("Term " + targetTermId + " not found when loading category " + cid);
                            }
                            boolean isHead7 = ReadWriteManager.isHead(targetElem);
                            span3.addTarget(targetTerm2, isHead7);
                        }
                        arrayList.add(span3);
                    }
                    Feature newCategory = kaf.newCategory(cid, lemma, arrayList);
                    externalReferencesElems = categoryElem.getChildren("externalReferences");
                    if (externalReferencesElems.size() > 0) {
                        externalRefs = ReadWriteManager.getExternalReferences(externalReferencesElems.get(0), kaf);
                        newCategory.addExternalRefs(externalRefs);
                    }
                    relationalIndex.put(newCategory.getId(), newCategory);
                }
                continue;
            }
            if (elem.getName().equals("opinions")) {
                List<Element> opinionElems = elem.getChildren("opinion");
                for (Element opinionElem : opinionElems) {
                    Element spanElem8;
                    Element opinionExpressionElem;
                    Element opinionTargetElem;
                    String refId;
                    String opinionId = ReadWriteManager.getAttribute("id", opinionElem);
                    Opinion opinion = kaf.newOpinion(opinionId);
                    Element opinionHolderElem = opinionElem.getChild("opinion_holder");
                    if (opinionHolderElem != null) {
                        Element element;
                        Span<Term> span5 = kaf.newTermSpan();
                        Opinion.OpinionHolder opinionHolder = opinion.createOpinionHolder(span5);
                        String ohType = ReadWriteManager.getOptAttribute("type", opinionHolderElem);
                        if (ohType != null) {
                            opinionHolder.setType(ohType);
                        }
                        if ((element = opinionHolderElem.getChild("span")) != null) {
                            targetElems = element.getChildren("target");
                            for (Element targetElem : targetElems) {
                                refId = ReadWriteManager.getOptAttribute("id", targetElem);
                                boolean isHead8 = ReadWriteManager.isHead(targetElem);
                                Term targetTerm4 = termIndex.get(refId);
                                if (targetTerm4 == null) {
                                    throw new KAFNotValidException("Term " + refId + " not found when loading opinion " + opinionId);
                                }
                                span5.addTarget(targetTerm4, isHead8);
                            }
                        }
                    }
                    if ((opinionTargetElem = opinionElem.getChild("opinion_target")) != null) {
                        Span<Term> span6 = kaf.newTermSpan();
                        Opinion.OpinionTarget opinionTarget = opinion.createOpinionTarget(span6);
                        Element element = opinionTargetElem.getChild("span");
                        if (element != null) {
                            targetElems = element.getChildren("target");
                            for (Element targetElem : targetElems) {
                                refId = ReadWriteManager.getOptAttribute("id", targetElem);
                                boolean isHead9 = ReadWriteManager.isHead(targetElem);
                                Term targetTerm3 = termIndex.get(refId);
                                if (targetTerm3 == null) {
                                    throw new KAFNotValidException("Term " + refId + " not found when loading opinion " + opinionId);
                                }
                                span6.addTarget(targetTerm3, isHead9);
                            }
                        }
                    }
                    if ((opinionExpressionElem = opinionElem.getChild("opinion_expression")) == null) continue;
                    span = kaf.newTermSpan();
                    String string = ReadWriteManager.getOptAttribute("polarity", opinionExpressionElem);
                    String strength = ReadWriteManager.getOptAttribute("strength", opinionExpressionElem);
                    String subjectivity = ReadWriteManager.getOptAttribute("subjectivity", opinionExpressionElem);
                    String sentimentSemanticType = ReadWriteManager.getOptAttribute("sentiment_semantic_type", opinionExpressionElem);
                    String sentimentProductFeature = ReadWriteManager.getOptAttribute("sentiment_product_feature", opinionExpressionElem);
                    Opinion.OpinionExpression opinionExpression = opinion.createOpinionExpression(span);
                    if (string != null) {
                        opinionExpression.setPolarity(string);
                    }
                    if (strength != null) {
                        opinionExpression.setStrength(strength);
                    }
                    if (subjectivity != null) {
                        opinionExpression.setSubjectivity(subjectivity);
                    }
                    if (sentimentSemanticType != null) {
                        opinionExpression.setSentimentSemanticType(sentimentSemanticType);
                    }
                    if (sentimentProductFeature != null) {
                        opinionExpression.setSentimentProductFeature(sentimentProductFeature);
                    }
                    if ((spanElem8 = opinionExpressionElem.getChild("span")) == null) continue;
                    List<Element> targetElems4 = spanElem8.getChildren("target");
                    for (Element targetElem : targetElems4) {
                        String refId2 = ReadWriteManager.getOptAttribute("id", targetElem);
                        boolean isHead10 = ReadWriteManager.isHead(targetElem);
                        Term targetTerm5 = termIndex.get(refId2);
                        if (targetTerm5 == null) {
                            throw new KAFNotValidException("Term " + refId2 + " not found when loading opinion " + opinionId);
                        }
                        span.addTarget(targetTerm5, isHead10);
                    }
                }
                continue;
            }
            if (elem.getName().equals("relations")) {
                List<Element> relationElems = elem.getChildren("relation");
                for (Element relationElem : relationElems) {
                    Relational from;
                    id = ReadWriteManager.getAttribute("id", relationElem);
                    fromId = ReadWriteManager.getAttribute("from", relationElem);
                    toId = ReadWriteManager.getAttribute("to", relationElem);
                    String confidenceStr = ReadWriteManager.getOptAttribute("confidence", relationElem);
                    float confidence = -1.0f;
                    if (confidenceStr != null) {
                        confidence = Float.parseFloat(confidenceStr);
                    }
                    if ((from = (Relational)relationalIndex.get(fromId)) == null) {
                        throw new KAFNotValidException("Entity/feature object " + fromId + " not found when loading relation " + id);
                    }
                    Relational relational = (Relational)relationalIndex.get(toId);
                    if (relational == null) {
                        throw new KAFNotValidException("Entity/feature object " + toId + " not found when loading relation " + id);
                    }
                    Relation newRelation = kaf.newRelation(id, from, relational);
                    if (!(confidence >= 0.0f)) continue;
                    newRelation.setConfidence(confidence);
                }
                continue;
            }
            if (elem.getName().equals("srl")) {
                List<Element> predicateElems = elem.getChildren("predicate");
                for (Element predicateElem : predicateElems) {
                    String confidence;
                    List<Element> externalReferencesElems;
                    id = ReadWriteManager.getAttribute("id", predicateElem);
                    Span<Term> span7 = kaf.newTermSpan();
                    Element spanElem = predicateElem.getChild("span");
                    if (spanElem != null) {
                        List<Element> targetElems5 = spanElem.getChildren("target");
                        for (Element targetElem : targetElems5) {
                            String string = ReadWriteManager.getAttribute("id", targetElem);
                            boolean isHead11 = ReadWriteManager.isHead(targetElem);
                            Term targetTerm6 = termIndex.get(string);
                            if (targetTerm6 == null) {
                                throw new KAFNotValidException("Term object " + string + " not found when loading predicate " + id);
                            }
                            span7.addTarget(targetTerm6, isHead11);
                        }
                    }
                    ArrayList<String> predTypes = new ArrayList<String>();
                    List<Element> predTypeElems = predicateElem.getChildren("predType");
                    for (Element element : predTypeElems) {
                        String ptUri = ReadWriteManager.getAttribute("uri", element);
                        predTypes.add(ptUri);
                    }
                    Predicate newPredicate = kaf.newPredicate(id, span7);
                    String string = ReadWriteManager.getOptAttribute("uri", predicateElem);
                    if (string != null) {
                        newPredicate.setUri(string);
                    }
                    if ((externalReferencesElems = predicateElem.getChildren("externalReferences")).size() > 0) {
                        List<ExternalRef> externalRefs = ReadWriteManager.getExternalReferences(externalReferencesElems.get(0), kaf);
                        newPredicate.addExternalRefs(externalRefs);
                    }
                    if ((confidence = ReadWriteManager.getOptAttribute("confidence", predicateElem)) != null) {
                        newPredicate.setConfidence(Float.valueOf(confidence).floatValue());
                    }
                    List<Element> roleElems = predicateElem.getChildren("role");
                    for (Element roleElem : roleElems) {
                        String rid = ReadWriteManager.getAttribute("id", roleElem);
                        String semRole = ReadWriteManager.getAttribute("semRole", roleElem);
                        Span<Term> roleSpan = kaf.newTermSpan();
                        Element roleSpanElem = roleElem.getChild("span");
                        if (roleSpanElem != null) {
                            List<Element> targetElems6 = roleSpanElem.getChildren("target");
                            for (Element targetElem : targetElems6) {
                                String targetId = ReadWriteManager.getAttribute("id", targetElem);
                                isHead = ReadWriteManager.isHead(targetElem);
                                Term targetTerm7 = termIndex.get(targetId);
                                if (targetTerm7 == null) {
                                    throw new KAFNotValidException("Term object " + targetId + " not found when loading role " + rid);
                                }
                                roleSpan.addTarget(targetTerm7, isHead);
                            }
                        }
                        Predicate.Role newRole = kaf.newRole(rid, newPredicate, semRole, roleSpan);
                        List<Element> rExternalReferencesElems = roleElem.getChildren("externalReferences");
                        if (rExternalReferencesElems.size() > 0) {
                            List<ExternalRef> externalRefs = ReadWriteManager.getExternalReferences(rExternalReferencesElems.get(0), kaf);
                            newRole.addExternalRefs(externalRefs);
                        }
                        newPredicate.addRole(newRole);
                    }
                    predicateIndex.put(newPredicate.getId(), newPredicate);
                }
                continue;
            }
            if (elem.getName().equals("constituency")) {
                List<Element> treeElems = elem.getChildren("tree");
                for (Element treeElem : treeElems) {
                    HashMap<String, TreeNode> treeNodes = new HashMap<String, TreeNode>();
                    HashMap<String, Boolean> rootNodes = new HashMap<String, Boolean>();
                    List<Element> terminalElems = treeElem.getChildren("t");
                    for (Element terminalElem : terminalElems) {
                        String id2 = ReadWriteManager.getAttribute("id", terminalElem);
                        Element element = terminalElem.getChild("span");
                        if (element == null) {
                            throw new KAFNotValidException("Constituent non terminal nodes need a span");
                        }
                        Span<Term> span8 = ReadWriteManager.loadTermSpan(element, termIndex, id2);
                        treeNodes.put(id2, kaf.newTerminal(id2, span8));
                        rootNodes.put(id2, true);
                    }
                    List<Element> nonTerminalElems = treeElem.getChildren("nt");
                    for (Element nonTerminalElem : nonTerminalElems) {
                        String string = ReadWriteManager.getAttribute("id", nonTerminalElem);
                        String label = ReadWriteManager.getAttribute("label", nonTerminalElem);
                        treeNodes.put(string, kaf.newNonTerminal(string, label));
                        rootNodes.put(string, true);
                    }
                    List<Element> edgeElems = treeElem.getChildren("edge");
                    for (Element element : edgeElems) {
                        String fromId3 = ReadWriteManager.getAttribute("from", element);
                        String toId3 = ReadWriteManager.getAttribute("to", element);
                        String edgeId = ReadWriteManager.getOptAttribute("id", element);
                        String head = ReadWriteManager.getOptAttribute("head", element);
                        boolean isHead12 = head != null && head.equals("yes");
                        TreeNode parentNode = (TreeNode)treeNodes.get(toId3);
                        TreeNode childNode = (TreeNode)treeNodes.get(fromId3);
                        if (parentNode == null || childNode == null) {
                            throw new KAFNotValidException("There is a problem with the edge(" + fromId3 + ", " + toId3 + "). One of its targets doesn't exist.");
                        }
                        try {
                            ((NonTerminal)parentNode).addChild(childNode);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        rootNodes.put(fromId3, false);
                        if (edgeId != null) {
                            childNode.setEdgeId(edgeId);
                        }
                        if (!isHead12) continue;
                        ((NonTerminal)childNode).setHead(isHead12);
                    }
                    for (Map.Entry entry : rootNodes.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        TreeNode rootNode = (TreeNode)treeNodes.get(entry.getKey());
                        kaf.newConstituent(rootNode);
                    }
                }
                continue;
            }
            if (elem.getName().equals("factualitylayer")) {
                List<Element> factualityElems = elem.getChildren("factvalue");
                for (Element factualityElem : factualityElems) {
                    id = ReadWriteManager.getAttribute("id", factualityElem);
                    String prediction = ReadWriteManager.getAttribute("prediction", factualityElem);
                    String confidenceStr = ReadWriteManager.getAttribute("confidence", factualityElem);
                    Double confidence = null;
                    if (confidenceStr != null) {
                        confidence = Double.parseDouble(confidenceStr);
                    }
                    Factuality factuality = kaf.newFactuality(wfIndex.get(id), prediction);
                    if (confidence == null) continue;
                    factuality.setConfidence(confidence);
                }
                continue;
            }
            kaf.addUnknownLayer(elem);
        }
        return kaf;
    }

    private static void DOMToTerm(Element termElem, KAFDocument kaf, boolean isComponent, Map<String, WF> wfIndex, Map<String, Term> termIndex, Term parentTerm) throws KAFNotValidException {
        List<Element> sentimentElems;
        String tMorphofeat;
        String pos;
        String lemma;
        String tid = ReadWriteManager.getAttribute("id", termElem);
        Element spanElem = termElem.getChild("span");
        List<Object> termsWfElems = new ArrayList();
        if (!isComponent) {
            if (spanElem == null) {
                throw new IllegalStateException("Every term must contain a span element");
            }
            termsWfElems = spanElem.getChildren("target");
        }
        Span<WF> span = kaf.newWFSpan();
        for (Element termsWfElem : termsWfElems) {
            String wfId = ReadWriteManager.getAttribute("id", termsWfElem);
            boolean isHead = ReadWriteManager.isHead(termsWfElem);
            WF wf = wfIndex.get(wfId);
            if (wf == null) {
                throw new KAFNotValidException("Wf " + wfId + " not found when loading term " + tid);
            }
            span.addTarget(wf, isHead);
        }
        Term newTerm = kaf.newTerm(tid, span, isComponent);
        String type = ReadWriteManager.getOptAttribute("type", termElem);
        if (type != null) {
            newTerm.setType(type);
        }
        if ((lemma = ReadWriteManager.getOptAttribute("lemma", termElem)) != null) {
            newTerm.setLemma(lemma);
        }
        if ((pos = ReadWriteManager.getOptAttribute("pos", termElem)) != null) {
            newTerm.setPos(pos);
        }
        if ((tMorphofeat = ReadWriteManager.getOptAttribute("morphofeat", termElem)) != null) {
            newTerm.setMorphofeat(tMorphofeat);
        }
        String tHead = ReadWriteManager.getOptAttribute("head", termElem);
        String termcase = ReadWriteManager.getOptAttribute("case", termElem);
        if (termcase != null) {
            newTerm.setCase(termcase);
        }
        if ((sentimentElems = termElem.getChildren("sentiment")).size() > 0) {
            Term.Sentiment sentiment = ReadWriteManager.DOMToSentiment(sentimentElems.get(0), kaf);
            newTerm.setSentiment(sentiment);
        }
        if (!isComponent) {
            List<Element> termsComponentElems = termElem.getChildren("component");
            for (Element termsComponentElem : termsComponentElems) {
                ReadWriteManager.DOMToTerm(termsComponentElem, kaf, true, wfIndex, termIndex, newTerm);
            }
        } else {
            parentTerm.addComponent(newTerm);
        }
        List<Element> externalReferencesElems = termElem.getChildren("externalReferences");
        if (externalReferencesElems.size() > 0) {
            List<ExternalRef> externalRefs = ReadWriteManager.getExternalReferences(externalReferencesElems.get(0), kaf);
            newTerm.addExternalRefs(externalRefs);
        }
        termIndex.put(newTerm.getId(), newTerm);
    }

    private static Term.Sentiment DOMToSentiment(Element sentimentElem, KAFDocument kaf) {
        String sentSentimentProductFeature;
        String sentSentimentMarker;
        String sentSentimentModifier;
        String sentSentimentSemanticType;
        String sentSubjectivity;
        String sentStrength;
        String sentPolarity;
        Term.Sentiment newSentiment = kaf.newSentiment();
        String sentResource = ReadWriteManager.getOptAttribute("resource", sentimentElem);
        if (sentResource != null) {
            newSentiment.setResource(sentResource);
        }
        if ((sentPolarity = ReadWriteManager.getOptAttribute("polarity", sentimentElem)) != null) {
            newSentiment.setPolarity(sentPolarity);
        }
        if ((sentStrength = ReadWriteManager.getOptAttribute("strength", sentimentElem)) != null) {
            newSentiment.setStrength(sentStrength);
        }
        if ((sentSubjectivity = ReadWriteManager.getOptAttribute("subjectivity", sentimentElem)) != null) {
            newSentiment.setSubjectivity(sentSubjectivity);
        }
        if ((sentSentimentSemanticType = ReadWriteManager.getOptAttribute("sentiment_semantic_type", sentimentElem)) != null) {
            newSentiment.setSentimentSemanticType(sentSentimentSemanticType);
        }
        if ((sentSentimentModifier = ReadWriteManager.getOptAttribute("sentiment_modifier", sentimentElem)) != null) {
            newSentiment.setSentimentModifier(sentSentimentModifier);
        }
        if ((sentSentimentMarker = ReadWriteManager.getOptAttribute("sentiment_marker", sentimentElem)) != null) {
            newSentiment.setSentimentMarker(sentSentimentMarker);
        }
        if ((sentSentimentProductFeature = ReadWriteManager.getOptAttribute("sentiment_product_feature", sentimentElem)) != null) {
            newSentiment.setSentimentProductFeature(sentSentimentProductFeature);
        }
        return newSentiment;
    }

    private static Span<Term> loadTermSpan(Element spanElem, HashMap<String, Term> terms, String objId) throws KAFNotValidException {
        List<Element> targetElems = spanElem.getChildren("target");
        if (targetElems.size() < 1) {
            throw new KAFNotValidException("A span element can not be empty");
        }
        Span<Term> span = KAFDocument.newTermSpan();
        for (Element targetElem : targetElems) {
            String targetId = ReadWriteManager.getAttribute("id", targetElem);
            boolean isHead = ReadWriteManager.isHead(targetElem);
            Term targetTerm = terms.get(targetId);
            if (targetTerm == null) {
                throw new KAFNotValidException("Term object " + targetId + " not found when loading object " + objId);
            }
            span.addTarget(targetTerm, isHead);
        }
        return span;
    }

    private static Element createTermSpanElem(Span<Term> span) {
        Element spanElem = new Element("span");
        for (Term term : span.getTargets()) {
            Element targetElem = new Element("target");
            String targetId = term.getId();
            targetElem.setAttribute("id", targetId);
            if (span.isHead(term)) {
                targetElem.setAttribute("head", "yes");
            }
            spanElem.addContent(targetElem);
        }
        return spanElem;
    }

    private static List<ExternalRef> getExternalReferences(Element externalReferencesElem, KAFDocument kaf) {
        ArrayList<ExternalRef> externalRefs = new ArrayList<ExternalRef>();
        List<Element> externalRefElems = externalReferencesElem.getChildren();
        for (Element externalRefElem : externalRefElems) {
            ExternalRef externalRef = ReadWriteManager.getExternalRef(externalRefElem, kaf);
            externalRefs.add(externalRef);
        }
        return externalRefs;
    }

    private static ExternalRef getExternalRef(Element externalRefElem, KAFDocument kaf) {
        List<Element> sentimentElems;
        String source;
        String status;
        String reftype;
        String resource = ReadWriteManager.getAttribute("resource", externalRefElem);
        String references = ReadWriteManager.getAttribute("reference", externalRefElem);
        ExternalRef newExternalRef = kaf.newExternalRef(resource, references);
        String confidence = ReadWriteManager.getOptAttribute("confidence", externalRefElem);
        if (confidence != null) {
            newExternalRef.setConfidence(Float.valueOf(confidence));
        }
        if ((reftype = ReadWriteManager.getOptAttribute("reftype", externalRefElem)) != null) {
            newExternalRef.setReftype(reftype);
        }
        if ((status = ReadWriteManager.getOptAttribute("status", externalRefElem)) != null) {
            newExternalRef.setStatus(status);
        }
        if ((source = ReadWriteManager.getOptAttribute("source", externalRefElem)) != null) {
            newExternalRef.setSource(source);
        }
        if ((sentimentElems = externalRefElem.getChildren("sentiment")).size() > 0) {
            Term.Sentiment sentiment = ReadWriteManager.DOMToSentiment(sentimentElems.get(0), kaf);
            newExternalRef.setSentiment(sentiment);
        }
        List<Element> subRefElems = externalRefElem.getChildren("externalRef");
        for (Element subRefElem : subRefElems) {
            ExternalRef subRef = ReadWriteManager.getExternalRef(subRefElem, kaf);
            newExternalRef.addExternalRef(subRef);
        }
        return newExternalRef;
    }

    private static String getAttribute(String attName, Element elem) {
        String value = elem.getAttributeValue(attName);
        if (value == null) {
            throw new IllegalStateException(attName + " attribute must be defined for element " + elem.getName());
        }
        return value;
    }

    private static String getAttribute(String attName, Element elem, Namespace nmspace) {
        String value = elem.getAttributeValue(attName, nmspace);
        if (value == null) {
            throw new IllegalStateException(attName + " attribute must be defined for element " + elem.getName());
        }
        return value;
    }

    private static String getOptAttribute(String attName, Element elem) {
        String value = elem.getAttributeValue(attName);
        if (value == null) {
            return null;
        }
        return value;
    }

    private static boolean isHead(Element elem) {
        String value = elem.getAttributeValue("head");
        if (value == null) {
            return false;
        }
        return value.equals("yes");
    }

    private static Document KAFToDOM(KAFDocument kaf) {
        List<CLink> cLinks;
        List<TLink> tLinks;
        List<Tree> list;
        List<Predicate> predicates;
        List<Relation> relations;
        Element targetElem;
        Element spanElem;
        List<Opinion> opinions;
        List<Feature> list2;
        List<LinkedEntity> linkedEntities;
        List<Factuality> factualities;
        List<Timex3> timeExs;
        Element targetElem2;
        Element spanElem2;
        List<Coref> corefs;
        List<ExternalRef> externalReferences;
        Comment spanComment;
        List<Entity> entities;
        List<Chunk> chunks;
        List<Term> terms;
        List<WF> text;
        KAFDocument.Public pub;
        AnnotationContainer annotationContainer = kaf.getAnnotationContainer();
        Element root = new Element("NAF");
        root.setAttribute("lang", kaf.getLang(), Namespace.XML_NAMESPACE);
        root.setAttribute("version", kaf.getVersion());
        Document doc = new Document(root);
        Element kafHeaderElem = new Element("nafHeader");
        root.addContent(kafHeaderElem);
        KAFDocument.FileDesc fd = kaf.getFileDesc();
        if (fd != null) {
            Element fdElem = new Element("fileDesc");
            if (fd.author != null) {
                fdElem.setAttribute("author", fd.author);
            }
            if (fd.creationtime != null) {
                fdElem.setAttribute("creationtime", fd.creationtime);
            }
            if (fd.title != null) {
                fdElem.setAttribute("title", fd.title);
            }
            if (fd.filename != null) {
                fdElem.setAttribute("filename", fd.filename);
            }
            if (fd.filetype != null) {
                fdElem.setAttribute("filetype", fd.filetype);
            }
            if (fd.pages != null) {
                fdElem.setAttribute("pages", Integer.toString(fd.pages));
            }
            kafHeaderElem.addContent(fdElem);
        }
        if ((pub = kaf.getPublic()) != null) {
            Element pubElem = new Element("public");
            if (pub.publicId != null) {
                pubElem.setAttribute("publicId", pub.publicId);
            }
            if (pub.uri != null) {
                pubElem.setAttribute("uri", pub.uri);
            }
            kafHeaderElem.addContent(pubElem);
        }
        Map<String, List<KAFDocument.LinguisticProcessor>> lps = kaf.getLinguisticProcessors();
        for (Map.Entry<String, List<KAFDocument.LinguisticProcessor>> entry : lps.entrySet()) {
            Element lpsElem = new Element("linguisticProcessors");
            lpsElem.setAttribute("layer", entry.getKey());
            for (KAFDocument.LinguisticProcessor lp : entry.getValue()) {
                Element lpElem = new Element("lp");
                lpElem.setAttribute("name", lp.name);
                if (lp.hasTimestamp()) {
                    lpElem.setAttribute("timestamp", lp.timestamp);
                }
                if (lp.hasBeginTimestamp()) {
                    lpElem.setAttribute("beginTimestamp", lp.beginTimestamp);
                }
                if (lp.hasEndTimestamp()) {
                    lpElem.setAttribute("endTimestamp", lp.endTimestamp);
                }
                if (lp.hasVersion()) {
                    lpElem.setAttribute("version", lp.version);
                }
                if (lp.hasHostname().booleanValue()) {
                    lpElem.setAttribute("hostname", lp.hostname);
                }
                lpsElem.addContent(lpElem);
            }
            kafHeaderElem.addContent(lpsElem);
        }
        String rawText = annotationContainer.getRawText();
        if (rawText.length() > 0) {
            Element rawElem = new Element("raw");
            CDATA cdataElem = new CDATA(rawText);
            rawElem.addContent(cdataElem);
            root.addContent(rawElem);
        }
        if ((text = annotationContainer.getText()).size() > 0) {
            Element textElem = new Element("text");
            for (WF wf : text) {
                Element wfElem = new Element("wf");
                wfElem.setAttribute("id", wf.getId());
                wfElem.setAttribute("sent", Integer.toString(wf.getSent()));
                if (wf.hasPara()) {
                    wfElem.setAttribute("para", Integer.toString(wf.getPara()));
                }
                if (wf.hasPage()) {
                    wfElem.setAttribute("page", Integer.toString(wf.getPage()));
                }
                if (wf.hasOffset()) {
                    wfElem.setAttribute("offset", Integer.toString(wf.getOffset()));
                }
                if (wf.hasLength()) {
                    wfElem.setAttribute("length", Integer.toString(wf.getLength()));
                }
                if (wf.hasXpath()) {
                    wfElem.setAttribute("xpath", wf.getXpath());
                }
                wfElem.setText(wf.getForm());
                textElem.addContent(wfElem);
            }
            root.addContent(textElem);
        }
        if ((terms = annotationContainer.getTerms()).size() > 0) {
            Element termsElem = new Element("terms");
            for (Term term : terms) {
                ReadWriteManager.termToDOM(term, false, termsElem);
            }
            root.addContent(termsElem);
        }
        List<String> markSources = annotationContainer.getMarkSources();
        for (String source : markSources) {
            List<Mark> marks = annotationContainer.getMarks(source);
            if (marks.size() <= 0) continue;
            Element marksElem = new Element("markables");
            marksElem.setAttribute("source", source);
            for (Mark mark : marks) {
                Comment markComment = new Comment(mark.getStr());
                marksElem.addContent(markComment);
                Element markElem = new Element("mark");
                markElem.setAttribute("id", mark.getId());
                if (mark.hasType()) {
                    markElem.setAttribute("type", mark.getType());
                }
                if (mark.hasLemma()) {
                    markElem.setAttribute("lemma", mark.getLemma());
                }
                if (mark.hasPos()) {
                    markElem.setAttribute("pos", mark.getPos());
                }
                if (mark.hasMorphofeat()) {
                    markElem.setAttribute("morphofeat", mark.getMorphofeat());
                }
                if (mark.hasCase()) {
                    markElem.setAttribute("case", mark.getCase());
                }
                Element spanElem3 = new Element("span");
                Span<WF> span = mark.getSpan();
                for (WF target : span.getTargets()) {
                    Element targetElem3 = new Element("target");
                    targetElem3.setAttribute("id", target.getId());
                    if (target == span.getHead()) {
                        targetElem3.setAttribute("head", "yes");
                    }
                    spanElem3.addContent(targetElem3);
                }
                markElem.addContent(spanElem3);
                List<ExternalRef> externalReferences2 = mark.getExternalRefs();
                if (externalReferences2.size() > 0) {
                    Element externalReferencesElem2 = ReadWriteManager.externalReferencesToDOM(externalReferences2);
                    markElem.addContent(externalReferencesElem2);
                }
                marksElem.addContent(markElem);
            }
            root.addContent(marksElem);
        }
        List<Dep> deps = annotationContainer.getDeps();
        if (deps.size() > 0) {
            Element depsElem = new Element("deps");
            for (Dep dep : deps) {
                Comment depComment = new Comment(dep.getStr());
                depsElem.addContent(depComment);
                Element depElem = new Element("dep");
                depElem.setAttribute("from", dep.getFrom().getId());
                depElem.setAttribute("to", dep.getTo().getId());
                depElem.setAttribute("rfunc", dep.getRfunc());
                if (dep.hasCase()) {
                    depElem.setAttribute("case", dep.getCase());
                }
                depsElem.addContent(depElem);
            }
            root.addContent(depsElem);
        }
        if ((chunks = annotationContainer.getChunks()).size() > 0) {
            Element chunksElem = new Element("chunks");
            for (Chunk chunk : chunks) {
                Comment chunkComment = new Comment(chunk.getStr());
                chunksElem.addContent(chunkComment);
                Element chunkElem = new Element("chunk");
                chunkElem.setAttribute("id", chunk.getId());
                chunkElem.setAttribute("head", chunk.getHead().getId());
                if (chunk.hasPhrase()) {
                    chunkElem.setAttribute("phrase", chunk.getPhrase());
                }
                if (chunk.hasCase()) {
                    chunkElem.setAttribute("case", chunk.getCase());
                }
                Element spanElem4 = new Element("span");
                for (Term term : chunk.getTerms()) {
                    Element targetElem4 = new Element("target");
                    targetElem4.setAttribute("id", term.getId());
                    spanElem4.addContent(targetElem4);
                }
                chunkElem.addContent(spanElem4);
                chunksElem.addContent(chunkElem);
            }
            root.addContent(chunksElem);
        }
        if ((entities = annotationContainer.getEntities()).size() > 0) {
            Element entitiesElem = new Element("entities");
            for (Entity entity : entities) {
                Element entityElem = new Element("entity");
                entityElem.setAttribute("id", entity.getId());
                if (entity.hasType()) {
                    entityElem.setAttribute("type", entity.getType());
                }
                Element referencesElem = new Element("references");
                for (Span span : entity.getSpans()) {
                    spanComment = new Comment(entity.getSpanStr(span));
                    referencesElem.addContent(spanComment);
                    Element spanElem22 = new Element("span");
                    for (Term term : span.getTargets()) {
                        Element targetElem22 = new Element("target");
                        targetElem22.setAttribute("id", term.getId());
                        if (term == span.getHead()) {
                            targetElem22.setAttribute("head", "yes");
                        }
                        spanElem22.addContent(targetElem22);
                    }
                    referencesElem.addContent(spanElem22);
                }
                entityElem.addContent(referencesElem);
                externalReferences = entity.getExternalRefs();
                if (externalReferences.size() > 0) {
                    Element element = ReadWriteManager.externalReferencesToDOM(externalReferences);
                    entityElem.addContent(element);
                }
                entitiesElem.addContent(entityElem);
            }
            root.addContent(entitiesElem);
        }
        if ((corefs = annotationContainer.getCorefs()).size() > 0) {
            Element corefsElem = new Element("coreferences");
            for (Coref coref : corefs) {
                Element corefElem = new Element("coref");
                corefElem.setAttribute("id", coref.getId());
                if (coref.hasType()) {
                    corefElem.setAttribute("type", coref.getType());
                }
                for (Span span : coref.getSpans()) {
                    spanComment = new Comment(coref.getSpanStr(span));
                    corefElem.addContent(spanComment);
                    spanElem2 = new Element("span");
                    for (Term term : span.getTargets()) {
                        targetElem2 = new Element("target");
                        targetElem2.setAttribute("id", term.getId());
                        if (term == span.getHead()) {
                            targetElem2.setAttribute("head", "yes");
                        }
                        spanElem2.addContent(targetElem2);
                    }
                    corefElem.addContent(spanElem2);
                }
                externalReferences = coref.getExternalRefs();
                if (externalReferences.size() > 0) {
                    Element element = ReadWriteManager.externalReferencesToDOM(externalReferences);
                    corefElem.addContent(element);
                }
                corefsElem.addContent(corefElem);
            }
            root.addContent(corefsElem);
        }
        if ((timeExs = annotationContainer.getTimeExs()).size() > 0) {
            Element timeExsElem = new Element("timeExpressions");
            for (Timex3 timex3 : timeExs) {
                Element timex3Elem = new Element("timex3");
                timex3Elem.setAttribute("id", timex3.getId());
                timex3Elem.setAttribute("type", timex3.getType());
                if (timex3.hasBeginPoint()) {
                    timex3Elem.setAttribute("beginPoint", timex3.getBeginPoint().getId());
                }
                if (timex3.hasEndPoint()) {
                    timex3Elem.setAttribute("endPoint", timex3.getEndPoint().getId());
                }
                if (timex3.hasQuant()) {
                    timex3Elem.setAttribute("quant", timex3.getQuant());
                }
                if (timex3.hasFreq()) {
                    timex3Elem.setAttribute("freq", timex3.getFreq());
                }
                if (timex3.hasFunctionInDocument()) {
                    timex3Elem.setAttribute("functionInDocument", timex3.getFunctionInDocument());
                }
                if (timex3.hasTemporalFunction()) {
                    String string = timex3.getTemporalFunction() != false ? "true" : "false";
                    timex3Elem.setAttribute("temporalFunction", string);
                }
                if (timex3.hasValue()) {
                    timex3Elem.setAttribute("value", timex3.getValue());
                }
                if (timex3.hasValueFromFunction()) {
                    timex3Elem.setAttribute("valueFromFunction", timex3.getValueFromFunction());
                }
                if (timex3.hasMod()) {
                    timex3Elem.setAttribute("mod", timex3.getMod());
                }
                if (timex3.hasAnchorTimeId()) {
                    timex3Elem.setAttribute("anchorTimeId", timex3.getAnchorTimeId());
                }
                if (timex3.hasComment()) {
                    timex3Elem.setAttribute("comment", timex3.getComment());
                }
                if (timex3.hasSpan()) {
                    Span<WF> span = timex3.getSpan();
                    spanComment = new Comment(timex3.getSpanStr(span));
                    timex3Elem.addContent(spanComment);
                    spanElem2 = new Element("span");
                    for (WF wF : span.getTargets()) {
                        targetElem2 = new Element("target");
                        targetElem2.setAttribute("id", wF.getId());
                        if (wF == span.getHead()) {
                            targetElem2.setAttribute("head", "yes");
                        }
                        spanElem2.addContent(targetElem2);
                    }
                    timex3Elem.addContent(spanElem2);
                }
                timeExsElem.addContent(timex3Elem);
            }
            root.addContent(timeExsElem);
        }
        if ((factualities = annotationContainer.getFactualities()).size() > 0) {
            Element factsElement = new Element("factualitylayer");
            for (Factuality f : factualities) {
                Element element = new Element("factvalue");
                element.setAttribute("id", f.getId());
                element.setAttribute("prediction", f.getPrediction());
                element.setAttribute("confidence", Double.toString(f.getConfidence()));
                factsElement.addContent(element);
            }
            root.addContent(factsElement);
        }
        if ((linkedEntities = annotationContainer.getLinkedEntities()).size() > 0) {
            Element linkedEntityElement = new Element("linkedEntities");
            for (LinkedEntity linkedEntity : linkedEntities) {
                Element lEnt = new Element("linkedEntity");
                lEnt.setAttribute("id", linkedEntity.getId());
                lEnt.setAttribute("resource", linkedEntity.getResource());
                lEnt.setAttribute("reference", linkedEntity.getReference());
                lEnt.setAttribute("confidence", Double.toString(linkedEntity.getConfidence()));
                Comment spanComment2 = new Comment(linkedEntity.getSpanStr());
                lEnt.addContent(spanComment2);
                Element spanElem5 = new Element("span");
                for (WF target : linkedEntity.getWFs().getTargets()) {
                    Element targetElem5 = new Element("target");
                    targetElem5.setAttribute("id", target.getId());
                    spanElem5.addContent(targetElem5);
                }
                lEnt.addContent(spanElem5);
                linkedEntityElement.addContent(lEnt);
            }
            root.addContent(linkedEntityElement);
        }
        Element featuresElem = new Element("features");
        List<Feature> properties = annotationContainer.getProperties();
        if (properties.size() > 0) {
            Element element = new Element("properties");
            for (Feature property : properties) {
                Element propertyElem = new Element("property");
                propertyElem.setAttribute("id", property.getId());
                propertyElem.setAttribute("lemma", property.getLemma());
                List<Span<Term>> list3 = property.getSpans();
                Element referencesElem = new Element("references");
                for (Span span : list3) {
                    Comment comment = new Comment(property.getSpanStr(span));
                    referencesElem.addContent(comment);
                    Element spanElem6 = new Element("span");
                    for (Term term : span.getTargets()) {
                        Element targetElem6 = new Element("target");
                        targetElem6.setAttribute("id", term.getId());
                        if (term == span.getHead()) {
                            targetElem6.setAttribute("head", "yes");
                        }
                        spanElem6.addContent(targetElem6);
                    }
                    referencesElem.addContent(spanElem6);
                }
                propertyElem.addContent(referencesElem);
                element.addContent(propertyElem);
            }
            featuresElem.addContent(element);
        }
        if ((list2 = annotationContainer.getCategories()).size() > 0) {
            Element categoriesElem = new Element("categories");
            for (Feature category : list2) {
                Element element = new Element("category");
                element.setAttribute("id", category.getId());
                element.setAttribute("lemma", category.getLemma());
                List<Span<Term>> references = category.getSpans();
                Element referencesElem = new Element("references");
                for (Span<Term> span : references) {
                    Comment spanComment4 = new Comment(category.getSpanStr(span));
                    referencesElem.addContent(spanComment4);
                    Element spanElem7 = new Element("span");
                    for (Term term : span.getTargets()) {
                        Element targetElem7 = new Element("target");
                        targetElem7.setAttribute("id", term.getId());
                        if (term == span.getHead()) {
                            targetElem7.setAttribute("head", "yes");
                        }
                        spanElem7.addContent(targetElem7);
                    }
                    referencesElem.addContent(spanElem7);
                }
                element.addContent(referencesElem);
                categoriesElem.addContent(element);
            }
            featuresElem.addContent(categoriesElem);
        }
        if (featuresElem.getChildren().size() > 0) {
            root.addContent(featuresElem);
        }
        if ((opinions = annotationContainer.getOpinions()).size() > 0) {
            Element opinionsElem = new Element("opinions");
            for (Opinion opinion : opinions) {
                Opinion.OpinionExpression opinionExpression;
                Opinion.OpinionTarget opinionTarget;
                Element opinionElem = new Element("opinion");
                opinionElem.setAttribute("id", opinion.getId());
                Opinion.OpinionHolder holder = opinion.getOpinionHolder();
                if (holder != null) {
                    Element element = new Element("opinion_holder");
                    if (holder.hasType()) {
                        element.setAttribute("type", holder.getType());
                    }
                    Comment comment = new Comment(opinion.getSpanStr(opinion.getOpinionHolder().getSpan()));
                    element.addContent(comment);
                    List<Term> targets = holder.getTerms();
                    Span<Term> span5 = holder.getSpan();
                    if (targets.size() > 0) {
                        spanElem = new Element("span");
                        element.addContent(spanElem);
                        for (Term target : targets) {
                            targetElem = new Element("target");
                            targetElem.setAttribute("id", target.getId());
                            if (target == span5.getHead()) {
                                targetElem.setAttribute("head", "yes");
                            }
                            spanElem.addContent(targetElem);
                        }
                    }
                    opinionElem.addContent(element);
                }
                if ((opinionTarget = opinion.getOpinionTarget()) != null) {
                    Element element = new Element("opinion_target");
                    Comment comment = new Comment(opinion.getSpanStr(opinion.getOpinionTarget().getSpan()));
                    element.addContent(comment);
                    List<Term> targets = opinionTarget.getTerms();
                    Span<Term> span6 = opinionTarget.getSpan();
                    if (targets.size() > 0) {
                        Element spanElem8 = new Element("span");
                        element.addContent(spanElem8);
                        for (Term target : targets) {
                            Element targetElem8 = new Element("target");
                            targetElem8.setAttribute("id", target.getId());
                            if (target == span6.getHead()) {
                                targetElem8.setAttribute("head", "yes");
                            }
                            spanElem8.addContent(targetElem8);
                        }
                    }
                    opinionElem.addContent(element);
                }
                if ((opinionExpression = opinion.getOpinionExpression()) != null) {
                    Element opinionExpressionElem = new Element("opinion_expression");
                    Comment comment = new Comment(opinion.getSpanStr(opinion.getOpinionExpression().getSpan()));
                    opinionExpressionElem.addContent(comment);
                    if (opinionExpression.hasPolarity()) {
                        opinionExpressionElem.setAttribute("polarity", opinionExpression.getPolarity());
                    }
                    if (opinionExpression.hasStrength()) {
                        opinionExpressionElem.setAttribute("strength", opinionExpression.getStrength());
                    }
                    if (opinionExpression.hasSubjectivity()) {
                        opinionExpressionElem.setAttribute("subjectivity", opinionExpression.getSubjectivity());
                    }
                    if (opinionExpression.hasSentimentSemanticType()) {
                        opinionExpressionElem.setAttribute("sentiment_semantic_type", opinionExpression.getSentimentSemanticType());
                    }
                    if (opinionExpression.hasSentimentProductFeature()) {
                        opinionExpressionElem.setAttribute("sentiment_product_feature", opinionExpression.getSentimentProductFeature());
                    }
                    List<Term> targets = opinionExpression.getTerms();
                    Span<Term> span7 = opinionExpression.getSpan();
                    if (targets.size() > 0) {
                        Element spanElem9 = new Element("span");
                        opinionExpressionElem.addContent(spanElem9);
                        for (Term target : targets) {
                            Element targetElem9 = new Element("target");
                            targetElem9.setAttribute("id", target.getId());
                            if (target == span7.getHead()) {
                                targetElem9.setAttribute("head", "yes");
                            }
                            spanElem9.addContent(targetElem9);
                        }
                    }
                    opinionElem.addContent(opinionExpressionElem);
                }
                opinionsElem.addContent(opinionElem);
            }
            root.addContent(opinionsElem);
        }
        if ((relations = annotationContainer.getRelations()).size() > 0) {
            Element relationsElem = new Element("relations");
            for (Relation relation : relations) {
                Comment comment = new Comment(relation.getStr());
                relationsElem.addContent(comment);
                Element element = new Element("relation");
                element.setAttribute("id", relation.getId());
                element.setAttribute("from", relation.getFrom().getId());
                element.setAttribute("to", relation.getTo().getId());
                if (relation.hasConfidence()) {
                    element.setAttribute("confidence", String.valueOf(relation.getConfidence()));
                }
                relationsElem.addContent(element);
            }
            root.addContent(relationsElem);
        }
        if ((predicates = annotationContainer.getPredicates()).size() > 0) {
            Element element = new Element("srl");
            for (Predicate predicate : predicates) {
                List<ExternalRef> externalReferences3;
                Span<Term> span8;
                Comment comment = new Comment(predicate.getStr());
                element.addContent(comment);
                Element element2 = new Element("predicate");
                element2.setAttribute("id", predicate.getId());
                if (predicate.hasUri()) {
                    element2.setAttribute("uri", predicate.getUri());
                }
                if (predicate.hasConfidence()) {
                    element2.setAttribute("confidence", Float.toString(predicate.getConfidence()));
                }
                if ((span8 = predicate.getSpan()).getTargets().size() > 0) {
                    Comment spanComment5 = new Comment(predicate.getSpanStr());
                    spanElem = new Element("span");
                    element2.addContent(spanComment5);
                    element2.addContent(spanElem);
                    for (Term target : span8.getTargets()) {
                        targetElem = new Element("target");
                        targetElem.setAttribute("id", target.getId());
                        if (target == span8.getHead()) {
                            targetElem.setAttribute("head", "yes");
                        }
                        spanElem.addContent(targetElem);
                    }
                }
                if ((externalReferences3 = predicate.getExternalRefs()).size() > 0) {
                    Element externalReferencesElem3 = ReadWriteManager.externalReferencesToDOM(externalReferences3);
                    element2.addContent(externalReferencesElem3);
                }
                for (Predicate.Role role : predicate.getRoles()) {
                    List<ExternalRef> rExternalReferences;
                    Element roleElem = new Element("role");
                    roleElem.setAttribute("id", role.getId());
                    roleElem.setAttribute("semRole", role.getSemRole());
                    Span<Term> roleSpan = role.getSpan();
                    if (roleSpan.getTargets().size() > 0) {
                        Comment spanComment6 = new Comment(role.getStr());
                        Element spanElem10 = new Element("span");
                        roleElem.addContent(spanComment6);
                        roleElem.addContent(spanElem10);
                        for (Term target : roleSpan.getTargets()) {
                            Element targetElem10 = new Element("target");
                            targetElem10.setAttribute("id", target.getId());
                            if (target == roleSpan.getHead()) {
                                targetElem10.setAttribute("head", "yes");
                            }
                            spanElem10.addContent(targetElem10);
                        }
                    }
                    if ((rExternalReferences = role.getExternalRefs()).size() > 0) {
                        Element externalReferencesElem4 = ReadWriteManager.externalReferencesToDOM(rExternalReferences);
                        roleElem.addContent(externalReferencesElem4);
                    }
                    element2.addContent(roleElem);
                }
                element.addContent(element2);
            }
            root.addContent(element);
        }
        if ((list = annotationContainer.getConstituents()).size() > 0) {
            Element constituentsElem = new Element("constituency");
            for (Tree tree : list) {
                Element element = new Element("tree");
                constituentsElem.addContent(element);
                LinkedList<NonTerminal> nonTerminals = new LinkedList<NonTerminal>();
                LinkedList<Terminal> terminals = new LinkedList<Terminal>();
                ArrayList<Edge> edges = new ArrayList<Edge>();
                TreeNode rootNode = tree.getRoot();
                ReadWriteManager.extractTreeNodes(rootNode, nonTerminals, terminals, edges);
                Collections.sort(nonTerminals, new Comparator<NonTerminal>(){

                    @Override
                    public int compare(NonTerminal nt1, NonTerminal nt2) {
                        if (ReadWriteManager.cmpId(nt1.getId(), nt2.getId()) < 0) {
                            return -1;
                        }
                        if (nt1.getId().equals(nt2.getId())) {
                            return 0;
                        }
                        return 1;
                    }
                });
                Collections.sort(terminals, new Comparator<Terminal>(){

                    @Override
                    public int compare(Terminal t1, Terminal t2) {
                        if (ReadWriteManager.cmpId(t1.getId(), t2.getId()) < 0) {
                            return -1;
                        }
                        if (t1.getId().equals(t2.getId())) {
                            return 0;
                        }
                        return 1;
                    }
                });
                Comment ntCom = new Comment("Non-terminals");
                element.addContent(ntCom);
                for (NonTerminal node : nonTerminals) {
                    Element nodeElem = new Element("nt");
                    nodeElem.setAttribute("id", node.getId());
                    nodeElem.setAttribute("label", node.getLabel());
                    element.addContent(nodeElem);
                }
                Comment tCom = new Comment("Terminals");
                element.addContent(tCom);
                for (Terminal node : terminals) {
                    Element nodeElem = new Element("t");
                    nodeElem.setAttribute("id", node.getId());
                    nodeElem.addContent(ReadWriteManager.createTermSpanElem(node.getSpan()));
                    Comment tStrCom = new Comment(node.getStr());
                    element.addContent(tStrCom);
                    element.addContent(nodeElem);
                }
                Comment edgeCom = new Comment("Tree edges");
                element.addContent(edgeCom);
                for (Edge edge : edges) {
                    Element edgeElem = new Element("edge");
                    if (edge.id != null) {
                        edgeElem.setAttribute("id", edge.id);
                    }
                    edgeElem.setAttribute("from", edge.from);
                    edgeElem.setAttribute("to", edge.to);
                    if (edge.head) {
                        edgeElem.setAttribute("head", "yes");
                    }
                    element.addContent(edgeElem);
                }
            }
            root.addContent(constituentsElem);
        }
        if ((tLinks = annotationContainer.getTLinks()).size() > 0) {
            Element tLinksElem = new Element("temporalRelations");
            for (TLink tLink : tLinks) {
                Comment tLinkComment = new Comment(tLink.getRelType() + "(" + tLink.getFrom().getId() + ", " + tLink.getTo().getId() + ")");
                tLinksElem.addContent(tLinkComment);
                Element tLinkElem = new Element("tlink");
                tLinkElem.setAttribute("id", tLink.getId());
                tLinkElem.setAttribute("from", tLink.getFrom().getId());
                tLinkElem.setAttribute("to", tLink.getTo().getId());
                tLinkElem.setAttribute("fromType", tLink.getFromType());
                tLinkElem.setAttribute("toType", tLink.getToType());
                tLinkElem.setAttribute("relType", tLink.getRelType());
                tLinksElem.addContent(tLinkElem);
            }
            root.addContent(tLinksElem);
        }
        if ((cLinks = annotationContainer.getCLinks()).size() > 0) {
            Element element = new Element("causalRelations");
            for (CLink cLink : cLinks) {
                String commentStr = "";
                if (cLink.hasRelType()) {
                    commentStr = commentStr + cLink.getRelType();
                }
                commentStr = commentStr + "(" + cLink.getFrom().getId() + ", " + cLink.getTo().getId() + ")";
                Comment cLinkComment = new Comment(commentStr);
                element.addContent(cLinkComment);
                Element cLinkElem = new Element("clink");
                cLinkElem.setAttribute("id", cLink.getId());
                cLinkElem.setAttribute("from", cLink.getFrom().getId());
                cLinkElem.setAttribute("to", cLink.getTo().getId());
                if (cLink.hasRelType()) {
                    cLinkElem.setAttribute("relType", cLink.getRelType());
                }
                element.addContent(cLinkElem);
            }
            root.addContent(element);
        }
        List<Element> list4 = annotationContainer.getUnknownLayers();
        for (Element layer : list4) {
            layer.detach();
            root.addContent(layer);
        }
        return doc;
    }

    private static void termToDOM(Term term, boolean isComponent, Element termsElem) {
        List<ExternalRef> externalReferences;
        if (!isComponent) {
            Comment termComment = new Comment(term.getStr());
            termsElem.addContent(termComment);
        }
        String tag = isComponent ? "component" : "term";
        Element termElem = new Element(tag);
        termElem.setAttribute("id", term.getId());
        if (term.hasType()) {
            termElem.setAttribute("type", term.getType());
        }
        if (term.hasLemma()) {
            termElem.setAttribute("lemma", term.getLemma());
        }
        if (term.hasPos()) {
            termElem.setAttribute("pos", term.getPos());
        }
        if (term.hasMorphofeat()) {
            termElem.setAttribute("morphofeat", term.getMorphofeat());
        }
        if (term.hasHead()) {
            termElem.setAttribute("head", term.getHead().getId());
        }
        if (term.hasCase()) {
            termElem.setAttribute("case", term.getCase());
        }
        if (term.hasSentiment()) {
            Term.Sentiment sentiment = term.getSentiment();
            Element sentimentElem = ReadWriteManager.sentimentToDOM(sentiment);
            termElem.addContent(sentimentElem);
        }
        if (!isComponent) {
            Element spanElem = new Element("span");
            Span<WF> span = term.getSpan();
            for (WF target : term.getWFs()) {
                Element targetElem = new Element("target");
                targetElem.setAttribute("id", target.getId());
                if (target == span.getHead()) {
                    targetElem.setAttribute("head", "yes");
                }
                spanElem.addContent(targetElem);
            }
            termElem.addContent(spanElem);
            List<Term> components = term.getComponents();
            if (components.size() > 0) {
                for (Term component : components) {
                    ReadWriteManager.termToDOM(component, true, termElem);
                }
            }
        }
        if ((externalReferences = term.getExternalRefs()).size() > 0) {
            Element externalReferencesElem = ReadWriteManager.externalReferencesToDOM(externalReferences);
            termElem.addContent(externalReferencesElem);
        }
        termsElem.addContent(termElem);
    }

    private static void extractTreeNodes(TreeNode node, List<NonTerminal> nonTerminals, List<Terminal> terminals, List<Edge> edges) {
        if (node instanceof NonTerminal) {
            nonTerminals.add((NonTerminal)node);
            List<TreeNode> treeNodes = ((NonTerminal)node).getChildren();
            for (TreeNode child : treeNodes) {
                edges.add(new Edge(child, node));
                ReadWriteManager.extractTreeNodes(child, nonTerminals, terminals, edges);
            }
        } else {
            terminals.add((Terminal)node);
        }
    }

    private static Element externalReferencesToDOM(List<ExternalRef> externalRefs) {
        Element externalReferencesElem = new Element("externalReferences");
        for (ExternalRef externalRef : externalRefs) {
            Element externalRefElem = ReadWriteManager.externalRefToDOM(externalRef);
            externalReferencesElem.addContent(externalRefElem);
        }
        return externalReferencesElem;
    }

    private static Element externalRefToDOM(ExternalRef externalRef) {
        Element externalRefElem = new Element("externalRef");
        externalRefElem.setAttribute("resource", externalRef.getResource());
        externalRefElem.setAttribute("reference", externalRef.getReference());
        if (externalRef.hasConfidence()) {
            externalRefElem.setAttribute("confidence", Float.toString(externalRef.getConfidence().floatValue()));
        }
        if (externalRef.hasReftype()) {
            externalRefElem.setAttribute("reftype", externalRef.getReftype());
        }
        if (externalRef.hasStatus()) {
            externalRefElem.setAttribute("status", externalRef.getStatus());
        }
        if (externalRef.hasSource()) {
            externalRefElem.setAttribute("source", externalRef.getSource());
        }
        if (externalRef.hasSentiment()) {
            Element sentimentElem = ReadWriteManager.sentimentToDOM(externalRef.getSentiment());
            externalRefElem.addContent(sentimentElem);
        }
        for (ExternalRef subExternalRef : externalRef.getExternalRefs()) {
            Element subExternalRefElem = ReadWriteManager.externalRefToDOM(subExternalRef);
            externalRefElem.addContent(subExternalRefElem);
        }
        return externalRefElem;
    }

    private static Element sentimentToDOM(Term.Sentiment sentiment) {
        Element sentimentElem = new Element("sentiment");
        if (sentiment.hasResource()) {
            sentimentElem.setAttribute("resource", sentiment.getResource());
        }
        if (sentiment.hasPolarity()) {
            sentimentElem.setAttribute("polarity", sentiment.getPolarity());
        }
        if (sentiment.hasStrength()) {
            sentimentElem.setAttribute("strength", sentiment.getStrength());
        }
        if (sentiment.hasSubjectivity()) {
            sentimentElem.setAttribute("subjectivity", sentiment.getSubjectivity());
        }
        if (sentiment.hasSentimentSemanticType()) {
            sentimentElem.setAttribute("sentiment_semantic_type", sentiment.getSentimentSemanticType());
        }
        if (sentiment.hasSentimentModifier()) {
            sentimentElem.setAttribute("sentiment_modifier", sentiment.getSentimentModifier());
        }
        if (sentiment.hasSentimentMarker()) {
            sentimentElem.setAttribute("sentiment_marker", sentiment.getSentimentMarker());
        }
        if (sentiment.hasSentimentProductFeature()) {
            sentimentElem.setAttribute("sentiment_product_feature", sentiment.getSentimentProductFeature());
        }
        return sentimentElem;
    }

    private static int cmpId(String id1, String id2) {
        int nbr2;
        int nbr1 = ReadWriteManager.extractNumberFromId(id1);
        if (nbr1 < (nbr2 = ReadWriteManager.extractNumberFromId(id2))) {
            return -1;
        }
        if (nbr1 == nbr2) {
            return 0;
        }
        return 1;
    }

    private static int extractNumberFromId(String id) {
        Matcher matcher = Pattern.compile("^[a-z]*_?(\\d+)$").matcher(id);
        if (!matcher.find()) {
            throw new IllegalStateException("IdManager doesn't recognise the given id's (" + id + ") format. Should be [a-z]*_?[0-9]+");
        }
        return Integer.valueOf(matcher.group(1));
    }

    private static class Edge {
        String id;
        String from;
        String to;
        boolean head;

        Edge(TreeNode from, TreeNode to) {
            if (from.hasEdgeId()) {
                this.id = from.getEdgeId();
            }
            this.from = from.getId();
            this.to = to.getId();
            this.head = from.getHead();
        }
    }
}

