/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class W2VClassesDictionary
implements SerializableArtifact {
    private Map<String, String> tokenToClusterMap = new HashMap<String, String>();

    public W2VClassesDictionary(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split(" ");
            if (parts.length != 2) continue;
            this.tokenToClusterMap.put(parts[0], parts[1]);
        }
    }

    public String lookupToken(String string) {
        return this.tokenToClusterMap.get(string);
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<String, String> entry : this.tokenToClusterMap.entrySet()) {
            writer.write(entry.getKey() + " " + entry.getValue() + "\n");
        }
        ((Writer)writer).flush();
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return W2VClassesDictionarySerializer.class;
    }

    public static class W2VClassesDictionarySerializer
    implements ArtifactSerializer<W2VClassesDictionary> {
        @Override
        public W2VClassesDictionary create(InputStream in) throws IOException, InvalidFormatException {
            return new W2VClassesDictionary(in);
        }

        @Override
        public void serialize(W2VClassesDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

