/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc;

import eus.ixa.ixa.pipe.nerc.Name;
import eus.ixa.ixa.pipe.nerc.NameFactory;
import eus.ixa.ixa.pipe.nerc.NameFinder;
import eus.ixa.ixa.pipe.nerc.StringUtils;
import eus.ixa.ixa.pipe.nerc.lexer.NumericNameLexer;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.util.Span;

public class NumericNameFinder
implements NameFinder {
    private NumericNameLexer numericLexer;
    private NameFactory nameFactory;

    public NumericNameFinder(BufferedReader breader, NameFactory aNameFactory) {
        this.nameFactory = aNameFactory;
        this.numericLexer = new NumericNameLexer(breader, aNameFactory);
    }

    @Override
    public List<Name> getNames(String[] tokens) {
        Span[] origSpans = this.nercToSpans(tokens);
        Span[] neSpans = NameFinderME.dropOverlappingSpans(origSpans);
        List<Name> names = this.getNamesFromSpans(neSpans, tokens);
        return names;
    }

    @Override
    public Span[] nercToSpans(String[] tokens) {
        ArrayList<Span> neSpans = new ArrayList<Span>();
        List<Name> flexNameList = this.numericLexer.getNumericNames();
        for (Name name : flexNameList) {
            List<Integer> neIds = StringUtils.exactTokenFinderIgnoreCase(name.value(), tokens);
            for (int i = 0; i < neIds.size(); i += 2) {
                Span neSpan = new Span((int)neIds.get(i), (int)neIds.get(i + 1), name.getType());
                neSpans.add(neSpan);
            }
        }
        return neSpans.toArray(new Span[neSpans.size()]);
    }

    @Override
    public List<Name> getNamesFromSpans(Span[] neSpans, String[] tokens) {
        ArrayList<Name> names = new ArrayList<Name>();
        for (Span neSpan : neSpans) {
            String nameString = StringUtils.getStringFromSpan(neSpan, tokens);
            String neType = neSpan.getType();
            Name name = this.nameFactory.createName(nameString, neType, neSpan);
            names.add(name);
        }
        return names;
    }

    @Override
    public void clearAdaptiveData() {
    }
}

