/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc;

import eus.ixa.ixa.pipe.nerc.Name;
import eus.ixa.ixa.pipe.nerc.NameFactory;
import eus.ixa.ixa.pipe.nerc.NameFinder;
import eus.ixa.ixa.pipe.nerc.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;

public class StatisticalNameFinder
implements NameFinder {
    private static ConcurrentHashMap<String, TokenNameFinderModel> nercModels = new ConcurrentHashMap();
    private NameFinderME nameFinder;
    private NameFactory nameFactory;

    public StatisticalNameFinder(Properties props) {
        String lang = props.getProperty("language");
        String model = props.getProperty("model");
        TokenNameFinderModel nerModel = this.loadModel(lang, model);
        this.nameFinder = new NameFinderME(nerModel);
    }

    public StatisticalNameFinder(Properties props, NameFactory aNameFactory) {
        String lang = props.getProperty("language");
        String model = props.getProperty("model");
        this.nameFactory = aNameFactory;
        TokenNameFinderModel nerModel = this.loadModel(lang, model);
        this.nameFinder = new NameFinderME(nerModel);
    }

    @Override
    public final List<Name> getNames(String[] tokens) {
        Span[] origSpans = this.nercToSpans(tokens);
        Span[] neSpans = NameFinderME.dropOverlappingSpans(origSpans);
        List<Name> names = this.getNamesFromSpans(neSpans, tokens);
        return names;
    }

    @Override
    public final Span[] nercToSpans(String[] tokens) {
        Span[] annotatedText = this.nameFinder.find(tokens);
        ArrayList<Span> probSpans = new ArrayList<Span>(Arrays.asList(annotatedText));
        return probSpans.toArray(new Span[probSpans.size()]);
    }

    @Override
    public final List<Name> getNamesFromSpans(Span[] neSpans, String[] tokens) {
        ArrayList<Name> names = new ArrayList<Name>();
        for (Span neSpan : neSpans) {
            String nameString = StringUtils.getStringFromSpan(neSpan, tokens);
            String neType = neSpan.getType();
            Name name = this.nameFactory.createName(nameString, neType, neSpan);
            names.add(name);
        }
        return names;
    }

    @Override
    public final void clearAdaptiveData() {
        this.nameFinder.clearAdaptiveData();
    }

    private final TokenNameFinderModel loadModel(String lang, String model) {
        long lStartTime = new Date().getTime();
        try {
            nercModels.putIfAbsent(lang, new TokenNameFinderModel(new FileInputStream(model)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long lEndTime = new Date().getTime();
        long difference = lEndTime - lStartTime;
        System.err.println("ixa-pipe-nerc model loaded in: " + difference + " miliseconds ... [DONE]");
        return nercModels.get(lang);
    }
}

