/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.dict;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class ClarkCluster
implements SerializableArtifact {
    private static final Pattern spacePattern = Pattern.compile(" ");
    public static final Pattern dotInsideI = Pattern.compile("\u0130", 256);
    private Map<String, String> tokenToClusterMap = new HashMap<String, String>();

    public ClarkCluster(InputStream in) throws IOException {
        String line;
        BufferedReader breader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        while ((line = breader.readLine()) != null) {
            String normalizedToken;
            String[] lineArray = spacePattern.split(line);
            if (lineArray.length == 3) {
                normalizedToken = dotInsideI.matcher(lineArray[0]).replaceAll("i");
                this.tokenToClusterMap.put(normalizedToken.toLowerCase(), lineArray[1]);
                continue;
            }
            if (lineArray.length != 2) continue;
            normalizedToken = dotInsideI.matcher(lineArray[0]).replaceAll("i");
            this.tokenToClusterMap.put(normalizedToken.toLowerCase(), lineArray[1]);
        }
    }

    public String lookupToken(String string) {
        return this.tokenToClusterMap.get(string);
    }

    public Map<String, String> getMap() {
        return this.tokenToClusterMap;
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<String, String> entry : this.tokenToClusterMap.entrySet()) {
            writer.write(entry.getKey() + " " + entry.getValue() + "\n");
        }
        ((Writer)writer).flush();
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return ClarkClusterSerializer.class;
    }

    public static class ClarkClusterSerializer
    implements ArtifactSerializer<ClarkCluster> {
        @Override
        public ClarkCluster create(InputStream in) throws IOException, InvalidFormatException {
            return new ClarkCluster(in);
        }

        @Override
        public void serialize(ClarkCluster artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

