/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Term;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExternalRef
implements Serializable {
    private String resource;
    private String reference;
    private Float confidence;
    private String reftype;
    private String status;
    private String source;
    private List<ExternalRef> externalRefs;
    private Term.Sentiment sentiment;

    ExternalRef(String resource, String reference) {
        this.resource = resource;
        this.reference = reference;
        this.confidence = Float.valueOf(-1.0f);
        this.externalRefs = new ArrayList<ExternalRef>();
    }

    ExternalRef(ExternalRef externalReference) {
        this.resource = externalReference.resource;
        this.reference = externalReference.reference;
        this.confidence = externalReference.confidence;
        if (externalReference.externalRefs != null) {
            this.externalRefs = new ArrayList<ExternalRef>(externalReference.externalRefs);
        }
        this.sentiment = externalReference.sentiment;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String val) {
        this.resource = val;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String val) {
        this.reference = val;
    }

    public boolean hasReftype() {
        return this.reftype != null;
    }

    public String getReftype() {
        return this.reftype;
    }

    public void setReftype(String reftype) {
        this.reftype = reftype;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean hasConfidence() {
        return (double)this.confidence.floatValue() != -1.0;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Float val) {
        this.confidence = val;
    }

    public boolean hasExternalRef() {
        return this.externalRefs.size() > 0;
    }

    public List<ExternalRef> getExternalRefs() {
        return this.externalRefs;
    }

    public void addExternalRef(ExternalRef externalRef) {
        this.externalRefs.add(externalRef);
    }

    public void setExternalRef(ExternalRef externalRef) {
        this.externalRefs.add(externalRef);
    }

    public boolean hasSentiment() {
        return this.sentiment != null;
    }

    public Term.Sentiment getSentiment() {
        return this.sentiment;
    }

    public void setSentiment(Term.Sentiment sentiment) {
        this.sentiment = sentiment;
    }
}

