/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.IReferable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Span<T extends IReferable>
implements Serializable {
    private List<T> targets;
    private List<T> sortedTargets;
    private T head;

    Span() {
        this.targets = new ArrayList<T>();
        this.sortedTargets = new ArrayList<T>();
        this.head = null;
    }

    Span(List<T> targets) {
        this(targets, null);
    }

    Span(List<T> targets, T head) {
        this.targets = targets;
        this.sortedTargets = new ArrayList<T>();
        this.head = head;
    }

    public boolean isEmpty() {
        return this.targets.size() <= 0;
    }

    public List<T> getTargets() {
        return this.targets;
    }

    public T getFirstTarget() {
        return (T)((IReferable)this.targets.get(0));
    }

    public boolean hasHead() {
        return this.head != null;
    }

    public T getHead() {
        return this.head;
    }

    public boolean isHead(T target) {
        return target == this.head;
    }

    public void setHead(T head) {
        this.head = head;
    }

    public void addTarget(T target) {
        this.targets.add(target);
        this.sortedTargets.add(target);
        Collections.sort(this.sortedTargets);
    }

    public void addTarget(T target, boolean isHead) {
        this.addTarget(target);
        if (isHead) {
            this.head = target;
        }
    }

    public void addTargets(List<T> targets) {
        for (IReferable target : targets) {
            this.addTarget(target);
        }
    }

    public boolean hasTarget(T target) {
        for (IReferable t : this.targets) {
            if (t != target) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.targets.size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Span)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Span sp = (Span)obj;
        if (sp.size() != this.size()) {
            return false;
        }
        Integer i = 0;
        while (i < this.size()) {
            if (this.sortedTargets.get(i) != sp.sortedTargets.get(i)) {
                return false;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return true;
    }

    public int hashCode() {
        String spanId = "";
        for (IReferable target : this.sortedTargets) {
            if (!spanId.isEmpty()) {
                spanId = spanId + "_";
            }
            spanId = spanId + target.getId();
        }
        return spanId.hashCode();
    }

    public String toString() {
        return "Span{targets=" + this.targets + '}';
    }
}

