/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos;

import java.io.InputStream;
import java.net.URL;

public class Resources {
    public final InputStream getDictionary(String lang) {
        InputStream dict = null;
        if (lang.equalsIgnoreCase("en")) {
            dict = this.getClass().getResourceAsStream("/lemmatizer-dicts/language-tool/en-lemmatizer.txt");
        }
        if (lang.equalsIgnoreCase("es")) {
            dict = this.getClass().getResourceAsStream("/lemmatizer-dicts/freeling/es-lemmatizer.txt");
        }
        if (lang.equalsIgnoreCase("gl")) {
            dict = this.getClass().getResourceAsStream("/lemmatizer-dicts/ctag/gl-lemmatizer.txt");
        }
        return dict;
    }

    public final URL getBinaryDict(String lang) {
        URL dictURL = null;
        if (lang.equalsIgnoreCase("en")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/language-tool/english.dict");
        }
        if (lang.equalsIgnoreCase("es")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/freeling/spanish.dict");
        }
        if (lang.equalsIgnoreCase("gl")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/ctag/galician.dict");
        }
        return dictURL;
    }

    public final URL getBinaryTaggerDict(String lang) {
        URL dictURL = null;
        if (lang.equalsIgnoreCase("es")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/freeling/spanish-monosemic.dict");
        }
        if (lang.equalsIgnoreCase("gl")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/ctag/galician-monosemic.dict");
        }
        return dictURL;
    }

    public final String setTagConstant(String lang, String postag) {
        String constantTag = null;
        if (lang.equalsIgnoreCase("en") && postag.equalsIgnoreCase("NNP")) {
            constantTag = "NNP";
        }
        if (lang.equalsIgnoreCase("es") && postag.startsWith("NP")) {
            constantTag = "NP00000";
        }
        if (lang.equalsIgnoreCase("gl") && postag.startsWith("NP")) {
            constantTag = "NP000";
        }
        return constantTag;
    }
}

