/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos.train;

import opennlp.tools.util.TrainingParameters;

public class Flags {
    public static final int DEFAULT_BEAM_SIZE = 3;
    public static final int DEFAULT_FOLDS_VALUE = 10;
    public static final String DEFAULT_EVALUATE_MODEL = "off";
    public static final String DEFAULT_FEATURESET_FLAG = "Baseline";
    public static final String DEFAULT_DICT_PATH = "off";
    public static final int DEFAULT_DICT_CUTOFF = -1;
    public static final String DEFAULT_EVAL_FORMAT = "opennlp";

    private Flags() {
    }

    public static String getLanguage(TrainingParameters params) {
        String lang = null;
        if (params.getSettings().get("Language") == null) {
            Flags.langException();
        } else {
            lang = params.getSettings().get("Language");
        }
        return lang;
    }

    public static String getDataSet(String dataset, TrainingParameters params) {
        String trainSet = null;
        if (params.getSettings().get(dataset) == null) {
            Flags.datasetException();
        } else {
            trainSet = params.getSettings().get(dataset);
        }
        return trainSet;
    }

    public static String getModel(TrainingParameters params) {
        String model = null;
        if (params.getSettings().get("OutputModel") == null) {
            Flags.modelException();
        } else if (params.getSettings().get("OutputModel") != null && params.getSettings().get("OutputModel").length() == 0) {
            Flags.modelException();
        } else {
            model = params.getSettings().get("OutputModel");
        }
        return model;
    }

    public static String getCorpusFormat(TrainingParameters params) {
        String corpusFormat = null;
        if (params.getSettings().get("CorpusFormat") == null) {
            Flags.corpusFormatException();
        } else {
            corpusFormat = params.getSettings().get("CorpusFormat");
        }
        return corpusFormat;
    }

    public static Integer getBeamsize(TrainingParameters params) {
        Integer beamsize = null;
        beamsize = params.getSettings().get("BeamSize") == null ? Integer.valueOf(3) : Integer.valueOf(Integer.parseInt(params.getSettings().get("BeamSize")));
        return beamsize;
    }

    public static String getFeatureSet(TrainingParameters params) {
        String featureSet = null;
        featureSet = params.getSettings().get("FeatureSet") != null ? params.getSettings().get("FeatureSet") : DEFAULT_FEATURESET_FLAG;
        return featureSet;
    }

    public static String getDictionaryFeatures(TrainingParameters params) {
        String dictionaryFlag = null;
        dictionaryFlag = params.getSettings().get("DictionaryFeatures") != null ? params.getSettings().get("DictionaryFeatures") : "off";
        return dictionaryFlag;
    }

    public static Integer getAutoDictFeatures(TrainingParameters params) {
        String dictionaryFlag = null;
        dictionaryFlag = params.getSettings().get("AutoDictFeatures") != null ? params.getSettings().get("AutoDictFeatures") : Integer.toString(-1);
        return Integer.parseInt(dictionaryFlag);
    }

    public static Integer getNgramDictFeatures(TrainingParameters params) {
        String dictionaryFlag = null;
        dictionaryFlag = params.getSettings().get("NgramDictFeatures") != null ? params.getSettings().get("NgramDictFeatures") : Integer.toString(-1);
        return Integer.parseInt(dictionaryFlag);
    }

    public static Integer getFolds(TrainingParameters params) {
        Integer folds = null;
        folds = params.getSettings().get("Folds") == null ? Integer.valueOf(10) : Integer.valueOf(Integer.parseInt(params.getSettings().get("Folds")));
        return folds;
    }

    public static void modelException() {
        System.err.println("Please provide a model in the OutputModel field in the parameters file!");
        System.exit(1);
    }

    public static void langException() {
        System.err.println("Please fill in the Language field in the parameters file!");
        System.exit(1);
    }

    public static void datasetException() {
        System.err.println("Please specify your training/testing sets in the TrainSet and TestSet fields in the parameters file!");
        System.exit(1);
    }

    public static void corpusFormatException() {
        System.err.println("Please fill in CorpusFormat field in the parameters file!");
        System.exit(1);
    }

    public static void dictionaryException() {
        System.err.println("You need to set the --dictPath option to the dictionaries directory to use the dictTag option!");
        System.exit(1);
    }

    public static void dictionaryFeaturesException() {
        System.err.println("You need to specify the DictionaryFeatures in the parameters file to use the DictionaryPath!");
        System.exit(1);
    }

    public static boolean isDictionaryFeatures(TrainingParameters params) {
        String dictFeatures = Flags.getDictionaryFeatures(params);
        return !dictFeatures.equalsIgnoreCase("off");
    }
}

