/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.text.DecimalFormat;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;
import opennlp.tools.ml.model.IndexHashTable;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.Prior;

public abstract class AbstractModel
implements MaxentModel {
    protected IndexHashTable<String> pmap;
    protected String[] outcomeNames;
    protected EvalParameters evalParams;
    protected Prior prior;
    protected ModelType modelType;

    public AbstractModel(Context[] params, String[] predLabels, IndexHashTable<String> pmap, String[] outcomeNames) {
        this.pmap = pmap;
        this.outcomeNames = outcomeNames;
        this.evalParams = new EvalParameters(params, outcomeNames.length);
    }

    public AbstractModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        this.init(predLabels, outcomeNames);
        this.evalParams = new EvalParameters(params, outcomeNames.length);
    }

    public AbstractModel(Context[] params, String[] predLabels, String[] outcomeNames, int correctionConstant, double correctionParam) {
        this.init(predLabels, outcomeNames);
        this.evalParams = new EvalParameters(params, correctionParam, correctionConstant, outcomeNames.length);
    }

    private void init(String[] predLabels, String[] outcomeNames) {
        this.pmap = new IndexHashTable<String>(predLabels, 0.7);
        this.outcomeNames = outcomeNames;
    }

    @Override
    public final String getBestOutcome(double[] ocs) {
        int best = 0;
        for (int i = 1; i < ocs.length; ++i) {
            if (!(ocs[i] > ocs[best])) continue;
            best = i;
        }
        return this.outcomeNames[best];
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public final String getAllOutcomes(double[] ocs) {
        if (ocs.length != this.outcomeNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        StringBuilder sb = new StringBuilder(ocs.length * 2);
        sb.append(this.outcomeNames[0]).append("[").append(df.format(ocs[0])).append("]");
        for (int i = 1; i < ocs.length; ++i) {
            sb.append("  ").append(this.outcomeNames[i]).append("[").append(df.format(ocs[i])).append("]");
        }
        return sb.toString();
    }

    @Override
    public final String getOutcome(int i) {
        return this.outcomeNames[i];
    }

    @Override
    public int getIndex(String outcome) {
        for (int i = 0; i < this.outcomeNames.length; ++i) {
            if (!this.outcomeNames[i].equals(outcome)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNumOutcomes() {
        return this.evalParams.getNumOutcomes();
    }

    public final Object[] getDataStructures() {
        Object[] data = new Object[]{this.evalParams.getParams(), this.pmap, this.outcomeNames, (int)this.evalParams.getCorrectionConstant(), this.evalParams.getCorrectionParam()};
        return data;
    }

    public static enum ModelType {
        Maxent,
        Perceptron,
        MaxentQn,
        NaiveBayes;

    }
}

