/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.features;

import eus.ixa.ixa.pipe.nerc.dict.ClarkCluster;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;

public class ClarkFeatureGenerator
extends CustomFeatureGenerator
implements ArtifactToSerializerMapper {
    private ClarkCluster clarkCluster;
    private Map<String, String> attributes;
    public static String unknownClarkClass = "O";

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        String wordClass = this.getWordClass(tokens[index].toLowerCase());
        features.add(this.attributes.get("dict") + "=" + wordClass);
    }

    public String getWordClass(String token) {
        String clarkClass = this.clarkCluster.lookupToken(token);
        if (clarkClass == null) {
            clarkClass = unknownClarkClass;
        }
        return clarkClass;
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    @Override
    public void clearAdaptiveData() {
    }

    @Override
    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resourceProvider) throws InvalidFormatException {
        Object dictResource = resourceProvider.getResource(properties.get("dict"));
        if (!(dictResource instanceof ClarkCluster)) {
            throw new InvalidFormatException("Not a ClarkCluster resource for key: " + properties.get("dict"));
        }
        this.clarkCluster = (ClarkCluster)dictResource;
        this.attributes = properties;
    }

    @Override
    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() {
        HashMap<String, ClarkCluster.ClarkClusterSerializer> mapping = new HashMap<String, ClarkCluster.ClarkClusterSerializer>();
        mapping.put("clarkserializer", new ClarkCluster.ClarkClusterSerializer());
        return Collections.unmodifiableMap(mapping);
    }
}

