/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.train;

import eus.ixa.ixa.pipe.nerc.StringUtils;
import eus.ixa.ixa.pipe.nerc.dict.BrownCluster;
import eus.ixa.ixa.pipe.nerc.dict.ClarkCluster;
import eus.ixa.ixa.pipe.nerc.dict.Dictionary;
import eus.ixa.ixa.pipe.nerc.dict.LemmaResource;
import eus.ixa.ixa.pipe.nerc.dict.MFSResource;
import eus.ixa.ixa.pipe.nerc.dict.POSModelResource;
import eus.ixa.ixa.pipe.nerc.dict.Word2VecCluster;
import eus.ixa.ixa.pipe.nerc.features.XMLFeatureDescriptor;
import eus.ixa.ixa.pipe.nerc.train.AbstractTrainer;
import eus.ixa.ixa.pipe.nerc.train.Flags;
import eus.ixa.ixa.pipe.nerc.train.InputOutputUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ArtifactSerializer;

public class FixedTrainer
extends AbstractTrainer {
    public FixedTrainer(TrainingParameters params) throws IOException {
        super(params);
        this.createTrainer(params);
    }

    public void createTrainer(TrainingParameters params) throws IOException {
        String seqCodec = this.getSequenceCodec();
        SequenceCodec<String> sequenceCodec = TokenNameFinderFactory.instantiateSequenceCodec(seqCodec);
        String featureDescription = XMLFeatureDescriptor.createXMLFeatureDescriptor(params);
        System.err.println(featureDescription);
        byte[] featureGeneratorBytes = featureDescription.getBytes(Charset.forName("UTF-8"));
        Map<String, Object> resources = FixedTrainer.loadResources(params, featureGeneratorBytes);
        this.setNameClassifierFactory(TokenNameFinderFactory.create(TokenNameFinderFactory.class.getName(), featureGeneratorBytes, resources, sequenceCodec));
    }

    public static Map<String, Object> loadResources(TrainingParameters params, byte[] featureGenDescriptor) throws IOException {
        String mfsSerializerId;
        String[] mfsResources;
        String mfsResourcesPath;
        String lemmaSerializerId;
        String posSerializerId;
        String serializerId;
        HashMap<String, Object> resources = new HashMap<String, Object>();
        Map<String, ArtifactSerializer> artifactSerializers = TokenNameFinderModel.createArtifactSerializers();
        if (Flags.isBrownFeatures(params)) {
            String brownClusterPath = Flags.getBrownFeatures(params);
            serializerId = "brownserializer";
            List<File> brownClusterFiles = Flags.getClusterLexiconFiles(brownClusterPath);
            for (File brownClusterFile : brownClusterFiles) {
                String brownFilePath = brownClusterFile.getCanonicalPath();
                artifactSerializers.put(serializerId, new BrownCluster.BrownClusterSerializer());
                FixedTrainer.loadResource(serializerId, artifactSerializers, brownFilePath, featureGenDescriptor, resources);
            }
        }
        if (Flags.isClarkFeatures(params)) {
            String clarkClusterPath = Flags.getClarkFeatures(params);
            serializerId = "clarkserializer";
            List<File> clarkClusterFiles = Flags.getClusterLexiconFiles(clarkClusterPath);
            for (File clarkClusterFile : clarkClusterFiles) {
                String clarkFilePath = clarkClusterFile.getCanonicalPath();
                artifactSerializers.put(serializerId, new ClarkCluster.ClarkClusterSerializer());
                FixedTrainer.loadResource(serializerId, artifactSerializers, clarkFilePath, featureGenDescriptor, resources);
            }
        }
        if (Flags.isWord2VecClusterFeatures(params)) {
            String word2vecClusterPath = Flags.getWord2VecClusterFeatures(params);
            serializerId = "word2vecserializer";
            List<File> word2vecClusterFiles = Flags.getClusterLexiconFiles(word2vecClusterPath);
            for (File word2vecClusterFile : word2vecClusterFiles) {
                String word2vecFilePath = word2vecClusterFile.getCanonicalPath();
                artifactSerializers.put(serializerId, new Word2VecCluster.Word2VecClusterSerializer());
                FixedTrainer.loadResource(serializerId, artifactSerializers, word2vecFilePath, featureGenDescriptor, resources);
            }
        }
        if (Flags.isDictionaryFeatures(params)) {
            String dictDir = Flags.getDictionaryFeatures(params);
            serializerId = "dictionaryserializer";
            List<File> fileList = StringUtils.getFilesInDir(new File(dictDir));
            for (File dictFile : fileList) {
                String dictionaryPath = dictFile.getCanonicalPath();
                artifactSerializers.put(serializerId, new Dictionary.DictionarySerializer());
                FixedTrainer.loadResource(serializerId, artifactSerializers, dictionaryPath, featureGenDescriptor, resources);
            }
        }
        if (Flags.isMorphoFeatures(params)) {
            String morphoResourcesPath = Flags.getMorphoFeatures(params);
            String[] morphoResources = Flags.getMorphoResources(morphoResourcesPath);
            posSerializerId = "postagserializer";
            lemmaSerializerId = "lemmaserializer";
            artifactSerializers.put(posSerializerId, new POSModelResource.POSModelResourceSerializer());
            FixedTrainer.loadResource(posSerializerId, artifactSerializers, morphoResources[0], featureGenDescriptor, resources);
            artifactSerializers.put(lemmaSerializerId, new LemmaResource.LemmaResourceSerializer());
            FixedTrainer.loadResource(lemmaSerializerId, artifactSerializers, morphoResources[1], featureGenDescriptor, resources);
        }
        if (Flags.isSuperSenseFeatures(params)) {
            mfsResourcesPath = Flags.getSuperSenseFeatures(params);
            mfsResources = Flags.getSuperSenseResources(mfsResourcesPath);
            posSerializerId = "postagserializer";
            lemmaSerializerId = "lemmaserializer";
            mfsSerializerId = "mfsserializer";
            artifactSerializers.put(posSerializerId, new POSModelResource.POSModelResourceSerializer());
            FixedTrainer.loadResource(posSerializerId, artifactSerializers, mfsResources[0], featureGenDescriptor, resources);
            artifactSerializers.put(lemmaSerializerId, new LemmaResource.LemmaResourceSerializer());
            FixedTrainer.loadResource(lemmaSerializerId, artifactSerializers, mfsResources[1], featureGenDescriptor, resources);
            artifactSerializers.put(mfsSerializerId, new MFSResource.MFSResourceSerializer());
            FixedTrainer.loadResource(mfsSerializerId, artifactSerializers, mfsResources[2], featureGenDescriptor, resources);
        }
        if (Flags.isMFSFeatures(params)) {
            mfsResourcesPath = Flags.getMFSFeatures(params);
            mfsResources = Flags.getMFSResources(mfsResourcesPath);
            posSerializerId = "postagserializer";
            lemmaSerializerId = "lemmaserializer";
            mfsSerializerId = "mfsserializer";
            artifactSerializers.put(posSerializerId, new POSModelResource.POSModelResourceSerializer());
            FixedTrainer.loadResource(posSerializerId, artifactSerializers, mfsResources[0], featureGenDescriptor, resources);
            artifactSerializers.put(lemmaSerializerId, new LemmaResource.LemmaResourceSerializer());
            FixedTrainer.loadResource(lemmaSerializerId, artifactSerializers, mfsResources[1], featureGenDescriptor, resources);
            artifactSerializers.put(mfsSerializerId, new MFSResource.MFSResourceSerializer());
            FixedTrainer.loadResource(mfsSerializerId, artifactSerializers, mfsResources[2], featureGenDescriptor, resources);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadResource(String serializerId, Map<String, ArtifactSerializer> artifactSerializers, String resourcePath, byte[] featureGenDescriptor, Map<String, Object> resources) {
        File resourceFile = new File(resourcePath);
        if (resourceFile != null) {
            String resourceId = InputOutputUtils.normalizeLexiconName(resourceFile.getName());
            ArtifactSerializer serializer = artifactSerializers.get(serializerId);
            FileInputStream resourceIn = CmdLineUtil.openInFile(resourceFile);
            try {
                resources.put(resourceId, serializer.create(resourceIn));
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    ((InputStream)resourceIn).close();
                }
                catch (IOException e) {}
            }
        }
    }
}

