/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos.train;

import eus.ixa.ixa.pipe.pos.train.AbstractTrainer;
import eus.ixa.ixa.pipe.pos.train.BaselineFactory;
import eus.ixa.ixa.pipe.pos.train.Flags;
import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.TrainingParameters;

public class FixedTrainer
extends AbstractTrainer {
    public FixedTrainer(TrainingParameters params) throws IOException {
        super(params);
        String dictPath = Flags.getDictionaryFeatures(params);
        this.setPosTaggerFactory(this.getTrainerFactory(params));
        this.createTagDictionary(dictPath);
        this.createAutomaticDictionary(this.getDictSamples(), this.getDictCutOff());
    }

    private final POSTaggerFactory getTrainerFactory(TrainingParameters params) {
        POSTaggerFactory posTaggerFactory = null;
        String featureSet = Flags.getFeatureSet(params);
        Dictionary ngramDictionary = null;
        if (Flags.getNgramDictFeatures(params) != -1) {
            ngramDictionary = this.createNgramDictionary(this.getDictSamples(), this.getNgramDictCutOff());
        }
        if (featureSet.equalsIgnoreCase("Opennlp")) {
            try {
                posTaggerFactory = POSTaggerFactory.create(POSTaggerFactory.class.getName(), ngramDictionary, null);
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
        } else {
            try {
                posTaggerFactory = POSTaggerFactory.create(BaselineFactory.class.getName(), ngramDictionary, null);
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
        }
        return posTaggerFactory;
    }
}

