/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma;

import eus.ixa.ixa.pipe.lemma.DictionaryLemmatizer;
import eus.ixa.ixa.pipe.pos.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;

public class MorfologikLemmatizer
implements DictionaryLemmatizer {
    private final IStemmer dictLookup;
    private final Resources tagRetriever = new Resources();
    private final String lang;

    public MorfologikLemmatizer(URL dictURL, String aLang) throws IOException {
        this.dictLookup = new DictionaryLookup(Dictionary.read(dictURL));
        this.lang = aLang;
    }

    private HashMap<List<String>, String> getLemmaTagsDict(String word) {
        List<WordData> wdList = this.dictLookup.lookup(word);
        HashMap<List<String>, String> dictMap = new HashMap<List<String>, String>();
        for (WordData wd : wdList) {
            ArrayList<String> wordLemmaTags = new ArrayList<String>();
            wordLemmaTags.add(word);
            wordLemmaTags.add(wd.getTag().toString());
            dictMap.put(wordLemmaTags, wd.getStem().toString());
        }
        return dictMap;
    }

    private List<String> getDictKeys(String word, String postag) {
        ArrayList<String> keys = new ArrayList<String>();
        String constantTag = this.tagRetriever.setTagConstant(this.lang, postag);
        if (postag.startsWith(String.valueOf(constantTag))) {
            keys.addAll(Arrays.asList(word, postag));
        } else {
            keys.addAll(Arrays.asList(word.toLowerCase(), postag));
        }
        return keys;
    }

    private HashMap<List<String>, String> getDictMap(String word, String postag) {
        HashMap<List<String>, String> dictMap = new HashMap();
        String constantTag = this.tagRetriever.setTagConstant(this.lang, postag);
        dictMap = postag.startsWith(String.valueOf(constantTag)) ? this.getLemmaTagsDict(word) : this.getLemmaTagsDict(word.toLowerCase());
        return dictMap;
    }

    @Override
    public String lemmatize(String word, String postag) {
        String lemma = null;
        List<String> keys = this.getDictKeys(word, postag);
        HashMap<List<String>, String> dictMap = this.getDictMap(word, postag);
        String keyValue = dictMap.get(keys);
        String constantTag = this.tagRetriever.setTagConstant(this.lang, postag);
        lemma = keyValue != null ? keyValue : (keyValue == null && postag.startsWith(String.valueOf(constantTag)) ? word : (keyValue == null && word.toUpperCase().equals(word) ? word : word.toLowerCase()));
        return lemma;
    }
}

