/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.features;

import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;

public class WordShapeSuperSenseFeatureGenerator
extends CustomFeatureGenerator {
    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        String normalizedToken = WordShapeSuperSenseFeatureGenerator.normalize(tokens[index]);
        features.add("sh=" + normalizedToken);
        features.add("w,sh=" + tokens[index].toLowerCase() + "," + normalizedToken);
    }

    public static String normalize(String token) {
        String normalizedToken = "";
        int n = -1;
        boolean addedStar = false;
        for (int i = 0; i < token.length(); ++i) {
            char c;
            char currentCharacter = token.charAt(i);
            char charType = currentCharacter >= 'A' && currentCharacter <= 'Z' ? (char)'X' : (currentCharacter >= 'a' && currentCharacter <= 'z' ? (char)'x' : (currentCharacter >= '0' && currentCharacter <= '9' ? (char)'d' : (char)currentCharacter));
            if (charType == c) {
                if (!addedStar) {
                    normalizedToken = normalizedToken + "*";
                    addedStar = true;
                }
            } else {
                addedStar = false;
                normalizedToken = normalizedToken + Character.toString(charType);
            }
            c = charType;
        }
        return normalizedToken;
    }

    @Override
    public void clearAdaptiveData() {
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
    }

    @Override
    public void init(Map<String, String> properties, FeatureGeneratorResourceProvider resources) throws InvalidFormatException {
    }
}

