/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.nerc.train;

import eus.ixa.ixa.pipe.nerc.features.XMLFeatureDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.TrainingParameters;

public class Flags {
    public static final boolean DEBUG = false;
    public static final String DEFAULT_FEATURE_FLAG = "no";
    public static final String CHAR_NGRAM_RANGE = "2:5";
    public static final String DEFAULT_WINDOW = "2:2";
    public static final String DEFAULT_MORPHO_RANGE = "pos,posclass,lemma";
    public static final String DEFAULT_MFS_RANGE = "pos,posclass,lemma,mfs,no";
    public static final String DEFAULT_SUPERSENSE_RANGE = "mfs,monosemic";
    public static final int DEFAULT_BEAM_SIZE = 3;
    public static final int DEFAULT_FOLDS_VALUE = 10;
    public static final String DEFAULT_EVALUATE_MODEL = "off";
    public static final String DEFAULT_NE_TYPES = "off";
    public static final String DEFAULT_LEXER = "off";
    public static final String DEFAULT_DICT_OPTION = "off";
    public static final String DEFAULT_DICT_PATH = "off";
    public static final String DEFAULT_OUTPUT_FORMAT = "naf";
    public static final String DEFAULT_SEQUENCE_CODEC = "BILOU";
    public static final String DEFAULT_EVAL_FORMAT = "conll02";
    public static final String DEFAULT_TASK = "ner";
    public static final String DEFAULT_HOSTNAME = "localhost";

    private Flags() {
    }

    public static String getLanguage(TrainingParameters params) {
        String lang = null;
        if (params.getSettings().get("Language") == null) {
            Flags.langException();
        } else {
            lang = params.getSettings().get("Language");
        }
        return lang;
    }

    public static String getDataSet(String dataset, TrainingParameters params) {
        String trainSet = null;
        if (params.getSettings().get(dataset) == null) {
            Flags.datasetException();
        } else {
            trainSet = params.getSettings().get(dataset);
        }
        return trainSet;
    }

    public static String getModel(TrainingParameters params) {
        String model = null;
        if (params.getSettings().get("OutputModel") == null) {
            Flags.modelException();
        } else if (params.getSettings().get("OutputModel") != null && params.getSettings().get("OutputModel").length() == 0) {
            Flags.modelException();
        } else {
            model = params.getSettings().get("OutputModel");
        }
        return model;
    }

    public static String getCorpusFormat(TrainingParameters params) {
        String corpusFormat = null;
        if (params.getSettings().get("CorpusFormat") == null) {
            Flags.corpusFormatException();
        } else {
            corpusFormat = params.getSettings().get("CorpusFormat");
        }
        return corpusFormat;
    }

    public static String getOutputFormat(TrainingParameters params) {
        String outFormatOption = null;
        outFormatOption = params.getSettings().get("OutputFormat") != null ? params.getSettings().get("OutputFormat") : DEFAULT_OUTPUT_FORMAT;
        return outFormatOption;
    }

    public static Integer getBeamsize(TrainingParameters params) {
        Integer beamsize = null;
        beamsize = params.getSettings().get("BeamSize") == null ? Integer.valueOf(3) : Integer.valueOf(Integer.parseInt(params.getSettings().get("BeamSize")));
        return beamsize;
    }

    public static Integer getFolds(TrainingParameters params) {
        Integer beamsize = null;
        beamsize = params.getSettings().get("Folds") == null ? Integer.valueOf(10) : Integer.valueOf(Integer.parseInt(params.getSettings().get("Folds")));
        return beamsize;
    }

    public static String getSequenceCodec(TrainingParameters params) {
        String seqCodec = null;
        seqCodec = params.getSettings().get("SequenceCodec") == null ? DEFAULT_SEQUENCE_CODEC : params.getSettings().get("SequenceCodec");
        return seqCodec;
    }

    public static String getClearTrainingFeatures(TrainingParameters params) {
        String clearFeatures = null;
        clearFeatures = params.getSettings().get("ClearTrainingFeatures") == null ? DEFAULT_FEATURE_FLAG : params.getSettings().get("ClearTrainingFeatures");
        return clearFeatures;
    }

    public static String getClearEvaluationFeatures(TrainingParameters params) {
        String clearFeatures = null;
        clearFeatures = params.getSettings().get("ClearEvaluationFeatures") == null ? DEFAULT_FEATURE_FLAG : params.getSettings().get("ClearEvaluationFeatures");
        return clearFeatures;
    }

    public static String getWindow(TrainingParameters params) {
        String windowFlag = null;
        windowFlag = params.getSettings().get("Window") == null ? DEFAULT_WINDOW : params.getSettings().get("Window");
        return windowFlag;
    }

    public static String getTokenFeatures(TrainingParameters params) {
        String tokenFlag = null;
        tokenFlag = params.getSettings().get("TokenFeatures") != null ? params.getSettings().get("TokenFeatures") : DEFAULT_FEATURE_FLAG;
        return tokenFlag;
    }

    public static String getTokenClassFeatures(TrainingParameters params) {
        String tokenClassFlag = null;
        tokenClassFlag = params.getSettings().get("TokenClassFeatures") != null ? params.getSettings().get("TokenClassFeatures") : DEFAULT_FEATURE_FLAG;
        return tokenClassFlag;
    }

    public static String getWordShapeSuperSenseFeatures(TrainingParameters params) {
        String tokenClassFlag = null;
        tokenClassFlag = params.getSettings().get("WordShapeSuperSenseFeatures") != null ? params.getSettings().get("WordShapeSuperSenseFeatures") : DEFAULT_FEATURE_FLAG;
        return tokenClassFlag;
    }

    public static String getOutcomePriorFeatures(TrainingParameters params) {
        String outcomePriorFlag = null;
        outcomePriorFlag = params.getSettings().get("OutcomePriorFeatures") != null ? params.getSettings().get("OutcomePriorFeatures") : DEFAULT_FEATURE_FLAG;
        return outcomePriorFlag;
    }

    public static String getPreviousMapFeatures(TrainingParameters params) {
        String previousMapFlag = null;
        previousMapFlag = params.getSettings().get("PreviousMapFeatures") != null ? params.getSettings().get("PreviousMapFeatures") : DEFAULT_FEATURE_FLAG;
        return previousMapFlag;
    }

    public static String getSentenceFeatures(TrainingParameters params) {
        String sentenceFlag = null;
        sentenceFlag = params.getSettings().get("SentenceFeatures") != null ? params.getSettings().get("SentenceFeatures") : DEFAULT_FEATURE_FLAG;
        return sentenceFlag;
    }

    public static String getPreffixFeatures(TrainingParameters params) {
        String prefixFlag = null;
        prefixFlag = params.getSettings().get("PrefixFeatures") != null ? params.getSettings().get("PrefixFeatures") : DEFAULT_FEATURE_FLAG;
        return prefixFlag;
    }

    public static String getSuffixFeatures(TrainingParameters params) {
        String suffixFlag = null;
        suffixFlag = params.getSettings().get("SuffixFeatures") != null ? params.getSettings().get("SuffixFeatures") : DEFAULT_FEATURE_FLAG;
        return suffixFlag;
    }

    public static String getBigramClassFeatures(TrainingParameters params) {
        String bigramClassFlag = null;
        bigramClassFlag = params.getSettings().get("BigramClassFeatures") != null ? params.getSettings().get("BigramClassFeatures") : DEFAULT_FEATURE_FLAG;
        return bigramClassFlag;
    }

    public static String getTrigramClassFeatures(TrainingParameters params) {
        String trigramClassFlag = null;
        trigramClassFlag = params.getSettings().get("TrigramClassFeatures") != null ? params.getSettings().get("TrigramClassFeatures") : DEFAULT_FEATURE_FLAG;
        return trigramClassFlag;
    }

    public static String getFourgramClassFeatures(TrainingParameters params) {
        String fourgramClassFlag = null;
        fourgramClassFlag = params.getSettings().get("FourgramClassFeatures") != null ? params.getSettings().get("FourgramClassFeatures") : DEFAULT_FEATURE_FLAG;
        return fourgramClassFlag;
    }

    public static String getFivegramClassFeatures(TrainingParameters params) {
        String fivegramClassFlag = null;
        fivegramClassFlag = params.getSettings().get("FivegramClassFeatures") != null ? params.getSettings().get("FivegramClassFeatures") : DEFAULT_FEATURE_FLAG;
        return fivegramClassFlag;
    }

    public static String getCharNgramFeatures(TrainingParameters params) {
        String charNgramFlag = null;
        charNgramFlag = params.getSettings().get("CharNgramFeatures") != null ? params.getSettings().get("CharNgramFeatures") : DEFAULT_FEATURE_FLAG;
        return charNgramFlag;
    }

    public static String getCharNgramFeaturesRange(TrainingParameters params) {
        String charNgramRangeFlag = null;
        charNgramRangeFlag = params.getSettings().get("CharNgramFeaturesRange") != null ? params.getSettings().get("CharNgramFeaturesRange") : CHAR_NGRAM_RANGE;
        return charNgramRangeFlag;
    }

    public static String getDictionaryFeatures(TrainingParameters params) {
        String dictionaryFlag = null;
        dictionaryFlag = params.getSettings().get("DictionaryFeatures") != null ? params.getSettings().get("DictionaryFeatures") : DEFAULT_FEATURE_FLAG;
        return dictionaryFlag;
    }

    public static String getClarkFeatures(TrainingParameters params) {
        String distSimFlag = null;
        distSimFlag = params.getSettings().get("ClarkClusterFeatures") != null ? params.getSettings().get("ClarkClusterFeatures") : DEFAULT_FEATURE_FLAG;
        return distSimFlag;
    }

    public static String getWord2VecClusterFeatures(TrainingParameters params) {
        String word2vecFlag = null;
        word2vecFlag = params.getSettings().get("Word2VecClusterFeatures") != null ? params.getSettings().get("Word2VecClusterFeatures") : DEFAULT_FEATURE_FLAG;
        return word2vecFlag;
    }

    public static String getBrownFeatures(TrainingParameters params) {
        String brownFlag = null;
        brownFlag = params.getSettings().get("BrownClusterFeatures") != null ? params.getSettings().get("BrownClusterFeatures") : DEFAULT_FEATURE_FLAG;
        return brownFlag;
    }

    public static String getMorphoFeatures(TrainingParameters params) {
        String morphoFlag = null;
        morphoFlag = params.getSettings().get("MorphoFeatures") != null ? params.getSettings().get("MorphoFeatures") : DEFAULT_FEATURE_FLAG;
        return morphoFlag;
    }

    public static String[] getMorphoResources(String morphoFlag) {
        String[] morphoFlagArray = morphoFlag.split(",");
        if (morphoFlagArray.length != 2) {
            System.err.println("MorphoFeatures resources requires two fields but only got " + morphoFlagArray.length);
            System.exit(1);
        }
        return morphoFlagArray;
    }

    public static String getMorphoFeaturesRange(TrainingParameters params) {
        String lemmaRangeFlag = null;
        lemmaRangeFlag = params.getSettings().get("MorphoFeaturesRange") != null ? params.getSettings().get("MorphoFeaturesRange") : DEFAULT_MORPHO_RANGE;
        return lemmaRangeFlag;
    }

    public static String[] processMorphoFeaturesRange(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 3) {
            System.err.println("MorphoFeaturesRange requires three fields but only got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String getSuperSenseFeatures(TrainingParameters params) {
        String mfsFlag = null;
        mfsFlag = params.getSettings().get("SuperSenseFeatures") != null ? params.getSettings().get("SuperSenseFeatures") : DEFAULT_FEATURE_FLAG;
        return mfsFlag;
    }

    public static String getMFSFeatures(TrainingParameters params) {
        String mfsFlag = null;
        mfsFlag = params.getSettings().get("MFSFeatures") != null ? params.getSettings().get("MFSFeatures") : DEFAULT_FEATURE_FLAG;
        return mfsFlag;
    }

    public static String[] getSuperSenseResources(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 3) {
            System.err.println("SuperSense resources requires three fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String[] getMFSResources(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 3) {
            System.err.println("MFS resources requires three fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String getSuperSenseFeaturesRange(TrainingParameters params) {
        String mfsRangeFlag = null;
        mfsRangeFlag = params.getSettings().get("SuperSenseFeaturesRange") != null ? params.getSettings().get("SuperSenseFeaturesRange") : DEFAULT_SUPERSENSE_RANGE;
        return mfsRangeFlag;
    }

    public static String getMFSFeaturesRange(TrainingParameters params) {
        String mfsRangeFlag = null;
        mfsRangeFlag = params.getSettings().get("MFSFeaturesRange") != null ? params.getSettings().get("MFSFeaturesRange") : DEFAULT_SUPERSENSE_RANGE;
        return mfsRangeFlag;
    }

    public static String[] processSuperSenseFeaturesRange(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 2) {
            System.err.println("SuperSenseFeaturesRange requires two fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static String[] processMFSFeaturesRange(String mfsFlag) {
        String[] mfsFlagArray = mfsFlag.split(",");
        if (mfsFlagArray.length != 5) {
            System.err.println("MFSFeaturesRange requires five fields but got " + mfsFlagArray.length);
            System.exit(1);
        }
        return mfsFlagArray;
    }

    public static List<File> getClusterLexiconFiles(String clusterPath) {
        String[] clusterPaths;
        ArrayList<File> clusterLexicons = new ArrayList<File>();
        for (String clusterName : clusterPaths = clusterPath.split(",")) {
            clusterLexicons.add(new File(clusterName));
        }
        return clusterLexicons;
    }

    public static void devSetException() {
        System.err.println("UseDevSet options in the parameters file if CrossEval is activated!");
        System.exit(1);
    }

    public static void modelException() {
        System.err.println("Please provide a model in the OutputModel field in the parameters file!");
        System.exit(1);
    }

    public static void langException() {
        System.err.println("Please fill in the Language field in the parameters file!");
        System.exit(1);
    }

    public static void datasetException() {
        System.err.println("Please specify your training/testing sets in the TrainSet and TestSet fields in the parameters file!");
        System.exit(1);
    }

    public static void corpusFormatException() {
        System.err.println("Please fill in CorpusFormat field in the parameters file!");
        System.exit(1);
    }

    public static void dictionaryException() {
        System.err.println("You need to set the --dictPath option to the dictionaries directory to use the dictTag option!");
        System.exit(1);
    }

    public static void dictionaryFeaturesException() {
        System.err.println("You need to specify the DictionaryFeatures in the parameters file to use the DictionaryPath!");
        System.exit(1);
    }

    public static boolean isMorphoFeatures(TrainingParameters params) {
        String morphoFeatures = Flags.getMorphoFeatures(params);
        return !morphoFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isSuperSenseFeatures(TrainingParameters params) {
        String mfsFeatures = Flags.getSuperSenseFeatures(params);
        return !mfsFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isMFSFeatures(TrainingParameters params) {
        String mfsFeatures = Flags.getMFSFeatures(params);
        return !mfsFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isWord2VecClusterFeatures(TrainingParameters params) {
        String word2vecClusterFeatures = Flags.getWord2VecClusterFeatures(params);
        return !word2vecClusterFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isClarkFeatures(TrainingParameters params) {
        String clarkFeatures = Flags.getClarkFeatures(params);
        return !clarkFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isBrownFeatures(TrainingParameters params) {
        String brownFeatures = Flags.getBrownFeatures(params);
        return !brownFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isDictionaryFeatures(TrainingParameters params) {
        String dictFeatures = Flags.getDictionaryFeatures(params);
        return !dictFeatures.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isCharNgramClassFeature(TrainingParameters params) {
        XMLFeatureDescriptor.setNgramRange(params);
        String charngramParam = Flags.getCharNgramFeatures(params);
        return !charngramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isFivegramClassFeature(TrainingParameters params) {
        String fivegramParam = Flags.getFivegramClassFeatures(params);
        return !fivegramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isFourgramClassFeature(TrainingParameters params) {
        String fourgramParam = Flags.getFourgramClassFeatures(params);
        return !fourgramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isTrigramClassFeature(TrainingParameters params) {
        String trigramParam = Flags.getTrigramClassFeatures(params);
        return !trigramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isBigramClassFeature(TrainingParameters params) {
        String bigramParam = Flags.getBigramClassFeatures(params);
        return !bigramParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isSuffixFeature(TrainingParameters params) {
        String suffixParam = Flags.getSuffixFeatures(params);
        return !suffixParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isPrefixFeature(TrainingParameters params) {
        String prefixParam = Flags.getPreffixFeatures(params);
        return !prefixParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isSentenceFeature(TrainingParameters params) {
        String sentenceParam = Flags.getSentenceFeatures(params);
        return !sentenceParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isPreviousMapFeature(TrainingParameters params) {
        String previousMapParam = Flags.getPreviousMapFeatures(params);
        return !previousMapParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isOutcomePriorFeature(TrainingParameters params) {
        String outcomePriorParam = Flags.getOutcomePriorFeatures(params);
        return !outcomePriorParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isWordShapeSuperSenseFeature(TrainingParameters params) {
        String tokenParam = Flags.getWordShapeSuperSenseFeatures(params);
        return !tokenParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isTokenClassFeature(TrainingParameters params) {
        String tokenParam = Flags.getTokenClassFeatures(params);
        return !tokenParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }

    public static boolean isTokenFeature(TrainingParameters params) {
        String tokenParam = Flags.getTokenFeatures(params);
        return !tokenParam.equalsIgnoreCase(DEFAULT_FEATURE_FLAG);
    }
}

