/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos;

import eus.ixa.ixa.pipe.pos.Morpheme;
import eus.ixa.ixa.pipe.pos.MorphoFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;

public class MorphoTagger {
    private final POSTaggerME posTagger;
    private static ConcurrentHashMap<String, POSModel> posModels = new ConcurrentHashMap();
    private MorphoFactory morphoFactory;

    public MorphoTagger(Properties props) {
        String lang = props.getProperty("language");
        String model = props.getProperty("model");
        POSModel posModel = this.loadModel(lang, model);
        this.posTagger = new POSTaggerME(posModel);
    }

    public MorphoTagger(Properties props, MorphoFactory aMorphoFactory) {
        String lang = props.getProperty("language");
        String model = props.getProperty("model");
        POSModel posModel = this.loadModel(lang, model);
        this.posTagger = new POSTaggerME(posModel);
        this.morphoFactory = aMorphoFactory;
    }

    public final List<Morpheme> getMorphemes(String[] tokens) {
        List<String> origPosTags = this.posAnnotate(tokens);
        List<Morpheme> morphemes = this.getMorphemesFromStrings(origPosTags, tokens);
        return morphemes;
    }

    public final List<String> posAnnotate(String[] tokens) {
        String[] annotatedText = this.posTagger.tag(tokens);
        ArrayList<String> posTags = new ArrayList<String>(Arrays.asList(annotatedText));
        return posTags;
    }

    public final List<Morpheme> getMorphemesFromStrings(List<String> posTags, String[] tokens) {
        ArrayList<Morpheme> morphemes = new ArrayList<Morpheme>();
        for (int i = 0; i < posTags.size(); ++i) {
            String word = tokens[i];
            String tag = posTags.get(i);
            Morpheme morpheme = this.morphoFactory.createMorpheme(word, tag);
            morphemes.add(morpheme);
        }
        return morphemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private POSModel loadModel(String lang, String model) {
        long lStartTime = new Date().getTime();
        try {
            ConcurrentHashMap<String, POSModel> concurrentHashMap = posModels;
            synchronized (concurrentHashMap) {
                if (!posModels.containsKey(lang)) {
                    posModels.put(lang, new POSModel(new FileInputStream(model)));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long lEndTime = new Date().getTime();
        long difference = lEndTime - lStartTime;
        System.err.println("ixa-pipe-pos model loaded in: " + difference + " miliseconds ... [DONE]");
        return posModels.get(lang);
    }
}

