/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.Span;

public final class StringUtils {
    private StringUtils() {
        throw new AssertionError((Object)"This class is not meant to be instantiated!");
    }

    public static List<Integer> exactTokenFinderIgnoreCase(String pattern, String[] tokens) {
        String[] patternTokens = pattern.split(" ");
        int patternLength = patternTokens.length;
        int sentenceLength = tokens.length;
        ArrayList<Integer> neTokens = new ArrayList<Integer>();
        for (int j = 0; j <= sentenceLength - patternLength; ++j) {
            int i;
            for (i = 0; i < patternLength && patternTokens[i].equalsIgnoreCase(tokens[i + j]); ++i) {
            }
            if (i < patternLength) continue;
            neTokens.add(j);
            neTokens.add(i + j);
        }
        return neTokens;
    }

    public static List<Integer> exactTokenFinder(String pattern, String[] tokens) {
        String[] patternTokens = pattern.split(" ");
        int patternLength = patternTokens.length;
        int sentenceLength = tokens.length;
        ArrayList<Integer> neTokens = new ArrayList<Integer>();
        for (int j = 0; j <= sentenceLength - patternLength; ++j) {
            int i;
            for (i = 0; i < patternLength && patternTokens[i].equals(tokens[i + j]); ++i) {
            }
            if (i < patternLength) continue;
            neTokens.add(j);
            neTokens.add(i + j);
        }
        return neTokens;
    }

    public static List<Integer> exactStringFinder(String pattern, String sentence) {
        char[] patternArray = pattern.toCharArray();
        char[] sentenceArray = sentence.toCharArray();
        int patternLength = patternArray.length;
        int sentenceLength = sentenceArray.length;
        ArrayList<Integer> neChars = new ArrayList<Integer>();
        for (int j = 0; j <= sentenceLength - patternLength; ++j) {
            int i;
            for (i = 0; i < patternLength && patternArray[i] == sentenceArray[i + j]; ++i) {
            }
            if (i < patternLength) continue;
            neChars.add(j);
            neChars.add(i + j);
        }
        return neChars;
    }

    public static String getStringFromSpan(Span reducedSpan, String[] tokens) {
        StringBuilder sb = new StringBuilder();
        for (int si = reducedSpan.getStart(); si < reducedSpan.getEnd(); ++si) {
            sb.append(tokens[si]).append(" ");
        }
        return sb.toString().trim();
    }

    public static String getStringFromTokens(String[] tokens) {
        StringBuilder sb = new StringBuilder();
        for (String tok : tokens) {
            sb.append(tok).append(" ");
        }
        return sb.toString().trim();
    }

    public static List<File> getFilesInDir(File inputPath) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (File aFile : Files.fileTreeTraverser().preOrderTraversal(inputPath)) {
            if (!aFile.isFile()) continue;
            fileList.add(aFile);
        }
        return fileList;
    }
}

