/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos.eval;

import eus.ixa.ixa.pipe.pos.train.InputOutputUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.cmdline.postag.POSTaggerFineGrainedReportListener;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.ObjectStream;

public class Evaluate {
    private final ObjectStream<POSSample> testSamples;
    private static POSModel posModel;
    private final POSTaggerME posTagger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Evaluate(String testData, String model) throws IOException {
        ObjectStream<String> testStream = InputOutputUtils.readFileIntoMarkableStreamFactory(testData);
        this.testSamples = new WordTagSampleStream(testStream);
        FileInputStream trainedModelInputStream = null;
        try {
            if (posModel == null) {
                trainedModelInputStream = new FileInputStream(model);
                posModel = new POSModel(trainedModelInputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (trainedModelInputStream != null) {
                try {
                    ((InputStream)trainedModelInputStream).close();
                }
                catch (IOException e) {
                    System.err.println("Could not load model!");
                }
            }
        }
        this.posTagger = new POSTaggerME(posModel);
    }

    public final void evaluate() throws IOException {
        POSEvaluator evaluator = new POSEvaluator(this.posTagger, new POSTaggerEvaluationMonitor[0]);
        evaluator.evaluate(this.testSamples);
        System.out.println(evaluator.getWordAccuracy());
    }

    public final void detailEvaluate() throws IOException {
        LinkedList<POSTaggerFineGrainedReportListener> listeners = new LinkedList<POSTaggerFineGrainedReportListener>();
        POSTaggerFineGrainedReportListener detailedFListener = new POSTaggerFineGrainedReportListener(System.out);
        listeners.add(detailedFListener);
        POSEvaluator evaluator = new POSEvaluator(this.posTagger, listeners.toArray(new POSTaggerEvaluationMonitor[listeners.size()]));
        evaluator.evaluate(this.testSamples);
        detailedFListener.writeReport();
    }

    public final void evalError() throws IOException {
        LinkedList<POSEvaluationErrorListener> listeners = new LinkedList<POSEvaluationErrorListener>();
        listeners.add(new POSEvaluationErrorListener());
        POSEvaluator evaluator = new POSEvaluator(this.posTagger, listeners.toArray(new POSTaggerEvaluationMonitor[listeners.size()]));
        evaluator.evaluate(this.testSamples);
        System.out.println(evaluator.getWordAccuracy());
    }
}

